#delimit;
clear;
estimates clear;

 
*** Baseline Specs: Use Our Measures, Which are Slight Deviation from HR ***;
*** Examine 2002 and 2003, with and without covariates ***;

log using nclb_tab3sci.log, replace;


global outcomes "mean pct_bsc pct10 pct90";
*global outcomes "mean pct10 pct25 pct50 pct75 pct90 pct_bsc pct_prof pct_adv";



foreach s in sci4 sci8 {;

    use ${data}tmpall.dta, clear;

    keep if type=="Public" & state!="National Public" & state!="National" & samp==1 &
        	`s'==1 & group=="All" &ac_base==1& scale=="Composite Scale";

    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000; 


    foreach y of global outcomes {;

     disp "**** SUBJECT `s'  GROUP All  OUTCOME `y' ******";

 ******4th grade science models******;
   if "`s'"=="sci4" {;
   disp "*** PANEL A: CA by 2001, no exclusions ***";
   disp "*** Simple DiD for grade 4 science ***";

        gen noacc=yearca>2001|yearca==.;
        gen nclb03_noacc=noacc*nclb03;

        capture noisily areg `y' noacc nclb03 nclb03_noacc
		 excl excl_sq , a(statecode) cl(statecode);
         estimates store Aa`s'_`y' ;

	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);

	drop noacc nclb03_noacc;

    disp "*** PANEL B:  CA by 1998, exclude CA 99-01 ***";
        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;

        capture noisily areg `y' noacc nclb03 nclb03_noacc
		 excl excl_sq if exca9901==0, a(statecode) cl(statecode);
         estimates store Ba`s'_`y' ;

	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);

	drop noacc nclb03_noacc;

     disp "*** PANEL C:  CA interacted with year ***";

        gen nyracc=.;
        replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;

        capture noisily areg `y' 
        nyracc nclb03 nclb03_nyracc 
	        excl excl_sq, a(statecode) cl(statecode);

          estimates store Ca`s'_`y' ;

	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);
         
	disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";

          disp "** effect as of 2007, relative to state with acct in 1997 **";
          capture noisily lincom nclb03_nyracc*6;

          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

          drop nyracc nclb03_nyracc;

   };

 ******8th grade science models******;
   if "`s'"=="sci8" {;
	gen yy_05=year==2005; gen yy_00=year==2000;

   disp "*** PANEL A: CA by 2001, no exclusions ***";
        
        gen noacc=yearca>2001|yearca==.;
        gen nclb03_noacc=noacc*nclb03;

*        capture noisily areg `y' noacc trend trend_noacc
		 nclb03 nclb03_noacc excl excl_sq, a(statecode) cl(statecode);
        capture noisily areg `y' noacc yy_05 yy_00 nclb03_noacc
		 excl excl_sq , a(statecode) cl(statecode);

         estimates store Aa`s'_`y' ;

	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);

          drop noacc nclb03_noacc;


    disp "*** PANEL B:  CA by 1998, exclude CA 99-01 ***";
        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;

*        capture noisily areg `y' noacc trend trend_noacc
	 nclb03 nclb03_noacc excl excl_sq if exca9901==0, a(statecode) cl(statecode);
        capture noisily areg `y' noacc yy_05 yy_00 nclb03_noacc
		 excl excl_sq , a(statecode) cl(statecode);

         estimates store Ba`s'_`y' ;
         
	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);

          drop noacc nclb03_noacc;


     disp "*** PANEL C:  CA interacted with year ***";

        gen nyracc=.;
        replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;

*        capture noisily areg `y' 
        nyracc trend trend_nyracc nclb03 nclb03_nyracc 
        excl excl_sq, a(statecode) cl(statecode);

        capture noisily areg `y' 
        nyracc nclb03 nclb03_nyracc 
	        excl excl_sq, a(statecode) cl(statecode);

        capture noisily areg `y' yy_05 yy_00
        nyracc nclb03_nyracc 
	        excl excl_sq, a(statecode) cl(statecode);

          estimates store Ca`s'_`y' ;

	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);
         
	disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";

          disp "** effect as of 2007, relative to state with acct in 1997 **";
          capture noisily lincom nclb03_nyracc*6;

          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

          drop nyracc nclb03_nyracc yy_*;

    };

         

  };


};
global outcomes "mean pct_bsc pct10 pct90"; 
     estout Aasci4_mean Aasci8_mean Aasci4_pct_bsc Aasci8_pct_bsc
     	    Aasci4_pct10 Aasci8_pct10 Aasci4_pct90 Aasci8_pct90
	    Basci4_mean Basci8_mean Basci4_pct_bsc Basci8_pct_bsc
     	    Basci4_pct10 Basci8_pct10 Basci4_pct90 Basci8_pct90
	    Casci4_mean Casci8_mean Casci4_pct_bsc Casci8_pct_bsc
     	    Casci4_pct10 Casci8_pct10 Casci4_pct90 Casci8_pct90
       using ${tabs}nclb_tab3sci_All.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_noacc nclb03_nyracc)
       order(nclb03_noacc nclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt basemn N_clust N, fmt(3 3 3 3 0 0)
       		  layout(@ `"(@)"' @ @ @ @));
       estimates clear;


log close;

