/*************
summary stats
*************/


#delimit;
clear;
estimates clear;


log using nclb_tab1.log, replace;

foreach s in math4 math8 read4 read8 {; /*sci4 sci8*/

    use ${data}tmpall.dta, clear;

    keep if type=="Public" & state!="National Public" & state!="National" & samp==1 &
                `s'==1&ac_base==1 & scale=="Composite Scale" & group=="All";

    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000;
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002;
    local baseyr=1992;
    if "`s'"=="read4" local baseyr=1994;
    if "`s'"=="read8" local baseyr=1998;

 di "***subject - `s'***";


	sum mean if year==`preyr' [aw=enrollment]; local tmp00=r(mean);
	sum mean if year==`baseyr' [aw=enrollment]; local tmp92=r(mean);
	  di (`tmp00'-`tmp92')/`tmp92';


    tabstat excl povpct pup_tea curexp ipct_fl pct_white pct_black pct_hisp pct_asian
	     if year==`preyr' [aw=enrollment],
	    stats(mean sd N min max) col(stats);  

   egen tags=tag(statecode);
   tab tags;

   egen tagsy=tag(statecode year);
   tab tagsy;

use nclb_data.dta, clear;
gen math4=subject=="Math"&grade==4;
gen math8=subject=="Math"&grade==8;
gen read4=subject=="Reading"&grade==4;
gen read8=subject=="Reading"&grade==8;
gen ac_base=( (ac_perm==1 & year==2000)|(year!=2000) )
                                                      if subject=="Math"|subj=="Science";
replace ac_base=( (ac_perm==1 & year==1998)|(year!=1998) ) if subject=="Reading";


    keep if type=="Public" & state=="National Public"& ac_base==1 &
                `s'==1 & scale=="Composite Scale" & group=="All Students";

        sum mean if year==`preyr' ; local tmp00=r(mean);
        sum mean if year==`baseyr' ; local tmp92=r(mean);
          di (`tmp00'-`tmp92')/`tmp92';


*    tabstat excl povpct pup_tea curexp ipct_fl pct_white pct_black pct_hisp pct_asian
             if year==`preyr' [aw=enrollment],
            stats(mean sd N min max) col(stats);


};




