#delimit;
clear;

** FIGURES ***;

log using nclb_fig.log, replace;
global outcomes "mean pct_bsc unemprate";

insheet using "${data_update}tmpall_update.txt", names;
save "${data_update}tmpall_update.dta", replace;
 
foreach s in math4 math8 read4 read8 sci4 sci8 {;
 foreach r in All {;
  foreach out of global outcomes {; 

   if "`out'"=="mean" local ytitle="NAEP scale score";
   if "`out'"=="pct_bsc" local ytitle="Percent meeting basic standards";
   if "`out'"=="unemprate" local ytitle="Unemployment rate";
 
   use ${data}tmpall.dta, clear;
   append using "${data_update}tmpall_update.dta";

     local i=0;
     gen tmpyr=.;
     forval y=1990/2009 {;
      count if year==`y';
      if r(N)!=0 {;
       gen yy_`y'=year==`y';
       local i=`i'+1;
       replace tmpyr=`y' if _n==`i';
      };
     };
     sum year; local min=r(min); drop yy_`min'; local minp1=`min'+1;


  *raw means;
     reg `out' yy_* if yearca>=1994&yearca<=1998, cl(statecode);
     gen meanraw9498=_b[_cons] if tmpyr==`min'; 
     forval y=`minp1'/2009 {;
      count if year==`y';
      if r(N)!=0 replace meanraw9498=_b[_cons]+_b[yy_`y'] if tmpyr==`y';
     };
/*
     reg `out' yy_* if yearca>=1997&yearca<=1998, cl(statecode);
     gen meanraw9798=_b[_cons] if tmpyr==`min'; 
     forval y=`minp1'/2000 {;
      count if year==`y';
      if r(N)!=0 replace meanraw9798=_b[_cons]+_b[yy_`y'] if tmpyr==`y';
     };
*/
     reg `out' yy_* if yearca>=1999&yearca<=2001, cl(statecode);
     gen meanraw9901=_b[_cons] if tmpyr==`min'; 
     forval y=`minp1'/2009 {;
      count if year==`y';
      if r(N)!=0 replace meanraw9901=_b[_cons]+_b[yy_`y'] if tmpyr==`y';
     };
     reg `out' yy_* if yearca==., cl(statecode);
     gen meanrawdot=_b[_cons] if tmpyr==`min'; 
     forval y=`minp1'/2009 {;
      count if year==`y';
      if r(N)!=0 replace meanrawdot=_b[_cons]+_b[yy_`y'] if tmpyr==`y';
     };


  *conditional trend lines;

/*
     areg `out' trend trendnclb03 nclb03   cov_*
      if yearca>=1994&yearca<=1996, a(statecode) cl(statecode);
      *set covars not in prediction to their mean;
      for var curexp povpct excl curexp_sq povpct_sq excl_sq:
       qui sum X if yearca>=1994&yearca<=1996&year<2003 \
       replace cov_X=r(mean) if year<2003 \
       qui sum X if yearca>=1994&yearca<=1996&year>=2003 \
       replace cov_X=r(mean) if year>=2003;
      predict meanhat9496, xb;
      for var curexp povpct excl curexp_sq povpct_sq excl_sq: replace cov_X=X;
*/
     areg `out' trend trendnclb03 nclb03
      if yearca>=1994&yearca<=1998, a(statecode) cl(statecode);
      predict meanhat9498, xb;

/*
     areg `out' trend trendnclb03 nclb03
      if yearca>=1997&yearca<=1998, a(statecode) cl(statecode);
      predict meanhat9798, xb;
*/

     areg `out' trend trendnclb03 nclb03
      if yearca>=1999&yearca<=2001, a(statecode) cl(statecode);
      predict meanhat9901, xb;

     areg `out' trend trendnclb03 nclb03
      if yearca==., a(statecode) cl(statecode);
      predict meanhatdot, xb;

     preserve;
     keep tmpyr meanraw9498 meanraw9901 meanrawdot;
     keep if tmpyr!=.;
     save ${data}tmp.dta, replace;
     restore;


     keep year meanhat9498 meanhat9901 meanhatdot;
     duplicates drop;
     tab year;


     append using ${data}tmp.dta;
     erase ${data}tmp.dta;


    ***number figures;
    if "`s'"=="sci4" local f="sci4";
    if "`s'"=="sci8" local f="sci8";
    if "`s'"=="math4" local f=13;
    if "`s'"=="read4" local f=14;
    if "`s'"=="math8" local f=15;
    if "`s'"=="read8" local f=16;
    if "`out'"=="mean" local p="a";
    if "`out'"=="pct_bsc" local p="b";
    if "`out'"=="unemprate" local p="c";



/*
     twoway (line meanhat9498 meanhat9901 meanhatdot year if year<2003,
     	     lcolor(black black black) mcolor(black black black)
	     lpattern(dot dash solid) 
	     lwidth(medium medium medium))
	    (line meanhat9498 meanhat9901 meanhatdot year if year>=2003,
     	     lcolor(black black black) mcolor(black black black)
	     lpattern(dot dash solid) 
	     lwidth(medium medium medium))
	    (scatter meanraw9498 meanraw9901 meanrawdot tmpyr,
	     mcolor(black black black) msymbol(Oh X T)),
	    xtitle(Year) xline(2002, lcolor(black))
	    xmlabel(1992(2)2008, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    legend(order(7 8 9) cols(1) colfirst
	        /*   label(1 "Adopted 1994-1996") label(2 "Adopted 1997-1998")
	     	     label(3 "Adopted 1999-2001") label(4 "None") */
	           label(7 "State adopted school acct. policy by 1998")
	     	     label(8 "Adopted 1999-2001")
		     label(9 "State never adopted school acct. policy before NCLB"));
     graph export ${figs}fig`f'`p'.eps, replace;
*/

gen tmpy=.;
     twoway (line meanhat9498 meanhatdot year if year<2003,
     	     lcolor(black black black) mcolor(black black black)
	     lpattern(dash solid) 
	     lwidth(medium medium medium))
	    (line meanhat9498 meanhatdot year if year>=2003,
     	     lcolor(black black black) mcolor(black black black)
	     lpattern(dash solid) 
	     lwidth(medium medium medium))
	    (scatter meanraw9498 meanrawdot tmpyr,
	     mcolor(black black black) msymbol(Oh T))
        (scatter tmpy tmpy year,
         lcolor(black black) lpattern(solid dash) connect(direct direct)
                      msymbol(Oh T) mcolor(black black)),
	    xtitle(Year) xline(2002, lpattern(solid)lcolor(black)) ytitle(`ytitle')
	    xmlabel(1992(2)2010, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    legend(order(7 8) cols(1) colfirst
	           label(7 "State adopted school acct. policy by 1998")
		     label(8 "State never adopted school acct. policy before NCLB"));
     graph export "${figs}fig`f'`p'.eps", replace;
drop tmpy;
   clear;
  };
 };
};






*!rm ${figs}figsci.eps;
*!cat ${figs}figsci4a.eps ${figs}figsci8a.eps ${figs}figsci4b.eps ${figs}figsci8b.eps
      > ${figs}figsci.eps;

log close;
