/*******************************************************************************
brings raw 2009 main NAEP math data from NAEP data explorer into stata dataset
and preps for merge with main data file
note - only mean scores for now
*******************************************************************************/
#delimit;
clear;
set more off;

*mean scores by subgroup and subscale;
insheet using "${m09}math2009.csv";

sum;

destring all-se_unclass, replace force;
for var se_*: replace X=-X;
sum;

drop notavail se_notavail asian se_asian amerind se_amerind unclass se_unclass;
des;

for var all male female eligible ineligible white black hisp:
 rename X meanX \
 rename se_X se_meanX;

reshape long mean se_mean, i(state grade scale) j(group) string;
sum;

replace group="All Students" if group=="all";
replace group="Black" if group=="black";
replace group="Eligible" if group=="eligible";
replace group="Ineligible" if group=="ineligible";
replace group="Female" if group=="female";
replace group="Male" if group=="male";
replace group="Hispanic" if group=="hisp";
replace group="White" if group=="white";

tab group;
replace state=trim(state);
sum;
compress;
save "${m09}math2009.dta", replace;


*percentile scores (and pct at or above standard) by subgroup (only composite scale);
insheet using "${m09}math2009_pct.csv", clear;
sum;

destring pct_belowbsc-se_pct90, replace force;
sum;

drop pct_belowbsc se_pct_belowbsc;
des;

tab group;
tab grade;
tab scale;
replace state=trim(state);
sum;
compress;
save "${m09}tmp.dta", replace;;


*subscale scores by percentile (no pct at or above standard) for all students;
insheet using "${m09}math2009_sub.csv", clear;
sum;

destring pct10-se_pct90, replace force;
sum;

des;

tab group;
tab grade;
tab scale;
replace state=trim(state);
sum;

append using "${m09}tmp.dta";
erase "${m09}tmp.dta";
compress;

mmerge subject grade year state scale group using "${m09}math2009.dta", t(1:1);
drop _m;
compress;
save "${m09}math2009.dta", replace;



*also save exclusion rate data;
insheet using "${m09}math2009_excl.csv", clear;
keep state grade subject excl;
gen year=2009;
replace state=trim(state);
compress;
sum;
save "${m09}math2009_excl.dta", replace;


