
/***********************************************************************************************
This do file combines datasets from school-level CCD downloads.
***********************************************************************************************/

# delimit;
capture log close;
capture program drop all;
clear;
set more off;
set mem 500M;

foreach f in 00 {;
 use "$data/sc`f'1.dta", clear;
};

foreach f in 92 93 94 95 96 97 98 99 00 01 02 03 04 05 06 07 {;
 use "$data/sc`f'1.dta", clear;
 gen datayear = "`f'";
 if "`f'"=="92" | "`f'"=="93" | "`f'"=="94" | "`f'"=="95" | "`f'"=="96" | "`f'"=="97" {;
  rename fle`f' totfrl`f';
  rename fips fipst;
 };
 if "`f'"=="94" | "`f'"=="95" {;
  rename ncesshc ncessch;
 };
 if "`f'"=="98" {;
  rename fips fipst;
 };
 foreach v in 
  schnam type status fte gslo gshi totfrl member toteth hisp black leanm {;
  rename `v'`f' `v';
 };
 keep ncessch fipst leaid leanm schno datayear schnam type status fte gslo gshi totfrl member toteth hisp black;
 replace totfrl=0 if totfrl==. & member~=.;
 replace toteth=0 if toteth==. & member~=.;
 replace hisp=0 if hisp==. & member~=.;
 replace black=0 if black==. & member~=.;
 gen pct_frl = totfrl/member;
 gen pct_eth = toteth/member;
 gen pct_bl_hisp = (black+hisp)/member;
 save "$data/tmp`f'.dta", replace;
 };

clear;
 
use "$data/tmp92.dta";
 foreach f in 93 94 95 96 97 98 99 00 01 02 03 04 05 06 07 {;
   append using "$data/tmp`f'.dta";
   erase "$data/tmp`f'.dta";
 };
save "$data/CCD_school_cov.dta", replace;

/*Note that NYC is broken into separate districts for this report but not for the expenditure reporting...
use this website to map back and forth between the two: http://nces.ed.gov/pubs2010/100largest0809/tables/table_d06.asp*/

replace leaid="3620580" if 
 leaid=="3600076" | 
 leaid=="3600077" | 
 leaid=="3600078" | 
 leaid=="3600079" | 
 leaid=="3600081" | 
 leaid=="3600083" | 
 leaid=="3600084" | 
 leaid=="3600085" | 
 leaid=="3600086" | 
 leaid=="3600087" | 
 leaid=="3600088" | 
 leaid=="3600090" | 
 leaid=="3600091" | 
 leaid=="3600119" | 
 leaid=="3600092" | 
 leaid=="3600094" | 
 leaid=="3600095" | 
 leaid=="3600096" | 
 leaid=="3600120" | 
 leaid=="3600151" | 
 leaid=="3600152" | 
 leaid=="3600153" | 
 leaid=="3600121" | 
 leaid=="3600098" | 
 leaid=="3600122" | 
 leaid=="3600099" | 
 leaid=="3600123" | 
 leaid=="3600100" | 
 leaid=="3600101" | 
 leaid=="3600102" | 
 leaid=="3600103" | 
 leaid=="3600097" | 
 leaid=="3600135" ;

collapse (sum) totfrl member hisp black fte (first) leanm, by(leaid datayear);
gen pct_frl = totfrl/member;
gen pct_bl_hisp = (black+hisp)/member;
gen year=.;
replace year=1993 if datayear=="92";
replace year=1994 if datayear=="93";
replace year=1995 if datayear=="94";
replace year=1996 if datayear=="95";
replace year=1997 if datayear=="96";
replace year=1998 if datayear=="97";
replace year=1999 if datayear=="98";
replace year=2000 if datayear=="99";
replace year=2001 if datayear=="00";
replace year=2002 if datayear=="01";
replace year=2003 if datayear=="02";
replace year=2004 if datayear=="03";
replace year=2005 if datayear=="04";
replace year=2006 if datayear=="05";
replace year=2007 if datayear=="06";
replace year=2008 if datayear=="07";

gen pup_tch = member/fte;

destring leaid, gen(leaid_nostr) force;

save "$data/CCD_district_cov.dta", replace;
erase "$data/tmp92.dta";
