# delimit;

clear;

set more 1;
set mem 800m;


global path = "c:/rugrat/brookings/rugrat-replication/raw-data";

use $path/04247-0001-Data.dta;

gen dataset = 2000;
gen dataset_00 = dataset==2000;

gen dd = 2000;

summ FINALWT;

gen recwght = FINALWT/r(mean);

rename P8 educ;

drop if educ==99;

gen college = educ>=16;  /* college grad and more */

gen pscollege = educ>=17; /* post-college */

rename RSEX sex;

rename AGEIMP age;

rename P6 civstat;

replace civstat = . if civstat==9;

gen married = civstat==1;

gen working = (P3A==1 | P3A==2);

gen student = ACT50>0 | P3B==4;

rename P2 under18;
replace under18 = . if under18==99;

rename CHILD1_1 child1age;
replace child1age=. if child1age==0;

rename CHILD2_1 child2age;
replace child2age=. if child2age==0;

rename CHILD3_1 child3age;
replace child3age=. if child3age==0;

rename CHILD4_1 child4age;
replace child4age=. if child4age==0;

rename CHILD5_1 child5age;
replace child5age=. if child5age==0;

rename CHILD6_1 child6age;
replace child6age=. if child6age==0;

gen under5 = (child1age<5) + (child2age<5) + (child3age<5) + (child4age<5)
  + (child5age<5) + (child6age<5);

gen under7 = (child1age<7) + (child2age<7) + (child3age<7) + (child4age<7)
  + (child5age<7) + (child6age<7);

gen ageyngst = child6age ;
replace ageyngst = child5age if ageyngst==.;
replace ageyngst = child4age if ageyngst==.;
replace ageyngst = child3age if ageyngst==.;
replace ageyngst = child2age if ageyngst==.;
replace ageyngst = child1age if ageyngst==.;

gen ageoldst = child1age;

gen mother = under18>0 & under18~=. & sex==2;
gen father = under18>0 & under18~=. & sex==1;

drop if age<18 | age>=65;

gen childtot = (7/60)*(ACT20 + ACT21 + ACT22 + ACT23 + ACT24 + ACT25 
  + ACT26 + ACT27 + ACT29);

gen childeduc = (7/60)*(ACT22 + ACT23);
gen childplay = (7/60)*(ACT24 + ACT25);
gen childtravel = (7/60)*ACT29;

gen childyoung = (7/60)*ACT20;
gen childold = (7/60)*ACT21;
gen childhealth = (7/60)*ACT26;
gen childoth = (7/60)*ACT27;

gen work = (7/60)*(ACT1 + ACT3 + ACT5 + ACT9);

gen chores =  (7/60)*(ACT10 + ACT11 + ACT12 + ACT13 + ACT14 + ACT15
  + ACT16 + ACT17 + ACT18 + ACT19 + ACT30 + ACT31 
  + ACT34 + ACT35 + ACT36 + ACT37 + ACT38 + ACT39 + ACT42);

gen freepers = 168 - (childtot + work + chores);

drop if age<18 | age>=65;

rename ACT20 act20; rename ACT21 act21; rename ACT22 act22;
rename ACT23 act23; rename ACT24 act24; rename ACT25 act25;
rename ACT26 act26; rename ACT27 act27; rename ACT29 act29;
rename ACT67 act67;

keep age sex mother father married recwght childtot childeduc childplay
  childtravel childyoung childold childhealth childoth
  act20 act21 act22 act23 act24 act25 act26 act27 act29 act67
  work chores freepers college pscollege ageyngst ageoldst under18 under5 
  under7 student working dataset; 

save 00_subset.dta, replace;

