# delimit;

clear;

set more 1;
set mem 800m;

log using income75.log, replace;

global path = "c:/rugrat/brookings/rugrat-replication/raw-data";

use $path/ahtus.dta;

gen dataset = 1965 if survey==0 | survey==1;
replace dataset = 1975 if survey==2;
replace dataset = 1985 if survey==3;
replace dataset = 1993 if survey==4;
replace dataset = 2002 if survey==7;

drop if dataset~=1975;

replace educ=. if educ==-8;
replace civstat = . if civstat==-9 | civstat==-8;
replace nadult = . if nadult==-8 | nadult==-9;
replace under18 = . if under18==-8;
replace under5 = . if under5==-8 | under5==-9;

drop if educ == .;

replace ageyngst = . if ageyngst==-7 | ageyngst==-8 | ageyngst==-9;
replace empstat = . if empstat==-8;
replace empsp = . if empsp==-7 | empsp==-8 | empsp==-9;

gen married = civstat==1;
gen mother2 = under18>0 & sex==2;
gen father2 = under18>0 & sex==1;

gen dropout = educ<3;
gen hsonly = educ==3;
gen college = educ>=5;  /* college grad and more */
gen pscollege = educ==6; /* post-college */

gen income = 1000 if income75==1;
replace income = 2500 if income75==2;
replace income = 3500 if income75==3;
replace income = 4500 if income75==4;
replace income = 5500 if income75==5;
replace income = 6750 if income75==6;
replace income = 8250 if income75==7;
replace income = 9500 if income75==8;
replace income = 10500 if income75==9;
replace income = 11750 if income75==10;
replace income = 13750 if income75==11;
replace income = 16250 if income75==12;
replace income = 18750 if income75==13;
replace income = 21250 if income75==14;
replace income = 23750 if income75==15;
replace income = 27500 if income75==16;
replace income = 32500 if income75==17;
replace income = 57300 if income75==18; /* Based on Saez, Table 6 */

gen income08 = income*4.00/1000;  /*thousands of 2008 dollars*/

gen lincome = log(income08);
gen income2 = income08^2;

replace student = 0 if student<0;

gen childtot = 
  (7/60)*(tmain33 +   /* care of infants */
  tmain34 +  /* general care of older children */
  tmain35 +  /* medical care of children */
  tmain36 + /* play with children */
  tmain37 + /* supervise or help with homework */
  tmain38 + /* read to, talk with child */
  tmain39 + /* other child care */
  tmain65 + /* sports with children */
  tmain96) ; /* travel related to child care */

gen childeduc = 
  (7/60)*( tmain37 + /* supervise or help with homework */
  tmain38); /* read to, talk with child */

gen childplay = 
  (7/60)*(
  tmain36 + /* play with children */
  tmain65);  /* sports with children */

gen childtravel = (7/60)*tmain96;

gen childyoung = (7/60)*tmain33;
gen childold = (7/60)*tmain34;

gen work =
  (7/60)*(tmain10 + /* main paid work (not at home) */
  tmain11 + /* paid work at home */
  tmain12 + /* second job, other paid work */
  tmain93) ; /* travel to/from work + other work travel */


gen chores = 
  (7/60)*(tmain20 + /* food preparation, cooking */
  tmain21 + /* set table, wash/put away dishes */
  tmain22 + /* cleaning */
  tmain23 + /* laundry, ironing, clothing repair */
  tmain24 + /* home repairs, maintain vehicle */
  tmain25 + /* other domestic work */
  tmain26 + /* purchase routine goods */
  tmain27 + /* purchase consumer durables */
  tmain28 + /* purchase personal services */
  tmain29 + /* purchase medical services */
  tmain30 + /* purchase repair, laundry services */
  tmain31 + /* financial, government services */
  tmain32 + /* purchase other services */
  tmain40 + /* adult care */
  tmain67 + /*gardening*/
  tmain68 + /*pet care*/
  tmain95) ; /* travel related to consumption */

gen freepers = 168 - (childtot + work + chores);

drop if age<18 | age>=65;

gen agecat=1 if age>=18 & age<=24;
replace agecat=2 if age>=25 & age<=34;
replace agecat=3 if age>=35 & age<=44;
replace agecat=4 if age>=45 & age<=54;
replace agecat=5 if age>=55 & age<=64;

gen infant = ageyngst<=1;
gen toddler = ageyngst==2;
gen preschool = (ageyngst<6 & ageyngst>2);
gen elementary1= (ageyngst>=6 & ageyngst<10);
gen elementary2= (ageyngst>=10 & ageyngst<14);
gen teen= (ageyngst>=14 & ageyngst<18);

gen under182 = under18^2;

gen haveyoung = under5>0;


drop if student==1;

summ income income08 [w=recwght] if under18>0 & under18~=.;

xi:reg childtot income08 college dropout i.agecat infant toddler 
   preschool elementary1 elementary2 under18 under182 married [aw=recwght] 
  if sex==2 & under18>0;

xi:reg childtot income08 income2 college dropout i.agecat infant toddler 
   preschool elementary1 elementary2 under18 under182 married [aw=recwght] 
  if sex==2 & under18>0;

xi:reg childtot lincome college dropout i.agecat infant toddler 
  preschool elementary1 elementary2 under18 under182 married [aw=recwght] 
  if sex==2 & under18>0;

xi:reg childtot income08 college dropout i.agecat infant toddler 
   preschool elementary1 elementary2 under18 under182 married [aw=recwght] 
  if sex==1 & under18>0;

xi:reg childtot income08 income2 college dropout i.agecat infant toddler 
   preschool elementary1 elementary2 under18 under182 married [aw=recwght] 
  if sex==1 & under18>0;

xi:reg childtot lincome college dropout i.agecat infant toddler 
  preschool elementary1 elementary2 under18 under182 married [aw=recwght] 
  if sex==1 & under18>0;

log close;
