#delimit;
clear;
set mem 800m;
set mat 800;

/******************/

/*Extract needed variables from cps, roster, and respondent files*/

global path = "c:/rugrat/brookings/rugrat-replication/raw-data";

use $path/atuscps_0308, clear;

keep if tulineno==1; /*only keep respondent's info*/

keep prnmchld peeduca tucaseid tulineno ptdtrace pehspnon pemaritl gestfips 
  hufaminc prernwa ptwk;

sort tucaseid tulineno;

save "timeuse_0308", replace;


use $path/atusrost_0308, clear;

keep if tulineno==1; 

keep teage tesex tucaseid tulineno;

sort tucaseid tulineno;


merge tucaseid tulineno using "timeuse_0308", unique nokeep;

tab _merge;

drop _merge; 

sort tucaseid tulineno;

save "timeuse_0308", replace;

use $path/atusresp_0308, clear;

gen year = tuyear;

keep tulk tufwk tulay tudis tuabsot teret telfs trchildnum trdpftpt trsppres tryhhchild
tucaseid tudiaryday tufnwgtp tulineno turetot year telfs trernwa teschft teschenr tehruslt tespuhrs
trernhly;


sort tucaseid tulineno;


merge tucaseid tulineno using "timeuse_0308", unique nokeep;

tab _merge;

drop _merge; 

sort tucaseid tulineno;

save "timeuse_0308", replace;

use $path/atusact_0308, clear;

*keep tucaseid tuactdur tuactdur24 tutier1code tutier2code tutier3code;
keep tucaseid tuactdur tuactdur24 trcodep trtier1p trtier2p;

sort tucaseid;

merge tucaseid using "timeuse_0308";

tab _merge;

drop _merge; 

sort tucaseid tulineno;

save "timeuse_0308", replace;

/*************/;

use "timeuse_0308", clear;


/*Demographics*/
gen age=teage;
gen male=tesex==1;
gen married= trsppres==1; /*Does not include unmarried partner*/
gen marst = pemaritl;
gen num_child= trchildnum;
gen hv_child=num_child>0;
replace hv_child=. if num_child==.;
gen age_youngest=tryhhchild;
replace age_youngest=. if tryhhchild<0;
gen child_4=tryhhchild<4 & tryhhchild>=0;
gen child_5=tryhhchild<5 & tryhhchild>=0;


gen grade=0 if peeduca==31;
replace grade=1 if peeduca==32;
replace grade=5 if peeduca==33;
replace grade=7 if peeduca==34;
replace grade=9 if peeduca==35;
replace grade=10 if peeduca==36;
replace grade=11 if peeduca==37 | peeduca==38;
replace grade=12 if peeduca==39;
replace grade=13 if peeduca>=40 & peeduca<=42;
replace grade=16 if peeduca==43;
replace grade=17 if peeduca>=44;
replace grade=. if peeduca==.;


gen working = telfs == 1 | telfs == 2;
gen unemp = telfs == 3 | telfs == 4;
gen retired = telfs == 5 & (turetot == 1 | tulk == 3 | tufwk == 3 | tulay == 3 | tuabsot == 3) & teret1 == 2 ;
gen disabled = telfs == 5 & (tuabsot == 4 | tufwk == 4 | tulay == 4 | tulk == 4 | tudis == 1);
gen student = teschenr==1; /*may  be part time student or working... make consistent with earlier years*/
gen homemaker = working == 0 & retired == 0 & student == 0 & disabled == 0 & unemp == 0 ; 
gen work_part = trdpftpt==2;

gen dataset=year;

gen interview_day=tudiaryday-1;
replace interview_day=7 if tudiaryday==1;

gen childtot = tuactdur24 if 
     trtier2p==0301 /* physical care of HH children */
  |  trtier2p==0302 /* education of HH children */
  |  trtier2p==0303 /* health care of HH children */

  |  trtier2p==0401 /* physical care of non-HH children */
  |  trtier2p==0402 /* education of non-HH children */
  |  trtier2p==0403 /* health care of non-HH children */

  |  trtier2p==0801 /* managing childcare services */
  |  trcodep==160107 /* managing childcare services */
  |  trcodep==180381 /* travel related to HH children*/
  |  trcodep==180481 /* travel related to non-HH children*/
  |  trcodep==180801 /* travel related to using childcare services*/ ;


gen childphyssupr = tuactdur24 if 
     trcodep==030101 | trcodep==030106 | trcodep==030109
  |  trcodep==040101 | trcodep==040106 | trcodep==040109;

gen childeduc = tuactdur24 if 
     trcodep==030102 | trcodep==030107 | trtier2p==0302
  |  trcodep==040102 | trcodep==040107 | trtier2p==0402;

gen childplay = tuactdur24 if 
     trcodep==030103 | trcodep==030104 | trcodep==030105
  |  trcodep==040103 | trcodep==040104 | trcodep==040105;

gen childhealth = tuactdur24 if 
     trtier2p==0303 | trtier2p==0403 ;

gen childorgact = tuactdur24 if 
     trcodep==030108 | trcodep==030110 |  trcodep==040108 | trcodep==040110 ;

gen childtravwait = tuactdur24 if 
     trcodep==030111 | trcodep==030112 |  trcodep==040111 | trcodep==040112 
   | trcodep==180381 | trcodep==180481 | trcodep==180801;


collapse (mean) age male ptdtrace pehspnon marst married 
  num_child hv_child age_youngest child_4 child_5 grade working unemp retired 
  disabled student 
prnmchld gestfips hufaminc prernwa ptwk telfs tehruslt tespuhrs
homemaker work_part year dataset interview_day tufnwgtp 
(sum) childtot childphyssupr childeduc childplay childhealth childorgact 
  childtravwait, by(tucaseid);


gen weight=tufnwgtp;

sum weight if year==2003;
gen weight_adj = weight/(r(N)*r(mean)) if year==2003; /* make sum of weights = 1 for year */

sum weight if year==2004;
replace weight_adj = weight/(r(N)*r(mean)) if year==2004; /* make sum of weights = 1 for year */

sum weight if year==2005;
replace weight_adj = weight/(r(N)*r(mean)) if year==2005; /* make sum of weights = 1 for year */

sum weight if year==2006;
replace weight_adj = weight/(r(N)*r(mean)) if year==2006; /* make sum of weights = 1 for year */

sum weight if year==2007;
replace weight_adj = weight/(r(N)*r(mean)) if year==2007; /* make sum of weights = 1 for year */

sum weight if year==2008;
replace weight_adj = weight/(r(N)*r(mean)) if year==2008; /* make sum of weights = 1 for year */

gen identifier=tucaseid;
drop tucaseid;

keep age male ptdtrace pehspnon marst married 
  num_child hv_child age_youngest child_4 child_5 grade 
prnmchld gestfips hufaminc prernwa ptwk telfs tehruslt tespuhrs
working homemaker student unemp retired disabled work_part 
year interview_day weight weight_adj identifier
childtot childphyssupr childeduc childplay childhealth childorgact childtravwait
dataset;


/*Convert to hours per week*/;

foreach var of varlist 
childtot childphyssupr childeduc childplay childhealth childorgact childtravwait {;

replace `var'=`var'/60*7;
};


* RENAME VARIABLES TO MATCH AHTUS;

gen sex = 1 if male==1;
replace sex = 2 if male==0;

gen nobs = 20720 if dataset==2003;
replace nobs = 13973 if dataset==2004;
replace nobs = 13038 if dataset==2005;
replace nobs = 12943 if dataset==2006;
replace nobs = 12248 if dataset==2007;
replace nobs = 12723 if dataset==2008;

gen recwght = weight_adj*nobs;

rename num_child under18;
rename age_youngest ageyngst;

gen mother = (prnmchld>0 & prnmchld~=. & sex==2); /* true mother */
gen father = (prnmchld>0 & prnmchld~=. & sex==1);  /* true father */

gen mother2 = (under18>0 & under18~=. & sex==2); /*lives in house with children*/
gen father2 = (under18>0 & under18~=. & sex==1);



gen youngchild = ageyngst<5;

drop if grade==.;
gen dropout = grade<12;
gen hsonly = grade==12;
gen college = grade>=16;
gen pscollege = grade>=17;

keep age sex mother father mother2 father2 married recwght working
  childtot childphyssupr childeduc childplay childhealth childorgact childtravwait
  prernwa ptwk student dropout hsonly college pscollege 
  prnmchld ageyngst youngchild under18 dataset;


gen agecat = 1 if age>=18 & age<25;
replace agecat = 2 if age>=25 & age<35;
replace agecat = 3 if age>=35 & age<45;
replace agecat = 4 if age>=45 & age<55;
replace agecat = 5 if age>=55 & age<65;
drop if agecat==.;

gen male = sex==1;

drop if student==1;

collapse childtot childphyssupr childeduc childplay childhealth childorgact 
  childtravwait if prnmchld>0 & prnmchld~=., by(male college youngchild);

outsheet using junk.csv, replace comma;

