#delimit;
set more 1;

clear;

set memory 800m;

use c:\timeusedata\canada\1986\c2main.dta;

keep seqnum age_e1 age_e2 age_e3 dvagegr dvmainlg;

gen rdvmainlg = real(dvmainlg);

*What is your main language?;

gen english = (rdvmainlg==1 | rdvmainlg==2 | rdvmainlg==3 | rdvmainlg==7);

rename seqnum seqnumstr;
rename dvagegr dvagegrstr;
rename age_e1 age_e1str;
rename age_e2 age_e2str;
rename age_e3 age_e3str;


*CONVERT STRINGS TO REAL;

gen seqnum = real(seqnumstr);
gen dvagegr = real(dvagegrstr);
gen age_e1 = real(age_e1str);
gen age_e2 = real(age_e2str);
gen age_e3 = real(age_e3str);

*CALCULATE THE NUMBER OF CHILDREN UP TO 3 OR MORE;

gen onechild = age_e1>0;
gen twochild = age_e2>0;
gen threechild = age_e3>0;

gen numownchild = onechild + twochild + threechild;

sort seqnum;
keep seqnum dvagegr numownchild age_e1 age_e2 age_e3 english;
save junk.dta, replace;

use c:\timeusedata\canada\1986\c2summ.dta;

*CONVERT STRINGS TO REAL;

rename seqnum seqnumstr;

gen seqnum = real(seqnumstr);

sort seqnum;

merge seqnum using junk.dta;

tab _merge; drop _merge;

gen agecat = real(dvage1);

gen age15_19 = dvagegr==1;

gen sex = real(dvsex);

gen married = real(dvms)==1;

gen college = real(dvedr)==8 | real(dvedr)==9;

gen hv_child = real(dvchild)>1;

gen child_5 = (real(dvchild)==2 | real(dvchild)==5);

* ELEMENTARY AGE, 5 - 9;

gen element = (age_e1==2 | age_e1==3);

* ADOLESCENT, AGE 10-14;

gen adoles = (age_e1==4);


* DVCHILDC IN 1986 EXCLUDES ADULT CARE (SEE APPENDIX J OF GSS 2005);

gen childcare0_18 = dvchildc*7/60;  

gen adultcare = (durac_41 + durac_42)*(7/60);

gen famcare = childcare0_18 + adultcare;

gen dataset=1986;

gen recwght = fwgt_ms/2000.559;

keep seqnum dataset fwgt_ms recwght sex agecat age15_19 married english
  college hv_child child_5 childcare0_18 famcare numownchild element adoles;

save 1986_subset, replace;

clear;

use c:\timeusedata\canada\1992\main558.dta;

keep seqnum resc0004 resc0512 resc1318;

*CALCULATE THE NUMBER OF CHILDREN UP TO 3 OR MORE;

gen numownchild = resc0004 + resc0512 + resc1318;

sort seqnum;
keep seqnum numownchild resc0004 resc0512 resc1318;
save junk.dta, replace;

use c:\timeusedata\canada\1992\summ7e.dta;

sort seqnum;

merge seqnum using junk.dta;

tab _merge; drop _merge;

gen agecat=1 if (dvagegr==1 | dvagegr==2 | dvagegr==3);
replace agecat=2 if (dvagegr==4 | dvagegr==5);
replace agecat=3 if (dvagegr==6 | dvagegr==7);
replace agecat=4 if (dvagegr==8 | dvagegr==9);
replace agecat=5 if (dvagegr==10 | dvagegr==11);
replace agecat=6 if dvagegr>=12;

gen age15_19 = (dvagegr==1 | dvagegr==2);

gen sex = dvsex;

gen married= dvms==1;

*What is the language spoken most often at home?;

gen english = (dvk14==1 | dvk14==4 | dvk14==5 | dvk14==7);

gen college = (dveduc==1 | dveduc==2 | dveduc==3);

gen hv_child = dvchild>1;

gen child_5 = (dvchild==2 | dvchild==5);

* ELEMENTARY AGE, 5 - 9;

gen element = (dvagryc>=5 & dvagryc<=9);

* ADOLESCENT, AGE 10-14;

gen adoles= (dvagryc>=10 & dvagryc<=14);

gen childcare0_18 = chlddoms*7/60;

* DVCHILDC INCLUDES FAMILY CARE IN 1992, 1998, 2005;

gen famcare = dvchildc*7/60;

gen dataset=1992;

gen recwght = timewgt/2367.087;

keep seqnum dataset timewgt recwght sex agecat married english college hv_child 
  child_5 childcare0_18 famcare numownchild age15_19 element adoles
  resc0004 resc0512 resc1318;

save 1992_subset, replace;

clear;

use c:\timeusedata\canada\1998\c12micme.dta;

gen agecat = real(agegr10);
replace agecat = 6 if agecat>6;

gen age15_19 = (real(agegr5)==1 | real(agegr5)==2);

rename sex strsex;
gen sex = real(strsex);

rename marst strmarst;
gen marst = real(strmarst);

gen married= (marst==1 | marst==2);

*What language do you speak most often at home? Same as DVK14 in 1992;

gen rlanhsd = real(lanhsd);

gen english = (rlanhsd==1 | rlanhsd==4 | rlanhsd==5 | rlanhsd==7);

rename edu10 stredu10;
gen edu10 = real(stredu10);

gen college = (edu10==1 | edu10==2);

rename chrtime6 strchrtime6;
gen chrtime6 = real(strchrtime6);

gen hv_child = chrtime6>1;

gen child_5 = (chrtime6==2 | chrtime6==5);

* ELEMENTARY AGE, 5 - 9;

gen element = (agechryc>=5 & agechryc<=9);

* ADOLESCENT, AGE 10-14;

gen adoles= (agechryc>=10 & agechryc<=14);

gen numownchild = chr0004 + chr0512 + chr1314 + chr1518;

gen numhhchild0_14 = chh0004 + chh0512 + chh1314 ;

gen childcare0_14 = chlddoms*7/60;

* DVCHILDC INCLUDES FAMILY CARE IN 1992, 1998, 2005;

gen famcare = dvchildc*7/60;

gen dataset=1998;

gen recwght = wghtfin/2256.967;

keep recid dataset wghtfin recwght sex agecat married english college hv_child 
  child_5 childcare0_14 famcare numownchild numhhchild0_14 age15_19
  chr0004 chr0512 chr1314 chr1518 chrtime6 element adoles;

save 1998_subset, replace;

clear;

use c:\timeusedata\canada\2005\c19pumfm_num.dta;

gen agecat = agegr10;
replace agecat = 6 if agecat>6;

gen age15_19 = (agegr5==1 | agegr5==2);

gen married= (marst==1 | marst==2);

*language in early childhood plus whether still understand english;

*gen english = (lanch==1 | lanch==4 | lanch==5 | lanch==7) & lanchsue==1;

*Language spoken in household.  Unfortunately, category 3 is too broad;

gen english = (lanhsdc==1 | lanhsdc==3);

gen college = (edu10==1 | edu10==2);

gen hv_child = chrtime6>1;

gen child_5 = (chrtime6==2 | chrtime6==5);

* ELEMENTARY AGE, 5 - 9;

gen element = (agechryc>=5 & agechryc<=9);

* ADOLESCENT, AGE 10-14;

gen adoles= (agechryc>=10 & agechryc<=14);

*Note that this is only children 0 - 14.  Chrinhscd = all children, any age;

gen numownchild0_14 = chr0014c;

gen childcare0_14 = chlddoms*7/60;

* DVCHILDC INCLUDES FAMILY CARE IN 1992, 1998, 2005;

gen famcare = dvchildc*7/60;

gen dataset=2005;

gen recwght = wght_per/1331.623;

keep recid dataset wght_per recwght sex agecat married english college hv_child 
  child_5 childcare0_14 famcare numownchild0_14 age15_19
  chrtime6 chrinhsdc element adoles livarr12;

save 2005_subset, replace;

append using 1986_subset;
append using 1992_subset;
append using 1998_subset;

save canadagss.dta, replace;
