# delimit;

clear;

set more 1;
set mem 800m;

global path = "c:/rugrat/brookings/rugrat-replication/raw-data";

use $path/TM95.dta;

gen dataset = 1995;
gen dataset_95 = dataset==1995;

gen dd = 1995;

drop work;

*THIS WEIGHT IS A GUESS BASED ON DESCRIPTION;

rename totwt recwght;

drop if educ==9;

gen college = educ>=5;  /* college grad and more */

gen pscollege = educ>=6; /* post-college */

drop if sex==9;

rename marital civstat;

replace civstat = . if civstat==9;

gen married = civstat==1;

gen mother2 = under18>0 & under18~=. & sex==2;
gen father2 = under18>0 & under18~=. & sex==1;

drop if rage>8;

gen childtot = (7/60)*(act20 + act21 + act22 + act23 + act24 + act25 
  + act26 + act27 + act29);

gen childeduc = (7/60)*(act22 + act23);

gen childplay = (7/60)*(act24 + act25);

gen childtravel = (7/60)*(act29);

gen work = (7/60)*(act00 + act05 + act09);

gen childyoung = (7/60)*act20;
gen childold = (7/60)*act21;
gen childhealth = (7/60)*act26;
gen childoth = (7/60)*act27;

gen chores =  (7/60)*(act10 + act11 + act12 + act13 + act14
  + act16 + act17 + act19 + act30 + act31 
  + act34 + act35 + act36 + act37 + act38 + act39 + act42);

gen freepers = 168 - (childtot + work + chores);

keep rage sex mother2 father2 married recwght childtot childeduc 
  childyoung childold childhealth childoth
  act20 act21 act22 act23 act24 act25 act26 act27 act29 act67
  childplay childtravel work chores freepers college pscollege under18 
  under5 student dataset; 

save 95_subset.dta, replace;

