# delimit;

clear;

set more 1;
set mem 800m;

log using race.log, replace;

use merged_datasets; 

drop if dataset==.;

drop if dataset<2003;

gen agecat=1 if age>=18 & age<=24;
replace agecat=2 if age>=25 & age<=34;
replace agecat=3 if age>=35 & age<=44;
replace agecat=4 if age>=45 & age<=54;
replace agecat=5 if age>=55 & age<=64;

drop if agecat==.;

gen infant = ageyngst<=1;
gen toddler = ageyngst==2;
gen preschool = (ageyngst<6 & ageyngst>2);
gen elementary1= (ageyngst>=6 & ageyngst<10);
gen elementary2= (ageyngst>=10 & ageyngst<14);
gen teen= (ageyngst>=14 & ageyngst<18);

gen under182 = under18^2;

char college[omit] 1;
char agecat[omit] 2;

drop if student==1;

*Black only;

gen black = 0;
replace black = 1 if race==2;

*Nonhispanic white;

gen white = 0;
replace white = 1 if race==1 & hispanic==0;

gen minority = 0;
replace minority = 1 if (black==1 | hispanic==1);

gen minorcl = minority*college;
gen minorncl = minority*(1-college);
gen whitecl = white*college;
gen whitencl = white*(1-college);
gen blackcl = black*college;
gen blackncl = black*(1-college);

xi:reg childtot black hispanic dropout
  infant toddler preschool elementary1 elementary2 under18 under182 married 
  i.agecat [aw=recwght] if mother==1 & college==0;

xi:reg childtot black hispanic pscollege
  infant toddler preschool elementary1 elementary2 under18 under182 married 
  i.agecat [aw=recwght] if mother==1 & college==1;

xi:reg childtot black hispanic dropout
  infant toddler preschool elementary1 elementary2 under18 under182 married 
  i.agecat [aw=recwght] if father==1  & college==0;

xi:reg childtot black hispanic pscollege
  infant toddler preschool elementary1 elementary2 under18 under182 married 
  i.agecat [aw=recwght] if father==1 & college==1;

drop if dropout==. | infant==. | toddler==. | preschool==.
  | under18==. | married==. | agecat==.;

summ childtot if black==1 & college==0 & mother==1;
summ childtot if hispanic==1 & college==0 & mother==1;
summ childtot if black==1 & college==1 & mother==1;
summ childtot if hispanic==1 & college==1 & mother==1;

summ childtot if black==1 & college==0 & father==1;
summ childtot if hispanic==1 & college==0 & father==1;
summ childtot if black==1 & college==1 & father==1;
summ childtot if hispanic==1 & college==1 & father==1;


log close;
