# delimit;

clear;

set more 1;
set mem 800m;

log using incomebls.log, replace;

use bls0308_subset.dta; 

drop if age<18 | age>=65;

gen agecat=1 if age>=18 & age<=24;
replace agecat=2 if age>=25 & age<=34;
replace agecat=3 if age>=35 & age<=44;
replace agecat=4 if age>=45 & age<=54;
replace agecat=5 if age>=55 & age<=64;

gen infant = ageyngst<=1;
gen toddler = ageyngst==2;
gen preschool = (ageyngst<6 & ageyngst>2);
gen elementary1= (ageyngst>=6 & ageyngst<10);
gen elementary2= (ageyngst>=10 & ageyngst<14);
gen teen= (ageyngst>=14 & ageyngst<18);

gen under182 = under18^2;

/* real rincome */
gen rincome = incomebls/1000 if dataset==2008;
replace rincome = incomebls*1.038/1000 if dataset==2007;
replace rincome = incomebls*1.068/1000 if dataset==2006;
replace rincome = incomebls*1.102/1000 if dataset==2005;
replace rincome = incomebls*1.140/1000 if dataset==2004;
replace rincome = incomebls*1.170/1000 if dataset==2003;

gen lrincome = ln(rincome);

gen rincome2 = rincome^2;

/* real weekly earnings*/
gen rwkearnings = prernwa/100 if dataset==2008;
replace rwkearnings = prernwa*1.038/100 if dataset==2007;
replace rwkearnings = prernwa*1.068/100 if dataset==2006;
replace rwkearnings = prernwa*1.102/100 if dataset==2005;
replace rwkearnings = prernwa*1.140/100 if dataset==2004;
replace rwkearnings = prernwa*1.170/100 if dataset==2003;

replace rwkearnings = . if prernwa<=0;

gen lrwkearnings = ln(rwkearnings);

gen rwkearnings2 = rwkearnings^2;


drop if student==1;

local basic_controls "i.dataset i.agecat";
local educ_controls "dropout college pscollege";
local additional_controls "infant toddler preschool elementary1 elementary2
  under18 under182 married";

summ rincome [aw=recwght] if under18>0 & under18~=. & dataset==2008;

/*mothers*/

/*
xi:reg childtot rincome `basic_controls' `educ_controls' `additional_controls'
   [aw=recwght] if mother==1;

xi:reg childtot rincome `basic_controls' `educ_controls' `additional_controls'
   usualhrs spusualhrs
   [aw=recwght] if mother==1;

xi:reg childtot rincome `basic_controls' `educ_controls' `additional_controls'
   [aw=recwght] if mother==1 & working==0;
*/

xi:reg childtot rincome rincome2 `basic_controls' `educ_controls' 
  `additional_controls' [aw=recwght] if mother==1;

gen change = _b[rincome]*98.6 + _b[rincome2]*(98.6)^2
     - ( _b[rincome]*72.7 + _b[rincome2]*(72.7)^2); summ change;

xi:reg childtot rincome rincome2 `basic_controls' `educ_controls' 
  `additional_controls' usualhrs spusualhrs [aw=recwght] if mother==1;

replace change = _b[rincome]*98.6 + _b[rincome2]*(98.6)^2
     - ( _b[rincome]*72.7 + _b[rincome2]*(72.7)^2); summ change;

xi:reg childtot rincome rincome2 `basic_controls' `educ_controls' 
  `additional_controls' [aw=recwght] if mother==1 & working==0;

replace change = _b[rincome]*98.6 + _b[rincome2]*(98.6)^2
     - ( _b[rincome]*72.7 + _b[rincome2]*(72.7)^2); summ change;

xi:reg childtot rincome rincome2 `basic_controls'  
  `additional_controls' [aw=recwght] if mother==1 & working==0;

replace change = _b[rincome]*98.6 + _b[rincome2]*(98.6)^2
     - ( _b[rincome]*72.7 + _b[rincome2]*(72.7)^2); summ change;

xi:reg childtot lrincome `basic_controls' `educ_controls' `additional_controls'
   [aw=recwght] if mother==1;

replace change = _b[lrincome]*ln(98.6) - _b[lrincome]*ln(72.7); summ change;

xi:reg childtot lrincome `basic_controls' `educ_controls' `additional_controls'
   usualhrs spusualhrs [aw=recwght] if mother==1;

replace change = _b[lrincome]*ln(98.6) - _b[lrincome]*ln(72.7); summ change;

xi:reg childtot lrincome `basic_controls' `educ_controls' `additional_controls'
   [aw=recwght] if mother==1 & working==0;

replace change = _b[lrincome]*ln(98.6) - _b[lrincome]*ln(72.7); summ change;


/*fathers*/

/*
xi:reg childtot rincome `basic_controls' `educ_controls' `additional_controls'
   [aw=recwght] if father==1;

xi:reg childtot rincome `basic_controls' `educ_controls' `additional_controls'
   usualhrs spusualhrs
   [aw=recwght] if father==1;
*/

xi:reg childtot rincome rincome2 `basic_controls' `educ_controls' 
  `additional_controls' [aw=recwght] if father==1;

replace change = _b[rincome]*98.6 + _b[rincome2]*(98.6)^2
     - ( _b[rincome]*72.7 + _b[rincome2]*(72.7)^2); summ change;

xi:reg childtot rincome rincome2 `basic_controls' `educ_controls' 
  `additional_controls' usualhrs spusualhrs [aw=recwght] if father==1;

replace change = _b[rincome]*98.6 + _b[rincome2]*(98.6)^2
     - ( _b[rincome]*72.7 + _b[rincome2]*(72.7)^2); summ change;


xi:reg childtot lrincome `basic_controls' `educ_controls' `additional_controls'
   [aw=recwght] if father==1;

replace change = _b[lrincome]*ln(98.6) - _b[lrincome]*ln(72.7); summ change;

xi:reg childtot lrincome `basic_controls' `educ_controls' `additional_controls'
   usualhrs spusualhrs [aw=recwght] if father==1;

replace change = _b[lrincome]*ln(98.6) - _b[lrincome]*ln(72.7); summ change;


/*
xi:reg childtot rwkearnings rwkearnings2 `basic_controls' `educ_controls' `additional_controls'
   [aw=recwght] if mother==1 & working==1;

xi:reg childtot rwkearnings rwkearnings2 `basic_controls' `educ_controls' `additional_controls'
   usualhrs spusualhrs
   [aw=recwght] if mother==1 & working==1;


xi:reg childtot lrwkearnings `basic_controls' `educ_controls' `additional_controls'
   [aw=recwght] if mother==1 & working==1;

xi:reg childtot lrwkearnings `basic_controls' `educ_controls' `additional_controls'
   usualhrs spusualhrs
   [aw=recwght] if mother==1 & working==1;


/*fathers*/


xi:reg childtot rwkearnings rwkearnings2 `basic_controls' `educ_controls' `additional_controls'
   [aw=recwght] if father==1 & working==1;

xi:reg childtot rwkearnings rwkearnings2 `basic_controls' `educ_controls' `additional_controls'
   usualhrs spusualhrs
   [aw=recwght] if father==1 & working==1;

xi:reg childtot lrwkearnings `basic_controls' `educ_controls' `additional_controls'
   [aw=recwght] if father==1 & working==1;

xi:reg childtot lrwkearnings `basic_controls' `educ_controls' `additional_controls'
   usualhrs spusualhrs
   [aw=recwght] if father==1 & working==1;

xi:reg rwkearnings i.dataset `educ_controls' [aw=recwght] if mother==1 | father==1;

xi:reg rwkearnings `basic_controls' `educ_controls' `additional_controls' 
  [aw=recwght] if mother==1 | father==1;

*/

log close;
