# delimit;

clear;

set more 1;
set mem 800m;

global path = "c:/rugrat/brookings/rugrat-replication/raw-data";

use $path/03191-0001.dta;

gen dataset = 1998;
gen dataset_98 = dataset==1998;

gen dd = 1998;

rename daywt recwght;

rename p2 under18;

replace under18 = . if under18==9;

rename p2a under7;

rename p5 educ;

drop if educ==99;

gen college = educ>=16;  /* college grad and more */

gen pscollege = educ>=17; /* post-college */

rename rsex sex;

gen monthintv = int(date/10000);
gen dayintv = int((date-monthintv*10000)/100);
gen yearintv = date - monthintv*10000 - dayintv*100;
 
gen yearbirth = p3a;
gen monthbirth = p3;

gen age = yearintv - yearbirth;
replace age = age - 1 if monthintv < monthbirth;

rename p6 civstat;

replace civstat = . if civstat==9;

gen married = civstat==1;


gen working = p7==1 | p7==2;

gen student = act50>0 | p7a==4;

gen mother = parent==1 & sex==2;
gen father = parent==1 & sex==1;

gen mother2 = under18>0 & under18~=. & sex==2;
gen father2 = under18>0 & under18~=. & sex==1;

drop if age<18 | age>=65;

gen childtot = (7/60)*(act20 + act21 + act22 + act23 + act24 + act25 
  + act26 + act27 + act29);

gen childeduc = (7/60)*(act22 + act23);

gen childplay = (7/60)*(act24 + act25);

gen childtravel = (7/60)*(act29);

gen childyoung = (7/60)*act20;
gen childold = (7/60)*act21;
gen childhealth = (7/60)*act26;
gen childoth = (7/60)*act27;

gen work = (7/60)*(act1 + act3 + act5 + act9);

gen chores =  (7/60)*(act10 + act11 + act12 + act13 + act14 + act15
  + act16 + act17 + act18 + act19 + act30 + act31 
  + act34 + act35 + act36 + act37 + act38 + act39 + act42);

gen freepers = 168 - (childtot + work + chores);

drop if age<18 | age>=65;

keep age sex mother father mother2 father2 married recwght childtot childeduc 
  childyoung childold childhealth childoth childplay childtravel
  act20 act21 act22 act23 act24 act25 act26 act27 act29 act67
  work chores freepers college pscollege under18 
  under7 student working dataset; 

save 98_subset.dta, replace;

