# delimit;

clear;

set more 1;
set mem 800m;

log using childcaretype.log, replace;

use merged_datasets; 

drop if dataset==.;

gen dd = 1965 if dataset==1965;
replace dd = 1975 if dataset==1975;
replace dd = 1985 if dataset==1985;
replace dd = 1993 if dataset==1993;
replace dd = 1995 if dataset==1995;
replace dd = 1998 if dataset==1998;
replace dd = 2000 if dataset==2000;
replace dd = 2003 if dataset==2003;
replace dd = 2004 if dataset==2004;
replace dd = 2005 if dataset==2005;
replace dd = 2006 if dataset==2006;
replace dd = 2007 if dataset==2007;

gen agecat=1 if age>=18 & age<=24;
replace agecat=2 if age>=25 & age<=34;
replace agecat=3 if age>=35 & age<=44;
replace agecat=4 if age>=45 & age<=54;
replace agecat=5 if age>=55 & age<=64;

replace agecat = 1 if rage==4 & dataset==1995;
replace agecat = 2 if rage==5 & dataset==1995;
replace agecat = 3 if rage==6 & dataset==1995;
replace agecat = 4 if rage==7 & dataset==1995;
replace agecat = 5 if rage==8 & dataset==1995;

drop if agecat==.;

gen infant = ageyngst<=1;
gen toddler = ageyngst==2;
gen preschool = (ageyngst<6 & ageyngst>2);
gen elementary1= (ageyngst>=6 & ageyngst<10);
gen elementary2= (ageyngst>=10 & ageyngst<14);
gen teen= (ageyngst>=14 & ageyngst<18);

gen under182 = under18^2;

gen haveyoung = under5>0;
replace haveyoung = under7>0 if dataset==1998;
replace haveyoung = ageyngst<5 if dataset>=2003;

gen numyoung = under5 if (dataset<=1985) | dataset==1995 | dataset==2000;
replace numyoung = under7 if dataset==1998;

char dd[omit] 1975;
char dataset[omit] 1975;
char college[omit] 1;
char agecat[omit] 1;

/*variables to be studied:*/
local variables childtot childeduc childplay work chores freepers sizes; 

gen ahtus = dataset<=1993;


drop if student==1;

keep if dataset==1965 | dataset==1975 | dataset==1985 | dataset==1995
  | dataset==1998 | dataset==2000;

replace mother2 = mother if dd==2000;
replace father2 = father if dd==2000;

gen childtravoth = childtravel + childoth;

xi:reg childtot i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if mother2==1;

lincom _Idd_1965; gen motohs = r(estimate) if dd==1965;
lincom _Idd_1985; replace motohs = r(estimate) if dd==1985;
lincom _Idd_1995; replace motohs = r(estimate) if dd==1995;
lincom _Idd_1998; replace motohs = r(estimate) if dd==1998;
lincom _Idd_2000; replace motohs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen motocl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace motocl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace motocl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace motocl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace motocl = r(estimate) if dd==2000;

xi:reg childyoung i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if mother2==1;

lincom _Idd_1965; gen moyghs = r(estimate) if dd==1965;
lincom _Idd_1985; replace moyghs = r(estimate) if dd==1985;
lincom _Idd_1995; replace moyghs = r(estimate) if dd==1995;
lincom _Idd_1998; replace moyghs = r(estimate) if dd==1998;
lincom _Idd_2000; replace moyghs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen moygcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace moygcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace moygcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace moygcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace moygcl = r(estimate) if dd==2000;

xi:reg childold i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if mother2==1;

lincom _Idd_1965; gen moolhs = r(estimate) if dd==1965;
lincom _Idd_1985; replace moolhs = r(estimate) if dd==1985;
lincom _Idd_1995; replace moolhs = r(estimate) if dd==1995;
lincom _Idd_1998; replace moolhs = r(estimate) if dd==1998;
lincom _Idd_2000; replace moolhs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen moolcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace moolcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace moolcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace moolcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace moolcl = r(estimate) if dd==2000;


xi:reg childplay i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if mother2==1;

lincom _Idd_1965; gen moplhs = r(estimate) if dd==1965;
lincom _Idd_1985; replace moplhs = r(estimate) if dd==1985;
lincom _Idd_1995; replace moplhs = r(estimate) if dd==1995;
lincom _Idd_1998; replace moplhs = r(estimate) if dd==1998;
lincom _Idd_2000; replace moplhs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen moplcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace moplcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace moplcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace moplcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace moplcl = r(estimate) if dd==2000;


xi:reg childeduc i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if mother2==1;

lincom _Idd_1965; gen moedhs = r(estimate) if dd==1965;
lincom _Idd_1985; replace moedhs = r(estimate) if dd==1985;
lincom _Idd_1995; replace moedhs = r(estimate) if dd==1995;
lincom _Idd_1998; replace moedhs = r(estimate) if dd==1998;
lincom _Idd_2000; replace moedhs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen moedcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace moedcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace moedcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace moedcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace moedcl = r(estimate) if dd==2000;


xi:reg childtravoth i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if mother2==1;

lincom _Idd_1965; gen motrhs = r(estimate) if dd==1965;
lincom _Idd_1985; replace motrhs = r(estimate) if dd==1985;
lincom _Idd_1995; replace motrhs = r(estimate) if dd==1995;
lincom _Idd_1998; replace motrhs = r(estimate) if dd==1998;
lincom _Idd_2000; replace motrhs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen motrcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace motrcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace motrcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace motrcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace motrcl = r(estimate) if dd==2000;


xi:reg childhealth i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if mother2==1;

lincom _Idd_1965; gen mohlhs = r(estimate) if dd==1965;
lincom _Idd_1985; replace mohlhs = r(estimate) if dd==1985;
lincom _Idd_1995; replace mohlhs = r(estimate) if dd==1995;
lincom _Idd_1998; replace mohlhs = r(estimate) if dd==1998;
lincom _Idd_2000; replace mohlhs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen mohlcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace mohlcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace mohlcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace mohlcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace mohlcl = r(estimate) if dd==2000;

xi:reg childtot i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if father2==1;

lincom _Idd_1965; gen fatohs = r(estimate) if dd==1965;
lincom _Idd_1985; replace fatohs = r(estimate) if dd==1985;
lincom _Idd_1995; replace fatohs = r(estimate) if dd==1995;
lincom _Idd_1998; replace fatohs = r(estimate) if dd==1998;
lincom _Idd_2000; replace fatohs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen fatocl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace fatocl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace fatocl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace fatocl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace fatocl = r(estimate) if dd==2000;


xi:reg childyoung i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if father2==1;

lincom _Idd_1965; gen fayghs = r(estimate) if dd==1965;
lincom _Idd_1985; replace fayghs = r(estimate) if dd==1985;
lincom _Idd_1995; replace fayghs = r(estimate) if dd==1995;
lincom _Idd_1998; replace fayghs = r(estimate) if dd==1998;
lincom _Idd_2000; replace fayghs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen faygcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace faygcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace faygcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace faygcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace faygcl = r(estimate) if dd==2000;

xi:reg childold i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if father2==1;

lincom _Idd_1965; gen faolhs = r(estimate) if dd==1965;
lincom _Idd_1985; replace faolhs = r(estimate) if dd==1985;
lincom _Idd_1995; replace faolhs = r(estimate) if dd==1995;
lincom _Idd_1998; replace faolhs = r(estimate) if dd==1998;
lincom _Idd_2000; replace faolhs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen faolcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace faolcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace faolcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace faolcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace faolcl = r(estimate) if dd==2000;


xi:reg childplay i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if father2==1;

lincom _Idd_1965; gen faplhs = r(estimate) if dd==1965;
lincom _Idd_1985; replace faplhs = r(estimate) if dd==1985;
lincom _Idd_1995; replace faplhs = r(estimate) if dd==1995;
lincom _Idd_1998; replace faplhs = r(estimate) if dd==1998;
lincom _Idd_2000; replace faplhs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen faplcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace faplcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace faplcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace faplcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace faplcl = r(estimate) if dd==2000;


xi:reg childeduc i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if father2==1;

lincom _Idd_1965; gen faedhs = r(estimate) if dd==1965;
lincom _Idd_1985; replace faedhs = r(estimate) if dd==1985;
lincom _Idd_1995; replace faedhs = r(estimate) if dd==1995;
lincom _Idd_1998; replace faedhs = r(estimate) if dd==1998;
lincom _Idd_2000; replace faedhs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen faedcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace faedcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace faedcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace faedcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace faedcl = r(estimate) if dd==2000;


xi:reg childtravoth i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if father2==1;

lincom _Idd_1965; gen fatrhs = r(estimate) if dd==1965;
lincom _Idd_1985; replace fatrhs = r(estimate) if dd==1985;
lincom _Idd_1995; replace fatrhs = r(estimate) if dd==1995;
lincom _Idd_1998; replace fatrhs = r(estimate) if dd==1998;
lincom _Idd_2000; replace fatrhs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen fatrcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace fatrcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace fatrcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace fatrcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace fatrcl = r(estimate) if dd==2000;


xi:reg childhealth i.dd*college i.agecat 
  under18 under182 married numyoung [aw=recwght] if father2==1;

lincom _Idd_1965; gen fahlhs = r(estimate) if dd==1965;
lincom _Idd_1985; replace fahlhs = r(estimate) if dd==1985;
lincom _Idd_1995; replace fahlhs = r(estimate) if dd==1995;
lincom _Idd_1998; replace fahlhs = r(estimate) if dd==1998;
lincom _Idd_2000; replace fahlhs = r(estimate) if dd==2000;

lincom _Idd_1965 + _IddXcol_1965-college; gen fahlcl = r(estimate) if dd==1965;
lincom _Idd_1985 + _IddXcol_1985-college; replace fahlcl = r(estimate) if dd==1985;
lincom _Idd_1995 + _IddXcol_1995-college; replace fahlcl = r(estimate) if dd==1995;
lincom _Idd_1998 + _IddXcol_1998-college; replace fahlcl = r(estimate) if dd==1998;
lincom _Idd_2000 + _IddXcol_2000-college; replace fahlcl = r(estimate) if dd==2000;


collapse 
motohs motocl moyghs moygcl moolhs moolcl moplhs moplcl 
moedhs moedcl motrhs motrcl mohlhs mohlcl
fatohs fatocl fayghs faygcl faolhs faolcl faplhs faplcl 
faedhs faedcl fatrhs fatrcl fahlhs fahlcl
, by(dd) ;

outsheet using junk.csv, replace comma;

log close;
