# delimit;

clear;

set more 1;
set mem 800m;

log using childcaretot.log, replace;

use merged_datasets; 

drop if dataset==.;

gen dd = 1965 if dataset==1965;
replace dd = 1975 if dataset==1975;
replace dd = 1985 if dataset==1985;
replace dd = 1993 if dataset==1993;
replace dd = 1995 if dataset==1995;
replace dd = 1998 if dataset==1998;
replace dd = 2000 if dataset==2000;
replace dd = 2003 if dataset==2003;
replace dd = 2004 if dataset==2004;
replace dd = 2005 if dataset==2005;
replace dd = 2006 if dataset==2006;
replace dd = 2007 if dataset==2007;
replace dd = 2008 if dataset==2008;

gen agecat=1 if age>=18 & age<=24;
replace agecat=2 if age>=25 & age<=34;
replace agecat=3 if age>=35 & age<=44;
replace agecat=4 if age>=45 & age<=54;
replace agecat=5 if age>=55 & age<=64;

replace agecat = 1 if rage==4 & dataset==1995;
replace agecat = 2 if rage==5 & dataset==1995;
replace agecat = 3 if rage==6 & dataset==1995;
replace agecat = 4 if rage==7 & dataset==1995;
replace agecat = 5 if rage==8 & dataset==1995;

drop if agecat==.;

gen infant = ageyngst<=1;
gen toddler = ageyngst==2;
gen preschool = (ageyngst<6 & ageyngst>2);
gen elementary1= (ageyngst>=6 & ageyngst<10);
gen elementary2= (ageyngst>=10 & ageyngst<14);
gen teen= (ageyngst>=14 & ageyngst<18);

gen under182 = under18^2;

gen haveyoung = under5>0;
replace haveyoung = under7>0 if dataset==1998;
replace haveyoung = ageyngst<5 if dataset>=2003;

char dd[omit] 1975;
char dataset[omit] 1975;
char college[omit] 1;
char agecat[omit] 2;

gen childnoplay = childtot - childplay;

gen ahtus = dataset<=1993;

drop if student==1;

* mother=1 is true mother;

summ childtot [aw=recwght] if mother==1 & dd==2003; 

* mother2 = 1 is female who lives in household with children present;

summ childtot [aw=recwght] if mother2==1 & dd==2003; 

replace mother2 = mother if dataset==2000; /* NSP 2000 is parents only */
replace father2 = father if dataset==2000; /* NSP 2000 is parents only */

/*Table 1 and Figure 1: Parents*/;

xi:reg childtot i.dd*college i.agecat [aw=recwght] if mother2==1;
outreg using table_1, replace se ;

xi:reg childtot i.dd*college i.agecat infant toddler preschool elementary1
  elementary2 under18 under182 married [aw=recwght] 
  if mother2==1 & ageyngst~=. & married~=.;
outreg using table_1, append se ;

xi:reg childtot i.dd*college i.agecat [aw=recwght] if father2==1; 
outreg using table_1, append se ;

xi:reg childtot i.dd*college i.agecat infant toddler preschool elementary1
  elementary2 under18 under182 married [aw=recwght] 
  if father2==1 & ageyngst~=. & married~=.;
outreg using table_1, append se ;



/*Figure 7 and Appendix_Table: All Adults*/;

xi:reg childtot i.dd*college i.agecat [aw=recwght] if sex==2 & dd~=2000;
outreg using appendix_table, replace se ;

xi:reg childtot i.dd*college i.agecat [aw=recwght] if sex==1 & dd~=2000;
outreg using appendix_table, append se ;


/*Table 3 */;

xi:reg childtot i.dd*college i.agecat [aw=recwght] if mother2==1; 
outreg using table_3, replace se ;

xi:reg childnoplay i.dd*college i.agecat [aw=recwght] if mother2==1; 
outreg using table_3, append se ;

xi:reg childtot i.dd*college i.agecat [aw=recwght] if father2==1; 
outreg using table_3, append se ;

xi:reg childnoplay i.dd*college i.agecat [aw=recwght] if father2==1; 
outreg using table_3, append se ;


*ROBUSTNESS CHECK: EXCLUDE THOSE WITH GRADUATE OR PROFESSIONAL DEGREES;

xi:reg childtot i.dd*college i.agecat [aw=recwght] if mother2==1 
  & pscollege==0; 

xi:reg childtot i.dd*college i.agecat infant toddler preschool elementary1
  elementary2 under18 under182 married [aw=recwght] 
  if mother2==1 & ageyngst~=. & married~=. & pscollege==0;


* Table 4 Working vs. working mothers;

summ childtot [aw=recwght] if mother2==1 & working==0 & dd==1975;
summ childtot [aw=recwght] if mother2==1 & working==0 & dd==1985;
summ childtot [aw=recwght] if mother2==1 & working==0 & dd==2008;

summ working [aw=recwght] if mother2==1 & dd==1975;
summ working [aw=recwght] if mother2==1 & dd==1985;
summ working [aw=recwght] if mother2==1 & dd==2008;

summ working [aw=recwght] if mother2==1 & dd==1975 & college==1;
summ working [aw=recwght] if mother2==1 & dd==1985 & college==1;
summ working [aw=recwght] if mother2==1 & dd==2008 & college==1;

xi:reg childtot i.dd*college i.agecat [aw=recwght] if mother2==1
  & working==0; 

xi:reg childtot i.dd*college i.agecat infant toddler preschool elementary1
  elementary2 under18 under182 married [aw=recwght] 
  if mother2==1 & ageyngst~=. & married~=. & working==0;

xi:reg childtot i.dd*college i.agecat [aw=recwght] if mother2==1
  & working==1; 

xi:reg childtot i.dd*college i.agecat infant toddler preschool elementary1
  elementary2 under18 under182 married [aw=recwght] 
  if mother2==1 & ageyngst~=. & married~=. & working==1;

* FIGURE 6: OTHER USES OF TIME;

xi:reg work i.dd*college i.agecat [aw=recwght] if mother2==1;
outreg using fig_6, replace ;

xi:reg chores i.dd*college i.agecat [aw=recwght] if mother2==1;
outreg using fig_6, append ;

log close;
