# delimit;

clear;

set more 1;
set mem 800m;

log using canada.log, replace;

use c:\timeusedata\canada\canadagss.dta; 

gen dd = 1986 if dataset==1986;
replace dd = 1992 if dataset==1992;
replace dd = 1998 if dataset==1998;
replace dd = 2005 if dataset==2005;

keep if english==1;

drop if agecat==6;

drop if age15_19==1;

*drop if agecat==5;

char college[omit] 1;
char agecat[omit] 2;

/* ADJUST FOR FACT THAT CHILCARE IN 1998 AND 2005 INCLUDES ONLY
    CARE TO CHILDREN AGES 0 TO 14  */

gen childtot = childcare0_18 if dataset==1986 | dataset==1992;

replace childtot = childcare0_14 if dataset==1998 | dataset==2005;

replace childtot = famcare if dataset==1998 & chr1518c>0;

gen numchild15_99 = chrinhsdc - numownchild0_14;

gen hv_child0_24 = livarr12==3 | livarr12==4;

replace childtot = famcare if dataset==2005 & hv_child>0 
  & ( numownchild0_14==0 
     | (chrtime6>=4 & chrtime6<=6 & numchild15_99>0 & hv_child0_24==1)); 

*gen childtot = famcare;


* 2005 ONLY COUNTS CHILDREN AGES 0 - 14;

replace numownchild = numownchild0_14 if dataset==2005;

replace numownchild = numownchild0_14 + 1 if numownchild0_14==0 & hv_child>0
  & dataset==2005;

gen numownchild2 = numownchild^2;


/*Table 5 Parents*/;

xi:reg childtot i.dd*college i.agecat [aw=recwght] if sex==2 & hv_child>0; 

xi:reg childtot i.dd*college i.agecat child_5 married numownchild 
  numownchild2 element adoles [aw=recwght] if sex==2 & hv_child>0; 

xi:reg childtot i.dd*college i.agecat [aw=recwght] if sex==1 & hv_child>0; 

xi:reg childtot i.dd*college i.agecat child_5 married numownchild 
  numownchild2 element adoles [aw=recwght] if sex==1 & hv_child>0; 

xi:reg famcare i.dd*college i.agecat [aw=recwght] if sex==2 & hv_child>0; 
outreg using table_5, replace se ;

xi:reg famcare i.dd*college i.agecat child_5 married numownchild 
  numownchild2 element adoles [aw=recwght] if sex==2 & hv_child>0; 
outreg using table_5, append se ;

xi:reg famcare i.dd*college i.agecat [aw=recwght] if sex==1 & hv_child>0; 
outreg using table_5, append se ;

xi:reg famcare i.dd*college i.agecat child_5 married numownchild 
  numownchild2 element adoles [aw=recwght] if sex==1 & hv_child>0; 
outreg using table_5, append se ;


*outreg using table_5, append se ;


log close;
