# delimit;

clear;

set more 1;
set mem 800m;

global path = "c:/rugrat/brookings/rugrat-replication/raw-data";

use $path/ahtus.dta; 

gen dataset = 1965 if survey==0 | survey==1;
replace dataset = 1975 if survey==2;
replace dataset = 1985 if survey==3;
replace dataset = 1993 if survey==4;

gen fips = state;
replace fips = state + 1 if state>=3;
replace fips = state + 2 if state>=6;
replace fips = state + 3 if state>=12;
replace fips = state + 4 if state>=40;
replace fips = state + 5 if state>=48;

drop if dataset==.;

gen dd = 1975 if dataset==1975;

replace educ=. if educ==-8;
replace civstat = . if civstat==-9 | civstat==-8;
replace nadult = . if nadult==-8 | nadult==-9;
replace under18 = . if under18==-8;
replace under5 = . if under5==-8 | under5==-9;

drop if educ == .;

replace ageyngst = . if ageyngst==-7 | ageyngst==-8 | ageyngst==-9;
replace empstat = . if empstat==-8;
replace empsp = . if empsp==-7 | empsp==-8 | empsp==-9;

gen married = civstat==1;
replace married = . if civstat==.;

gen working = (empstat==1 | empstat==2);

drop fulltime parttime;

gen fulltime = empstat==1;
gen parttime= empstat==2;
gen mother2 = under18>0 & under18~=. & sex==2;
gen father2 = under18>0 & under18~=. & sex==1;

gen dropout= educ<3;  /* high school dropout*/
gen hsonly= educ==3;  /* high school graduate*/
gen college = educ>=5 & educ~=.;  /* college grad and more */
gen pscollege = educ==6; /* post-college */

replace student = 0 if student<0;

gen childtot = 
  (7/60)*(tmain33 +   /* care of infants */
  tmain34 +  /* general care of older children */
  tmain35 +  /* medical care of children */
  tmain36 + /* play with children */
  tmain37 + /* supervise or help with homework */
  tmain38 + /* read to, talk with child */
  tmain39 + /* other child care */
  tmain65 + /* sports with children */
  tmain96) ; /* travel related to child care */

gen childeduc = 
  (7/60)*( tmain37 + /* supervise or help with homework */
  tmain38); /* read to, talk with child */

gen childplay = 
  (7/60)*(
  tmain36 + /* play with children */
  tmain65);  /* sports with children */

gen childtravel = (7/60)*tmain96;

gen childyoung = (7/60)*tmain33;
gen childold = (7/60)*tmain34;

gen childhealth = (7/60)*tmain35;
gen childoth = (7/60)*tmain39;


gen work =
  (7/60)*(tmain10 + /* main paid work (not at home) */
  tmain11 + /* paid work at home */
  tmain12 + /* second job, other paid work */
  tmain92 + /* travel as part of work*/
  tmain93) ; /* travel to/from work + other work travel */

/* omits 13- work breaks, 14-other time at workplace not working,
 and 15- time looking for work*/

gen chores = 
  (7/60)*(tmain20 + /* food preparation, cooking */
  tmain21 + /* set table, wash/put away dishes */
  tmain22 + /* cleaning */
  tmain23 + /* laundry, ironing, clothing repair */
  tmain24 + /* home repairs, maintain vehicle */
  tmain25 + /* other domestic work */
  tmain26 + /* purchase routine goods */
  tmain27 + /* purchase consumer durables */
  tmain30 + /* purchase repair, laundry services */
  tmain31 + /* financial, government services */
  tmain32 + /* purchase other services */
  tmain40 + /* adult care */
  tmain67 + /*gardening*/
  tmain68 + /*pet care*/
  tmain95) ; /* travel related to consumption */

/*
  tmain28 + /* purchase personal services */
  tmain29 + /* purchase medical services */
*/

gen freepers = 168 - (childtot + work + chores);

drop if age<18 | age>=65;

rename tmain33 act20;
rename tmain34 act21;
rename tmain37 act22;
rename tmain38 act23;
rename tmain36 act24;
rename tmain65 act25;
rename tmain35 act26;
rename tmain39 act27;
rename tmain96 act29;
rename tmain44 act67;

drop _merge;

sort survey hhid ;

merge survey hhid using $path/merge75.dta;

tab _merge;

gen ageoldst = v419 if v419>0 & v419<19;
replace ageoldst = ageoldst + 1 if wave>=4;

keep age sex mother2 father2 married ethnic working fulltime parttime recwght 
  childtot childeduc childplay childyoung childold childhealth childoth
  childtravel work chores freepers college pscollege dropout hsonly 
  act20 act21 act22 act23 act24 act25 act26 act27 act29 act67
  ageyngst ageoldst under18 under5 student state fips dataset;

save ahtus_subset.dta, replace;

