clear all
clear all;
global x_t y_t t k;
OPTIONS = optimset('MaxFunEvals',600,'Maxiter',100,'TolFun',1e-12);

anp = ' & ';
dslash = ' \\ ';
hline = ' \hline ';
bf = ' \bf ';
leftp = '(';
rightp = ')';

data = dlmread('RGDP_RGDI_47.csv',',');
n = size(data,1);

RGDP_diff = (((data(57:n,2)./data(56:n-1,2)).^4)-1)*100;
RGDP_diff4 = ((data(57:n,2)-data(53:n-4,2))./data(53:n-4,2))*100;

RGDI_diff = (((data(57:n,3)./data(56:n-1,3)).^4)-1)*100;
RGDI_diff4 = ((data(57:n,3)-data(53:n-4,3))./data(53:n-4,3))*100;

dataUR = dlmread('UR.csv',',');
t_u = size(dataUR,1);

UR_diff = (dataUR(53:t_u,2)-dataUR(52:t_u-1,2))*4;
UR_diff4 = dataUR(53:t_u,2)-dataUR(49:t_u-4,2);

UR_diff_1 = (dataUR(52:t_u-1,2)-dataUR(51:t_u-2,2))*4;

t = size(RGDI_diff4,1);
[dataUR(53:t_u,1)/1000 UR_diff RGDP_diff RGDI_diff UR_diff4 RGDP_diff4 RGDI_diff4]

tstart=95
tend = 184

out = zeros(24,5);

'1-quarter diffs, 1984Q3 to present'
y = RGDI_diff(tstart:tend)
n = size(y,1)
control1 = ones(size(y));

x = [UR_diff(tstart:tend) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e2 = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e2'*e2/(n-kv))/(ss/(n-1)))
rmse = (e2'*e2/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e2*e2'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e2*e2',1)',1);
   h_1_ = diag(diag(e2*e2',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e2*e2',2)',2);
   h_2_ = diag(diag(e2*e2',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e2*e2',3)',3);
   h_3_ = diag(diag(e2*e2',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e2*e2',4)',4);
   h_4_ = diag(diag(e2*e2',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e2*e2',5)',5);
   h_5_ = diag(diag(e2*e2',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e2*e2',6)',6);
   h_6_ = diag(diag(e2*e2',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e2*e2',7)',7);
   h_7_ = diag(diag(e2*e2',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e2*e2',8)',8);
   h_8_ = diag(diag(e2*e2',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e2'*e2)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
beta2 = beta;
asyvar2 = asyvar;
asyvarc2 = asyvarc;

out(1,1:2) = [beta(1) rsq];
out(2,1:2) = [se_newey(1) 0];

y = RGDP_diff(tstart:tend);
n = size(y,1);

x = [UR_diff(tstart:tend) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e4 = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e4'*e4/(n-kv))/(ss/(n-1)))
rmse = (e4'*e4/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e4*e4'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e4*e4',1)',1);
   h_1_ = diag(diag(e4*e4',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e4*e4',2)',2);
   h_2_ = diag(diag(e4*e4',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e4*e4',3)',3);
   h_3_ = diag(diag(e4*e4',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e4*e4',4)',4);
   h_4_ = diag(diag(e4*e4',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e4*e4',5)',5);
   h_5_ = diag(diag(e4*e4',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e4*e4',6)',6);
   h_6_ = diag(diag(e4*e4',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e4*e4',7)',7);
   h_7_ = diag(diag(e4*e4',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e4*e4',8)',8);
   h_8_ = diag(diag(e4*e4',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e4'*e4)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
beta4 = beta;
asyvar4 = asyvar;
asyvarc4 = asyvarc;

out(1,3:4) = [beta(1) rsq];
out(2,3:4) = [se_newey(1) 0];


% Testing equality of sum of coefficients from regressions 2 and 4
summer_diff_24 = [-1; 0; 1; 0];
beta_diff_24 = summer_diff_24'*[beta2; beta4]

% OLS:
asyvar_ols_24 = [sum(e2'*e2)/(n-kv)*inv(x'*x) sum(e2'*e4)/(n-kv)*inv(x'*x); sum(e4'*e2)/(n-kv)*inv(x'*x) sum(e4'*e4)/(n-kv)*inv(x'*x)];
se_ols_beta_diff_24 = (summer_diff_24'*asyvar_ols_24*summer_diff_24)^(0.5)

% White and Newey-West:
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e2*e4'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e2*e4',1)',1);
   h_1_ = diag(diag(e2*e4',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e2*e4',2)',2);
   h_2_ = diag(diag(e2*e4',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e2*e4',3)',3);
   h_3_ = diag(diag(e2*e4',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e2*e4',4)',4);
   h_4_ = diag(diag(e2*e4',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e2*e4',5)',5);
   h_5_ = diag(diag(e2*e4',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e2*e4',6)',6);
   h_6_ = diag(diag(e2*e4',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e2*e4',7)',7);
   h_7_ = diag(diag(e2*e4',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e2*e4',8)',8);
   h_8_ = diag(diag(e2*e4',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvar24 = inv(x'*x)*P0*inv(x'*x);
asyvarc24 = inv(x'*x)*omega*inv(x'*x);

 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e4*e2'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e4*e2',1)',1);
   h_1_ = diag(diag(e4*e2',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e4*e2',2)',2);
   h_2_ = diag(diag(e4*e2',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e4*e2',3)',3);
   h_3_ = diag(diag(e4*e2',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e4*e2',4)',4);
   h_4_ = diag(diag(e4*e2',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e4*e2',5)',5);
   h_5_ = diag(diag(e4*e2',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e4*e2',6)',6);
   h_6_ = diag(diag(e4*e2',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e4*e2',7)',7);
   h_7_ = diag(diag(e4*e2',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e4*e2',8)',8);
   h_8_ = diag(diag(e4*e2',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvar42 = inv(x'*x)*P0*inv(x'*x);
asyvarc42 = inv(x'*x)*omega*inv(x'*x);

asyvar_24 = [asyvar2 asyvar24; asyvar42 asyvar4];
se_white_beta_diff_24 = (summer_diff_24'*asyvar_24*summer_diff_24)^(0.5)

asyvarc_24 = [asyvarc2 asyvarc24; asyvarc42 asyvarc4];
se_newey_beta_diff_24 = (summer_diff_24'*asyvarc_24*summer_diff_24)^(0.5)
test_newey_beta_diff_24 = beta_diff_24'*((summer_diff_24'*asyvarc_24*summer_diff_24)^(-1))*beta_diff_24
pvalue_newey_beta_diff_24 = 1-chi2cdf(test_newey_beta_diff_24,1)
pvalue_newey_beta_diff_24f = 1-fcdf(test_newey_beta_diff_24,1,n-kv)

out(1,5) = pvalue_newey_beta_diff_24;

'Output t to t-1, Unempl t to t-4, 1984Q3 to present'
j=0
y = RGDI_diff(tstart:tend);
n = size(y,1)
control1 = ones(size(y));

x = [UR_diff4(tstart+j:tend+j) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e2 = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e2'*e2/(n-kv))/(ss/(n-1)))
rmse = (e2'*e2/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e2*e2'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e2*e2',1)',1);
   h_1_ = diag(diag(e2*e2',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e2*e2',2)',2);
   h_2_ = diag(diag(e2*e2',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e2*e2',3)',3);
   h_3_ = diag(diag(e2*e2',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e2*e2',4)',4);
   h_4_ = diag(diag(e2*e2',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e2*e2',5)',5);
   h_5_ = diag(diag(e2*e2',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e2*e2',6)',6);
   h_6_ = diag(diag(e2*e2',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e2*e2',7)',7);
   h_7_ = diag(diag(e2*e2',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e2*e2',8)',8);
   h_8_ = diag(diag(e2*e2',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e2'*e2)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
beta2 = beta;
asyvar2 = asyvar;
asyvarc2 = asyvarc;

out(11,1:2) = [beta(1) rsq];
out(12,1:2) = [se_newey(1) 0];

y = RGDP_diff(tstart:tend);
n = size(y,1);

x = [UR_diff4(tstart+j:tend+j) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e4 = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e4'*e4/(n-kv))/(ss/(n-1)))
rmse = (e4'*e4/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e4*e4'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e4*e4',1)',1);
   h_1_ = diag(diag(e4*e4',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e4*e4',2)',2);
   h_2_ = diag(diag(e4*e4',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e4*e4',3)',3);
   h_3_ = diag(diag(e4*e4',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e4*e4',4)',4);
   h_4_ = diag(diag(e4*e4',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e4*e4',5)',5);
   h_5_ = diag(diag(e4*e4',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e4*e4',6)',6);
   h_6_ = diag(diag(e4*e4',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e4*e4',7)',7);
   h_7_ = diag(diag(e4*e4',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e4*e4',8)',8);
   h_8_ = diag(diag(e4*e4',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e4'*e4)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
beta4 = beta;
asyvar4 = asyvar;
asyvarc4 = asyvarc;

out(11,3:4) = [beta(1) rsq];
out(12,3:4) = [se_newey(1) 0];

% Testing equality of sum of coefficients from regressions 2 and 4
summer_diff_24 = [-1; 0; 1; 0];
beta_diff_24 = summer_diff_24'*[beta2; beta4]

% OLS:
asyvar_ols_24 = [sum(e2'*e2)/(n-kv)*inv(x'*x) sum(e2'*e4)/(n-kv)*inv(x'*x); sum(e4'*e2)/(n-kv)*inv(x'*x) sum(e4'*e4)/(n-kv)*inv(x'*x)];
se_ols_beta_diff_24 = (summer_diff_24'*asyvar_ols_24*summer_diff_24)^(0.5)

% White and Newey-West:
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e2*e4'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e2*e4',1)',1);
   h_1_ = diag(diag(e2*e4',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e2*e4',2)',2);
   h_2_ = diag(diag(e2*e4',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e2*e4',3)',3);
   h_3_ = diag(diag(e2*e4',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e2*e4',4)',4);
   h_4_ = diag(diag(e2*e4',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e2*e4',5)',5);
   h_5_ = diag(diag(e2*e4',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e2*e4',6)',6);
   h_6_ = diag(diag(e2*e4',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e2*e4',7)',7);
   h_7_ = diag(diag(e2*e4',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e2*e4',8)',8);
   h_8_ = diag(diag(e2*e4',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvar24 = inv(x'*x)*P0*inv(x'*x);
asyvarc24 = inv(x'*x)*omega*inv(x'*x);

 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e4*e2'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e4*e2',1)',1);
   h_1_ = diag(diag(e4*e2',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e4*e2',2)',2);
   h_2_ = diag(diag(e4*e2',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e4*e2',3)',3);
   h_3_ = diag(diag(e4*e2',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e4*e2',4)',4);
   h_4_ = diag(diag(e4*e2',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e4*e2',5)',5);
   h_5_ = diag(diag(e4*e2',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e4*e2',6)',6);
   h_6_ = diag(diag(e4*e2',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e4*e2',7)',7);
   h_7_ = diag(diag(e4*e2',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e4*e2',8)',8);
   h_8_ = diag(diag(e4*e2',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvar42 = inv(x'*x)*P0*inv(x'*x);
asyvarc42 = inv(x'*x)*omega*inv(x'*x);

asyvar_24 = [asyvar2 asyvar24; asyvar42 asyvar4];
se_white_beta_diff_24 = (summer_diff_24'*asyvar_24*summer_diff_24)^(0.5)

asyvarc_24 = [asyvarc2 asyvarc24; asyvarc42 asyvarc4];
se_newey_beta_diff_24 = (summer_diff_24'*asyvarc_24*summer_diff_24)^(0.5)
test_newey_beta_diff_24 = beta_diff_24'*((summer_diff_24'*asyvarc_24*summer_diff_24)^(-1))*beta_diff_24
pvalue_newey_beta_diff_24 = 1-chi2cdf(test_newey_beta_diff_24,1)
pvalue_newey_beta_diff_24f = 1-fcdf(test_newey_beta_diff_24,1,n-kv)

out(11,5) = pvalue_newey_beta_diff_24;


'Output t to t-1, Unempl t+j to t+j-4, 1984Q3 to present'
for j = 1:4
y = RGDI_diff(tstart:tend);
n = size(y,1)
control1 = ones(size(y));

x = [UR_diff4(tstart+j:tend+j) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e2 = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e2'*e2/(n-kv))/(ss/(n-1)))
rmse = (e2'*e2/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e2*e2'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e2*e2',1)',1);
   h_1_ = diag(diag(e2*e2',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e2*e2',2)',2);
   h_2_ = diag(diag(e2*e2',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e2*e2',3)',3);
   h_3_ = diag(diag(e2*e2',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e2*e2',4)',4);
   h_4_ = diag(diag(e2*e2',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e2*e2',5)',5);
   h_5_ = diag(diag(e2*e2',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e2*e2',6)',6);
   h_6_ = diag(diag(e2*e2',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e2*e2',7)',7);
   h_7_ = diag(diag(e2*e2',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e2*e2',8)',8);
   h_8_ = diag(diag(e2*e2',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e2'*e2)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
beta2 = beta;
asyvar2 = asyvar;
asyvarc2 = asyvarc;

out(11+(j*2),1:2) = [beta(1) rsq];
out(12+(j*2),1:2) = [se_newey(1) 0];

y = RGDP_diff(tstart:tend);
n = size(y,1);

x = [UR_diff4(tstart+j:tend+j) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e4 = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e4'*e4/(n-kv))/(ss/(n-1)))
rmse = (e4'*e4/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e4*e4'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e4*e4',1)',1);
   h_1_ = diag(diag(e4*e4',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e4*e4',2)',2);
   h_2_ = diag(diag(e4*e4',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e4*e4',3)',3);
   h_3_ = diag(diag(e4*e4',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e4*e4',4)',4);
   h_4_ = diag(diag(e4*e4',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e4*e4',5)',5);
   h_5_ = diag(diag(e4*e4',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e4*e4',6)',6);
   h_6_ = diag(diag(e4*e4',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e4*e4',7)',7);
   h_7_ = diag(diag(e4*e4',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e4*e4',8)',8);
   h_8_ = diag(diag(e4*e4',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e4'*e4)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
beta4 = beta;
asyvar4 = asyvar;
asyvarc4 = asyvarc;

out(11+(j*2),3:4) = [beta(1) rsq];
out(12+(j*2),3:4) = [se_newey(1) 0];

% Testing equality of sum of coefficients from regressions 2 and 4
summer_diff_24 = [-1; 0; 1; 0];
beta_diff_24 = summer_diff_24'*[beta2; beta4]

% OLS:
asyvar_ols_24 = [sum(e2'*e2)/(n-kv)*inv(x'*x) sum(e2'*e4)/(n-kv)*inv(x'*x); sum(e4'*e2)/(n-kv)*inv(x'*x) sum(e4'*e4)/(n-kv)*inv(x'*x)];
se_ols_beta_diff_24 = (summer_diff_24'*asyvar_ols_24*summer_diff_24)^(0.5)

% White and Newey-West:
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e2*e4'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e2*e4',1)',1);
   h_1_ = diag(diag(e2*e4',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e2*e4',2)',2);
   h_2_ = diag(diag(e2*e4',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e2*e4',3)',3);
   h_3_ = diag(diag(e2*e4',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e2*e4',4)',4);
   h_4_ = diag(diag(e2*e4',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e2*e4',5)',5);
   h_5_ = diag(diag(e2*e4',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e2*e4',6)',6);
   h_6_ = diag(diag(e2*e4',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e2*e4',7)',7);
   h_7_ = diag(diag(e2*e4',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e2*e4',8)',8);
   h_8_ = diag(diag(e2*e4',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvar24 = inv(x'*x)*P0*inv(x'*x);
asyvarc24 = inv(x'*x)*omega*inv(x'*x);

 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e4*e2'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e4*e2',1)',1);
   h_1_ = diag(diag(e4*e2',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e4*e2',2)',2);
   h_2_ = diag(diag(e4*e2',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e4*e2',3)',3);
   h_3_ = diag(diag(e4*e2',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e4*e2',4)',4);
   h_4_ = diag(diag(e4*e2',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e4*e2',5)',5);
   h_5_ = diag(diag(e4*e2',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e4*e2',6)',6);
   h_6_ = diag(diag(e4*e2',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e4*e2',7)',7);
   h_7_ = diag(diag(e4*e2',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e4*e2',8)',8);
   h_8_ = diag(diag(e4*e2',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvar42 = inv(x'*x)*P0*inv(x'*x);
asyvarc42 = inv(x'*x)*omega*inv(x'*x);

asyvar_24 = [asyvar2 asyvar24; asyvar42 asyvar4];
se_white_beta_diff_24 = (summer_diff_24'*asyvar_24*summer_diff_24)^(0.5)

asyvarc_24 = [asyvarc2 asyvarc24; asyvarc42 asyvarc4];
se_newey_beta_diff_24 = (summer_diff_24'*asyvarc_24*summer_diff_24)^(0.5)
test_newey_beta_diff_24 = beta_diff_24'*((summer_diff_24'*asyvarc_24*summer_diff_24)^(-1))*beta_diff_24
pvalue_newey_beta_diff_24 = 1-chi2cdf(test_newey_beta_diff_24,1)
pvalue_newey_beta_diff_24f = 1-fcdf(test_newey_beta_diff_24,1,n-kv)

out(11+(j*2),5) = pvalue_newey_beta_diff_24;

end;

'4-quarter diffs, 1984Q3 to present'
y = RGDI_diff4(tstart:tend);
n = size(y,1)
control1 = ones(size(y));

x = [UR_diff4(tstart:tend) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e2 = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e2'*e2/(n-kv))/(ss/(n-1)))
rmse = (e2'*e2/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e2*e2'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e2*e2',1)',1);
   h_1_ = diag(diag(e2*e2',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e2*e2',2)',2);
   h_2_ = diag(diag(e2*e2',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e2*e2',3)',3);
   h_3_ = diag(diag(e2*e2',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e2*e2',4)',4);
   h_4_ = diag(diag(e2*e2',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e2*e2',5)',5);
   h_5_ = diag(diag(e2*e2',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e2*e2',6)',6);
   h_6_ = diag(diag(e2*e2',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e2*e2',7)',7);
   h_7_ = diag(diag(e2*e2',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e2*e2',8)',8);
   h_8_ = diag(diag(e2*e2',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e2'*e2)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
beta2 = beta;
asyvar2 = asyvar;
asyvarc2 = asyvarc;

out(21,1:2) = [beta(1) rsq];
out(22,1:2) = [se_newey(1) 0];

y = RGDP_diff4(tstart:tend);
n = size(y,1);

x = [UR_diff4(tstart:tend) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e4 = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e4'*e4/(n-kv))/(ss/(n-1)))
rmse = (e4'*e4/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e4*e4'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e4*e4',1)',1);
   h_1_ = diag(diag(e4*e4',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e4*e4',2)',2);
   h_2_ = diag(diag(e4*e4',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e4*e4',3)',3);
   h_3_ = diag(diag(e4*e4',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e4*e4',4)',4);
   h_4_ = diag(diag(e4*e4',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e4*e4',5)',5);
   h_5_ = diag(diag(e4*e4',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e4*e4',6)',6);
   h_6_ = diag(diag(e4*e4',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e4*e4',7)',7);
   h_7_ = diag(diag(e4*e4',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e4*e4',8)',8);
   h_8_ = diag(diag(e4*e4',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e4'*e4)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
beta4 = beta;
asyvar4 = asyvar;
asyvarc4 = asyvarc;

out(21,3:4) = [beta(1) rsq];
out(22,3:4) = [se_newey(1) 0];

% Testing equality of sum of coefficients from regressions 2 and 4
summer_diff_24 = [-1; 0; 1; 0];
beta_diff_24 = summer_diff_24'*[beta2; beta4]

% OLS:
asyvar_ols_24 = [sum(e2'*e2)/(n-kv)*inv(x'*x) sum(e2'*e4)/(n-kv)*inv(x'*x); sum(e4'*e2)/(n-kv)*inv(x'*x) sum(e4'*e4)/(n-kv)*inv(x'*x)];
se_ols_beta_diff_24 = (summer_diff_24'*asyvar_ols_24*summer_diff_24)^(0.5)

% White and Newey-West:
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e2*e4'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e2*e4',1)',1);
   h_1_ = diag(diag(e2*e4',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e2*e4',2)',2);
   h_2_ = diag(diag(e2*e4',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e2*e4',3)',3);
   h_3_ = diag(diag(e2*e4',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e2*e4',4)',4);
   h_4_ = diag(diag(e2*e4',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e2*e4',5)',5);
   h_5_ = diag(diag(e2*e4',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e2*e4',6)',6);
   h_6_ = diag(diag(e2*e4',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e2*e4',7)',7);
   h_7_ = diag(diag(e2*e4',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e2*e4',8)',8);
   h_8_ = diag(diag(e2*e4',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvar24 = inv(x'*x)*P0*inv(x'*x);
asyvarc24 = inv(x'*x)*omega*inv(x'*x);

 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e4*e2'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e4*e2',1)',1);
   h_1_ = diag(diag(e4*e2',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e4*e2',2)',2);
   h_2_ = diag(diag(e4*e2',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e4*e2',3)',3);
   h_3_ = diag(diag(e4*e2',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e4*e2',4)',4);
   h_4_ = diag(diag(e4*e2',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e4*e2',5)',5);
   h_5_ = diag(diag(e4*e2',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e4*e2',6)',6);
   h_6_ = diag(diag(e4*e2',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e4*e2',7)',7);
   h_7_ = diag(diag(e4*e2',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e4*e2',8)',8);
   h_8_ = diag(diag(e4*e2',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvar42 = inv(x'*x)*P0*inv(x'*x);
asyvarc42 = inv(x'*x)*omega*inv(x'*x);

asyvar_24 = [asyvar2 asyvar24; asyvar42 asyvar4];
se_white_beta_diff_24 = (summer_diff_24'*asyvar_24*summer_diff_24)^(0.5)

asyvarc_24 = [asyvarc2 asyvarc24; asyvarc42 asyvarc4];
se_newey_beta_diff_24 = (summer_diff_24'*asyvarc_24*summer_diff_24)^(0.5)
test_newey_beta_diff_24 = beta_diff_24'*((summer_diff_24'*asyvarc_24*summer_diff_24)^(-1))*beta_diff_24
pvalue_newey_beta_diff_24 = 1-chi2cdf(test_newey_beta_diff_24,1)
pvalue_newey_beta_diff_24f = 1-fcdf(test_newey_beta_diff_24,1,n-kv)

out(21,5) = pvalue_newey_beta_diff_24;

out_row1 = [' $\left(UR_{t} - UR_{t-1}\right)*4$ ' anp bf num2str(out(1,2),'%3.2f') anp bf num2str(out(1,4),'%3.2f') anp bf num2str(out(1,1),'%3.2f') anp bf num2str(out(1,3),'%3.2f') anp num2str(out(1,5),'%3.2f') dslash anp anp anp leftp num2str(out(2,1),'%3.2f') rightp anp leftp num2str(out(2,3),'%3.2f') rightp anp dslash]
out_row6 = [' $UR_{t} - UR_{t-4}$ ' anp bf num2str(out(11,2),'%3.2f') anp bf num2str(out(11,4),'%3.2f') anp bf num2str(out(11,1),'%3.2f') anp bf num2str(out(11,3),'%3.2f') anp num2str(out(11,5),'%3.2f') dslash anp anp anp leftp num2str(out(12,1),'%3.2f') rightp anp leftp num2str(out(12,3),'%3.2f') rightp anp dslash]
out_row8 = [' $UR_{t+2} - UR_{t-2}$ ' anp bf num2str(out(15,2),'%3.2f') anp bf num2str(out(15,4),'%3.2f') anp bf num2str(out(15,1),'%3.2f') anp bf num2str(out(15,3),'%3.2f') anp num2str(out(15,5),'%3.2f') dslash anp anp anp leftp num2str(out(16,1),'%3.2f') rightp anp leftp num2str(out(16,3),'%3.2f') rightp anp dslash]
out_row10 = [' $UR_{t+4} - UR_{t}$ ' anp bf num2str(out(19,2),'%3.2f') anp bf num2str(out(19,4),'%3.2f') anp bf num2str(out(19,1),'%3.2f') anp bf num2str(out(19,3),'%3.2f') anp num2str(out(19,5),'%3.2f') dslash anp anp anp leftp num2str(out(20,1),'%3.2f') rightp anp leftp num2str(out(20,3),'%3.2f') rightp anp dslash]

out_table = [out_row1 out_row6 out_row8 out_row10]
dlmwrite('table_LoSE_UR.txt',out_table,'');
