clear all
global y t;
OPTIONS = optimset('MaxFunEvals',600,'Maxiter',200,'TolFun',1e-12);

anp = ' & ';
dslash = ' \\ ';
hline = ' \hline ';
bf = ' \bf ';
leftp = '(';
rightp = ')';

dataRGDP = dlmread('vintage_growth_currqtrly.csv',',');
dataRGDI = dlmread('vintage_realGDI_growth_currqtrly.csv',',');

RGDP_fin = dataRGDP(:,7);
RGDP_latest = dataRGDP(:,8);
RGDP_rev = RGDP_fin - RGDP_latest;
RGDI_fin = dataRGDI(:,5);
RGDI_latest = dataRGDI(:,6);
RGDI_rev = RGDI_fin - RGDI_latest;
%[dataRGDP(:,1)/100 dataRGDP(:,2)/1000 RGDP_fin RGDP_latest RGDI_fin RGDI_latest]

[dataRGDP(:,1)/100 dataRGDP(:,2)/1000 RGDP_fin RGDP_latest RGDP_rev RGDI_fin RGDI_latest RGDI_rev]

%tstart = 27;
%tend = 116;

tstart = 3;
tend = 127;

cov_out = cov([RGDP_fin(tstart:tend) RGDI_fin(tstart:tend) RGDP_latest(tstart:tend) RGDI_latest(tstart:tend) RGDP_rev(tstart:tend) RGDI_rev(tstart:tend)])
corr_out = corr([RGDP_fin(tstart:tend) RGDI_fin(tstart:tend) RGDP_latest(tstart:tend) RGDI_latest(tstart:tend)])

out_row1 = [bf num2str(cov_out(1,1),'%3.2f') anp bf num2str(cov_out(1,2),'%3.2f') anp num2str(cov_out(1,3),'%3.2f') anp num2str(cov_out(1,4),'%3.2f') dslash]
out_row2 = [bf num2str(cov_out(2,1),'%3.2f') anp bf num2str(cov_out(2,2),'%3.2f') anp num2str(cov_out(2,3),'%3.2f') anp num2str(cov_out(2,4),'%3.2f') dslash]
out_row3 = [num2str(cov_out(3,1),'%3.2f') anp num2str(cov_out(3,2),'%3.2f') anp bf num2str(cov_out(3,3),'%3.2f') anp bf num2str(cov_out(3,4),'%3.2f') dslash]
out_row4 = [num2str(cov_out(4,1),'%3.2f') anp num2str(cov_out(4,2),'%3.2f') anp bf num2str(cov_out(4,3),'%3.2f') anp bf num2str(cov_out(4,4),'%3.2f') dslash]

out_row5 = ['Init. $\Delta GDP(E)$' anp num2str(corr_out(1,1),'%3.2f') anp bf num2str(corr_out(1,2),'%3.2f') anp num2str(corr_out(1,3),'%3.2f') anp num2str(corr_out(1,4),'%3.2f') dslash]
out_row6 = ['Init. $\Delta GDP(I)$' anp bf num2str(corr_out(2,1),'%3.2f') anp num2str(corr_out(2,2),'%3.2f') anp num2str(corr_out(2,3),'%3.2f') anp num2str(corr_out(2,4),'%3.2f') dslash]
out_row7 = ['Latest $\Delta GDP(E)$' anp num2str(corr_out(3,1),'%3.2f') anp num2str(corr_out(3,2),'%3.2f') anp num2str(corr_out(3,3),'%3.2f') anp bf num2str(corr_out(3,4),'%3.2f') dslash]
out_row8 = ['Latest $\Delta GDP(I)$' anp num2str(corr_out(4,1),'%3.2f') anp num2str(corr_out(4,2),'%3.2f') anp bf num2str(corr_out(4,3),'%3.2f') anp num2str(corr_out(4,4),'%3.2f') dslash]

out_table1 = [out_row1 out_row2 out_row3 out_row4] 
out_table2 = [out_row5 out_row6 out_row7 out_row8]

%dlmwrite('table_cov.txt',out_table1,'');
%dlmwrite('table_corr.txt',out_table2,'');

dlmwrite('table_cov2.txt',out_table1,'');
dlmwrite('table_corr2.txt',out_table2,'');
