clear all

anp = ' & ';
dslash = ' \\ ';
hline = ' \hline ';
bf = ' \bf ';
leftp = '(';
rightp = ')';
qtr1 = 'k=1';
qtr2 = 'k=2';
qtr3 = 'k=3';
qtr4 = 'k=4';
qtr5 = 'k=5';
qtr6 = 'k=6';
qtr7 = 'k=7';
qtr8 = 'k=8';
%qtr1 = 'k=1 (1 Quarter Ahead)';
%qtr2 = 'k=2 (2 Quarters Ahead)';
%qtr3 = 'k=3 (3 Quarters Ahead)';
%qtr4 = 'k=4 (4 Quarters Ahead)';
%qtr5 = 'k=5 (5 Quarters Ahead)';
%qtr6 = 'k=6 (6 Quarters Ahead)';
%qtr7 = 'k=7 (7 Quarters Ahead)';
%qtr8 = 'k=8 (8 Quarters Ahead)';


'Post 1984Q3'
data_assets = dlmread('stock_price_changes_qtrly.csv',',');
t_assets = size(data_assets,1);
term_spread_2yr = data_assets(2:t_assets,4)-data_assets(2:t_assets,6);

% GDP and GDI data, 1978 to 2005
dataRGDP = dlmread('vintage_growth_currqtrly.csv',',');
dataRGDI = dlmread('vintage_realGDI_growth_currqtrly.csv',',');

[dataRGDI(:,1) dataRGDI(:,2)/1000 dataRGDI(:,4:6) dataRGDP(:,5:8)]

tall = size(dataRGDI,1)
tstart = 27;
tend = 116;

for i=1:8;

i    
y = dataRGDP(tstart:tend,8);
n = size(y,1); 
control1 = ones(size(y));

x = [term_spread_2yr(tstart-9-i:tend-9-i) control1];

k = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta;
e2 = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e2'*e2/(n-k))/(ss/(n-1)))
rmse = (e2'*e2/(n-k))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e2*e2'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e2*e2',1)',1);
   h_1_ = diag(diag(e2*e2',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e2*e2',2)',2);
   h_2_ = diag(diag(e2*e2',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e2*e2',3)',3);
   h_3_ = diag(diag(e2*e2',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e2*e2',4)',4);
   h_4_ = diag(diag(e2*e2',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e2*e2',5)',5);
   h_5_ = diag(diag(e2*e2',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e2*e2',6)',6);
   h_6_ = diag(diag(e2*e2',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e2*e2',7)',7);
   h_7_ = diag(diag(e2*e2',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e2*e2',8)',8);
   h_8_ = diag(diag(e2*e2',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e2'*e2)/(n-k)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
beta2 = beta;
asyvar2 = asyvar;
asyvarc2 = asyvarc;

out((2*i)-1,3:4) = beta(1:2)';
out((2*i),3:4) = se_newey(1:2)';
out_rsq((2*i)-1,3) = rsq;


y = dataRGDI(tstart:tend,6);
n = size(y,1);
control1 = ones(size(y));

k = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta;
e4 = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e4'*e4/(n-k))/(ss/(n-1)))
rmse = (e4'*e4/(n-k))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e4*e4'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e4*e4',1)',1);
   h_1_ = diag(diag(e4*e4',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e4*e4',2)',2);
   h_2_ = diag(diag(e4*e4',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e4*e4',3)',3);
   h_3_ = diag(diag(e4*e4',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e4*e4',4)',4);
   h_4_ = diag(diag(e4*e4',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e4*e4',5)',5);
   h_5_ = diag(diag(e4*e4',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e4*e4',6)',6);
   h_6_ = diag(diag(e4*e4',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e4*e4',7)',7);
   h_7_ = diag(diag(e4*e4',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e4*e4',8)',8);
   h_8_ = diag(diag(e4*e4',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e4'*e4)/(n-k)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
beta4 = beta;
asyvar4 = asyvar;
asyvarc4 = asyvarc;

out((2*i)-1,7:8) = beta(1:2)';
out((2*i),7:8) = se_newey(1:2)';
out_rsq((2*i)-1,7) = rsq;

out((2*i)-1,9) = out((2*i)-1,3)/out((2*i)-1,7);
out((2*i)-1,10) = out((2*i)-1,4)/out((2*i)-1,8);



% Testing equality of sum of coefficients from regressions 2 and 4
summer_diff_24 = [-1; 0; 1; 0];
beta_diff_24 = summer_diff_24'*[beta2; beta4]

% OLS:
asyvar_ols_24 = [sum(e2'*e2)/(n-k)*inv(x'*x) sum(e2'*e4)/(n-k)*inv(x'*x); sum(e4'*e2)/(n-k)*inv(x'*x) sum(e4'*e4)/(n-k)*inv(x'*x)];
se_ols_beta_diff_24 = (summer_diff_24'*asyvar_ols_24*summer_diff_24)^(0.5)

% White and Newey-West:
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e2*e4'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e2*e4',1)',1);
   h_1_ = diag(diag(e2*e4',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e2*e4',2)',2);
   h_2_ = diag(diag(e2*e4',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e2*e4',3)',3);
   h_3_ = diag(diag(e2*e4',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e2*e4',4)',4);
   h_4_ = diag(diag(e2*e4',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e2*e4',5)',5);
   h_5_ = diag(diag(e2*e4',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e2*e4',6)',6);
   h_6_ = diag(diag(e2*e4',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e2*e4',7)',7);
   h_7_ = diag(diag(e2*e4',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e2*e4',8)',8);
   h_8_ = diag(diag(e2*e4',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvar24 = inv(x'*x)*P0*inv(x'*x);
asyvarc24 = inv(x'*x)*omega*inv(x'*x);

 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e4*e2'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e4*e2',1)',1);
   h_1_ = diag(diag(e4*e2',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e4*e2',2)',2);
   h_2_ = diag(diag(e4*e2',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e4*e2',3)',3);
   h_3_ = diag(diag(e4*e2',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e4*e2',4)',4);
   h_4_ = diag(diag(e4*e2',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e4*e2',5)',5);
   h_5_ = diag(diag(e4*e2',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e4*e2',6)',6);
   h_6_ = diag(diag(e4*e2',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e4*e2',7)',7);
   h_7_ = diag(diag(e4*e2',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e4*e2',8)',8);
   h_8_ = diag(diag(e4*e2',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvar42 = inv(x'*x)*P0*inv(x'*x);
asyvarc42 = inv(x'*x)*omega*inv(x'*x);

asyvar_24 = [asyvar2 asyvar24; asyvar42 asyvar4];
se_white_beta_diff_24 = (summer_diff_24'*asyvar_24*summer_diff_24)^(0.5)

asyvarc_24 = [asyvarc2 asyvarc24; asyvarc42 asyvarc4];
se_newey_beta_diff_24 = (summer_diff_24'*asyvarc_24*summer_diff_24)^(0.5)
test_newey_beta_diff_24 = beta_diff_24'*((summer_diff_24'*asyvarc_24*summer_diff_24)^(-1))*beta_diff_24
pvalue_newey_beta_diff_24 = 1-chi2cdf(test_newey_beta_diff_24,1)
pvalue_newey_beta_diff_24f = 1-fcdf(test_newey_beta_diff_24,1,n-k)

out((2*i)-1,11) = beta_diff_24;
out((2*i),11) = se_newey_beta_diff_24;

out((2*i)-1,12) = pvalue_newey_beta_diff_24f;

end;


out_row1 = [' $r_{t-8}^{Treas.(10yr)} - r_{t-8}^{Treas.(2yr)}$ ' anp bf num2str(out_rsq(15,7),'%3.2f') anp bf num2str(out_rsq(15,3),'%3.2f') anp bf num2str(out(15,7),'%3.2f') anp bf num2str(out(15,3),'%3.2f') anp num2str(out(15,12),'%3.2f') dslash anp anp anp leftp num2str(out(16,7),'%3.2f') rightp anp leftp num2str(out(16,3),'%3.2f') rightp anp dslash]
out_table = out_row1;
dlmwrite('table_LoSE_TERM.txt',out_table,'');
