clear all
clear all;
global x_t y_t t k;
OPTIONS = optimset('MaxFunEvals',600,'Maxiter',100,'TolFun',1e-12);

anp = ' & ';
dslash = ' \\ ';
hline = ' \hline ';
bf = ' \bf ';
leftp = '(';
rightp = ')';

data = dlmread('RGDP_RGDI_47.csv',',');
n = size(data,1);

SD_pct = (data(:,2)-data(:,3))./data(:,2); 

SD_lev = SD_pct(57:n)*100;
SD_lev_1 = SD_pct(56:n-1)*100;
SD_diff = [SD_pct(57:n)-SD_pct(56:n-1)]*100;
SD_diff_1 = [SD_pct(56:n-1)-SD_pct(55:n-2)]*100;

dataUR = dlmread('UR.csv',',');
t_u = size(dataUR,1);

UR_lev = dataUR(53:t_u,2);
UR_lev_1 = dataUR(52:t_u-1,2);
UR_diff = dataUR(53:t_u,2)-dataUR(52:t_u-1,2);
UR_diff_1 = dataUR(52:t_u-1,2)-dataUR(51:t_u-2,2);

t = size(SD_lev)

'Levels, 1984Q3 to 2006Q4'
out_levs84 = zeros(6,4);
y = SD_lev(95:t-11)
n = size(y,1);
control1 = ones(size(y));

x = [SD_lev_1(95:t-11) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']

out_levs84(1,:) = [beta' 0 rsq];
out_levs84(2,:) = [se_newey' 0 0];

x = [UR_lev(95:t-11) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']

out_levs84(3,:) = [beta' 0 rsq];
out_levs84(4,:) = [se_newey' 0 0];

x = [SD_lev_1(95:t-11) UR_lev(95:t-11) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']

out_levs84(5,:) = [beta' rsq];
out_levs84(6,:) = [se_newey' 0];




'Diffs, 1984Q3 to 2006Q4'
out_diff84= zeros(8,4);

y = SD_diff(95:t-11);
n = size(y,1);
control1 = ones(size(y));

x = [SD_diff_1(95:t-11) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']

out_diff84(1,:) = [beta' 0 rsq];
out_diff84(2,:) = [se_newey' 0 0];

x = [SD_diff_1(95:t-11) UR_diff(95:t-11) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']

out_diff84(3,:) = [beta' rsq];
out_diff84(4,:) = [se_newey' 0];

x = [SD_diff_1(95:t-11) UR_diff_1(95:t-11) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5)

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']

out_diff84(5,:) = [beta' rsq];
out_diff84(6,:) = [se_newey' 0];


out_row1_84 = [bf num2str(out_levs84(1,1),'%3.2f') anp anp bf num2str(out_levs84(1,2),'%3.2f') anp num2str(out_levs84(1,4),'%3.2f') dslash leftp num2str(out_levs84(2,1),'%3.2f') rightp anp anp leftp num2str(out_levs84(2,2),'%3.2f') rightp anp dslash]
out_row2_84 = [anp bf num2str(out_levs84(3,1),'%3.2f') anp bf num2str(out_levs84(3,2),'%3.2f') anp num2str(out_levs84(3,4),'%3.2f') dslash anp leftp num2str(out_levs84(4,1),'%3.2f') rightp anp leftp num2str(out_levs84(4,2),'%3.2f') rightp anp dslash]
out_row3_84 = [bf num2str(out_levs84(5,1),'%3.2f') anp bf num2str(out_levs84(5,2),'%3.2f') anp bf num2str(out_levs84(5,3),'%3.2f') anp num2str(out_levs84(5,4),'%3.2f') dslash leftp num2str(out_levs84(6,1),'%3.2f') rightp anp leftp num2str(out_levs84(6,2),'%3.2f') rightp anp leftp num2str(out_levs84(6,3),'%3.2f') rightp anp dslash]
out_table_84 = [out_row1_84 out_row2_84 out_row3_84]
dlmwrite('table_okuns_84.txt',out_table_84,'');

out_row1_84 = [bf num2str(out_diff84(1,1),'%3.2f') anp anp anp bf num2str(out_diff84(1,2),'%3.2f') anp num2str(out_diff84(1,4),'%3.2f') dslash leftp num2str(out_diff84(2,1),'%3.2f') rightp anp anp anp leftp num2str(out_diff84(2,2),'%3.2f') rightp anp dslash]
out_row2_84 = [bf num2str(out_diff84(3,1),'%3.2f') anp bf num2str(out_diff84(3,2),'%3.2f') anp anp bf num2str(out_diff84(3,3),'%3.2f') anp num2str(out_diff84(3,4),'%3.2f') dslash leftp num2str(out_diff84(4,1),'%3.2f') rightp anp leftp num2str(out_diff84(4,2),'%3.2f') rightp anp anp leftp num2str(out_diff84(4,3),'%3.2f') rightp anp dslash]
out_row3_84 = [bf num2str(out_diff84(5,1),'%3.2f') anp anp bf num2str(out_diff84(5,2),'%3.2f') anp bf num2str(out_diff84(5,3),'%3.2f') anp num2str(out_diff84(5,4),'%3.2f') dslash leftp num2str(out_diff84(6,1),'%3.2f') rightp anp anp leftp num2str(out_diff84(6,2),'%3.2f') rightp anp leftp num2str(out_diff84(6,3),'%3.2f') rightp anp dslash]
out_table_84 = [out_row1_84 out_row2_84 out_row3_84]
dlmwrite('table_okuns_d84.txt',out_table_84,'');

clear all
anp = ' & ';
dslash = ' \\ ';
hline = ' \hline ';
bf = ' \bf ';
leftp = '(';
rightp = ')'

% 1948 to 2009 data
data = dlmread('RGDP_RGDI_47.csv',',');
t = size(data,1);

SD_pct = (data(:,2)-data(:,3))./data(:,2); 
SD_lev = SD_pct(5:t)*100;
SD_lev_1 = SD_pct(4:t-1)*100;
SD_lev_2 = SD_pct(3:t-2)*100;

n = size(SD_lev,1);

dataUR = dlmread('UR.csv',',');
t_u = size(dataUR,1);
UR_lev = dataUR(:,2);

tstart=1
tend=146

'Levels, 1948Q1 to 1984Q2'
y = SD_lev(tstart:tend);
n = size(y,1);
control1 = ones(n,1);
x = [SD_lev_1(tstart:tend) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']

out_levs84(1,:) = [beta' 0 rsq];
out_levs84(2,:) = [se_newey' 0 0];

y = SD_lev(tstart:tend);
n = size(y,1);
control1 = ones(n,1);
x = [UR_lev(tstart:tend) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']

out_levs84(3,:) = [beta' 0 rsq];
out_levs84(4,:) = [se_newey' 0 0];

y = SD_lev(tstart:tend);
n = size(y,1);
control1 = ones(n,1);
x = [SD_lev_1(tstart:tend) UR_lev(tstart:tend) ones(n,1)]; 
kv = size(x,2);
beta = inv(x'*x)*x'*y;
pred = x*beta; 
e = y - x*beta; 
ss = y'*(eye(n) - control1*inv(control1'*control1)*control1')*y;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;

   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

%omega = P0 + ((2/3)*P1a) + ((2/3)*P1b) + ((1/3)*P2a) + ((1/3)*P2b);
%omega = P0 + ((4/5)*P1a) + ((4/5)*P1b) + ((3/5)*P2a) + ((3/5)*P2b) + ((2/5)*P3a) + ((2/5)*P3b) + ((1/5)*P4a) + ((1/5)*P4b);
omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']

out_levs84(5,:) = [beta' rsq];
out_levs84(6,:) = [se_newey' 0];

out_row1_84 = [bf num2str(out_levs84(1,1),'%3.2f') anp anp bf num2str(out_levs84(1,2),'%3.2f') anp num2str(out_levs84(1,4),'%3.2f') dslash leftp num2str(out_levs84(2,1),'%3.2f') rightp anp anp leftp num2str(out_levs84(2,2),'%3.2f') rightp anp dslash]
out_row2_84 = [anp bf num2str(out_levs84(3,1),'%3.2f') anp bf num2str(out_levs84(3,2),'%3.2f') anp num2str(out_levs84(3,4),'%3.2f') dslash anp leftp num2str(out_levs84(4,1),'%3.2f') rightp anp leftp num2str(out_levs84(4,2),'%3.2f') rightp anp dslash]
out_row3_84 = [bf num2str(out_levs84(5,1),'%3.2f') anp bf num2str(out_levs84(5,2),'%3.2f') anp bf num2str(out_levs84(5,3),'%3.2f') anp num2str(out_levs84(5,4),'%3.2f') dslash leftp num2str(out_levs84(6,1),'%3.2f') rightp anp leftp num2str(out_levs84(6,2),'%3.2f') rightp anp leftp num2str(out_levs84(6,3),'%3.2f') rightp anp dslash]
out_table_84 = [out_row1_84 out_row2_84 out_row3_84]
dlmwrite('table_okuns_48to84.txt',out_table_84,'');


