clear all
global y t;
OPTIONS = optimset('MaxFunEvals',600,'Maxiter',200,'TolFun',1e-12);

anp = ' & ';
dslash = ' \\ ';
hline = ' \hline ';
bf = ' \bf ';
leftp = '(';
rightp = ')';

dataRGDP = dlmread('vintage_growth_currqtrly.csv',',');
dataRGDPa = dlmread('vintage_growth_advcurrqtrly.csv',',');
dataRGDI = dlmread('vintage_realGDI_growth_currqtrly.csv',',');
dataRGDIa = dlmread('vintage_realGDI_predgrowth_latest.csv',',');

RGDP_adv = dataRGDPa(:,5);
RGDI_adv = dataRGDIa(:,8);
RGDP_fin = dataRGDP(:,7);
RGDI_fin = dataRGDI(:,5);
RGDP_latest = dataRGDP(:,8);
RGDI_latest = dataRGDI(:,6);

RGDI_rev = RGDI_latest - RGDI_adv;
diff_fin1 = RGDP_fin - RGDI_fin;

RGDP_rev = RGDP_latest - RGDP_adv;
diff_fin2 = RGDI_fin - RGDP_fin;
[dataRGDP(:,1)/100 dataRGDP(:,2)/1000 RGDP_fin RGDP_latest RGDP_rev diff_fin2 RGDI_fin RGDI_latest RGDI_rev diff_fin1]

tstart = 65;
tend = 116;

out = zeros(22,6)


'Revisions to RGDP on initial (RGDI - RGDP) 1994-2006, intercept'
y1 = RGDI_rev(tstart:tend,:);
n = size(y1,1);
control1 = ones(size(y1));
x = [RGDI_adv(tstart:tend,:)-RGDP_adv(tstart:tend,:) control1];
kv = size(x,2);
beta = inv(x'*x)*x'*y1;
pred = x*beta; 
e = y1 - x*beta; 
ss = y1'*(eye(n) - control1*inv(control1'*control1)*control1')*y1;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;
    
   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
plot(y1,x(:,1),'x')

out(21,:) = [beta' 0 0 0 rsq];
out(22,:) = [se_newey' 0 0 0 0];

'Revisions to RGDP on initial RGDP, RGDI 1994-2006, intercept'
x = [RGDP_adv(tstart:tend,:) RGDI_adv(tstart:tend,:) control1];
kv = size(x,2);
beta = inv(x'*x)*x'*y1;
pred = x*beta; 
e = y1 - x*beta; 
ss = y1'*(eye(n) - control1*inv(control1'*control1)*control1')*y1;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;
    
   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
plot(y1,x(:,1),'x')

out(23,:) = [beta' 0 0 rsq];
out(24,:) = [se_newey' 0 0 0];


RGDI_rev = RGDI_latest - RGDI_fin;
diff_fin1 = RGDP_fin - RGDI_fin;

RGDP_rev = RGDP_latest - RGDP_fin;
diff_fin2 = RGDI_fin - RGDP_fin;
[dataRGDP(:,1)/100 dataRGDP(:,2)/1000 RGDP_fin RGDP_latest RGDP_rev diff_fin2 RGDI_fin RGDI_latest RGDI_rev diff_fin1]

tstart = 65;
tend = 116;

clear y1 n control1 x
'Revisions to RGDP on initial (RGDI - RGDP) 1994-2006, intercept'
y1 = RGDI_rev(tstart:tend,:);
n = size(y1,1);
control1 = ones(size(y1));
x = [diff_fin2(tstart:tend,:) control1];
kv = size(x,2);
beta = inv(x'*x)*x'*y1;
pred = x*beta; 
e = y1 - x*beta; 
ss = y1'*(eye(n) - control1*inv(control1'*control1)*control1')*y1;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;
    
   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
plot(y1,x(:,1),'x')

out(3,:) = [beta' 0 0 0 rsq];
out(4,:) = [se_newey' 0 0 0 0];

clear y1 n control1 x
'Revisions to RGDP on initial RGDP, RGDI 1994-2006, intercept'
y1 = RGDI_rev(tstart:tend,:);
n = size(y1,1);
control1 = ones(size(y1));
x = [RGDP_fin(tstart:tend,:) RGDI_fin(tstart:tend,:) control1];
kv = size(x,2);
beta = inv(x'*x)*x'*y1;
pred = x*beta; 
e = y1 - x*beta; 
ss = y1'*(eye(n) - control1*inv(control1'*control1)*control1')*y1;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;
    
   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
plot(y1,x(:,1),'x')

out(5,:) = [beta' 0 0 rsq];
out(6,:) = [se_newey' 0 0 0];


% 1978 to 2008 data
clear dataRGDP dataRGDI RGDI_rev RGDP_rev
dataRGDP = dlmread('vintage_growth_1a.csv',',');
dataRGDI = dlmread('vintage_realGDI_growth_1a.csv',',');

RGDP_fin = dataRGDP(:,7);
RGDI_fin = dataRGDI(:,5);
RGDP_1a = dataRGDP(:,8);
RGDI_1a = dataRGDI(:,6);
RGDP_latest = dataRGDP(:,9);
RGDI_latest = dataRGDI(:,7);

[dataRGDP(:,1)/100 dataRGDP(:,2)/1000 RGDP_1a RGDP_latest RGDI_1a RGDI_1a RGDI_latest]

RGDI_rev = RGDI_latest - RGDI_1a;
diff_1a1 = RGDP_1a - RGDI_1a;

RGDP_rev = RGDP_latest - RGDP_1a;
diff_1a2 = RGDI_1a - RGDP_1a;
[dataRGDP(:,1)/100 dataRGDP(:,2)/1000 RGDP_1a RGDP_latest RGDP_rev diff_1a2 RGDI_1a RGDI_latest RGDI_rev diff_1a1]


clear y1 n control1 x
'Revisions to RGDP on initial (RGDI - RGDP) 1994-2006, intercept'
y1 = RGDI_rev(tstart:tend,:);
n = size(y1,1);
control1 = ones(size(y1));
x = [diff_1a2(tstart:tend,:) control1];
kv = size(x,2);
beta = inv(x'*x)*x'*y1;
pred = x*beta; 
e = y1 - x*beta; 
ss = y1'*(eye(n) - control1*inv(control1'*control1)*control1')*y1;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;
    
   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
plot(y1,x(:,1),'x')

out(9,:) = [beta' 0 0 0 rsq];
out(10,:) = [se_newey' 0 0 0 0];

clear y1 n control1 x
'Revisions to RGDP on initial RGDP, RGDI 1994-2006, intercept'
y1 = RGDI_rev(tstart:tend,:);
n = size(y1,1);
control1 = ones(size(y1));
x = [RGDP_1a(tstart:tend,:) RGDI_1a(tstart:tend,:) control1];
kv = size(x,2);
beta = inv(x'*x)*x'*y1;
pred = x*beta; 
e = y1 - x*beta; 
ss = y1'*(eye(n) - control1*inv(control1'*control1)*control1')*y1;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;
    
   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
plot(y1,x(:,1),'x')

out(11,:) = [beta' 0 0 rsq];
out(12,:) = [se_newey' 0 0 0];


clear RGDI_rev RGDP_rev RGDP_latest RGDI_latest RGDI_fin RGDP_fin
dataRGDIpre = dlmread('vintage_realGDI_growth_precurrqtrly.csv',',');

RGDP_pre = dataRGDIpre(:,7);
RGDI_pre = dataRGDIpre(:,4);
RGDP_fin = dataRGDIpre(:,8);
RGDI_fin = dataRGDIpre(:,5);
RGDP_latest = dataRGDIpre(:,9);
RGDI_latest = dataRGDIpre(:,6);

[dataRGDIpre(:,1)/100 dataRGDIpre(:,2)/1000 RGDP_pre RGDP_fin RGDP_latest RGDI_pre RGDI_fin RGDI_latest]

RGDI_rev = RGDI_latest - RGDI_pre;
diff_pre1 = RGDP_pre - RGDI_pre;

RGDP_rev = RGDP_latest - RGDP_pre;
diff_pre2 = RGDI_pre - RGDP_pre;
[dataRGDIpre(:,1)/100 dataRGDIpre(:,2)/1000 RGDP_pre RGDP_latest RGDP_rev diff_pre2 RGDI_pre RGDI_latest RGDI_rev diff_pre1]

tstart = 49;
tend = 87;

clear y1 n control1 x
'Revisions to RGDP on initial (RGDI - RGDP) 1994-2006, intercept'
y1 = RGDI_rev(tstart:tend,:);
n = size(y1,1);
control1 = ones(size(y1));
x = [diff_pre2(tstart:tend,:) control1];
kv = size(x,2);
beta = inv(x'*x)*x'*y1;
pred = x*beta; 
e = y1 - x*beta; 
ss = y1'*(eye(n) - control1*inv(control1'*control1)*control1')*y1;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;
    
   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
plot(y1,x(:,1),'x')

out(15,:) = [beta' 0 0 0 rsq];
out(16,:) = [se_newey' 0 0 0 0];

clear y1 n control1 x
'Revisions to RGDP on initial RGDP, RGDI 1994-2006, intercept'
y1 = RGDI_rev(tstart:tend,:);
n = size(y1,1);
control1 = ones(size(y1));
x = [RGDP_pre(tstart:tend,:) RGDI_pre(tstart:tend,:) control1];
kv = size(x,2);
beta = inv(x'*x)*x'*y1;
pred = x*beta; 
e = y1 - x*beta; 
ss = y1'*(eye(n) - control1*inv(control1'*control1)*control1')*y1;
rsq = 1 - ((e'*e/(n-kv))/(ss/(n-1)))
rmse = (e'*e/(n-kv))^(0.5);

% Computing Newey-West Standard Errors for beta
 % Calculating main diagonal of var-cov. matrix, correcting for cross correlation
   P0 = x'*diag(diag(e*e'))*x;
 % Calculating off-diagonals of var-cov. matrix
   h_1 = diag(diag(e*e',1)',1);
   h_1_ = diag(diag(e*e',-1)',-1);
   P1a = x'*h_1*x;
   P1b = x'*h_1_*x;

   h_2 = diag(diag(e*e',2)',2);
   h_2_ = diag(diag(e*e',-2)',-2);
   P2a = x'*h_2*x;
   P2b = x'*h_2_*x;

   h_3 = diag(diag(e*e',3)',3);
   h_3_ = diag(diag(e*e',-3)',-3);
   P3a = x'*h_3*x;
   P3b = x'*h_3_*x;

   h_4 = diag(diag(e*e',4)',4);
   h_4_ = diag(diag(e*e',-4)',-4);
   P4a = x'*h_4*x;
   P4b = x'*h_4_*x;

   h_5 = diag(diag(e*e',5)',5);
   h_5_ = diag(diag(e*e',-5)',-5);
   P5a = x'*h_5*x;
   P5b = x'*h_5_*x;

   h_6 = diag(diag(e*e',6)',6);
   h_6_ = diag(diag(e*e',-6)',-6);
   P6a = x'*h_6*x;
   P6b = x'*h_6_*x;

   h_7 = diag(diag(e*e',7)',7);
   h_7_ = diag(diag(e*e',-7)',-7);
   P7a = x'*h_7*x;
   P7b = x'*h_7_*x;
    
   h_8 = diag(diag(e*e',8)',8);
   h_8_ = diag(diag(e*e',-8)',-8);
   P8a = x'*h_8*x;
   P8b = x'*h_8_*x;

omega = P0 + ((8/9)*P1a) + ((8/9)*P1b) + ((7/9)*P2a) + ((7/9)*P2b) + ((6/9)*P3a) + ((6/9)*P3b) + ((5/9)*P4a) + ((5/9)*P4b) + ((4/9)*P5a) + ((4/9)*P5b) + ((3/9)*P6a) + ((3/9)*P6b) + ((2/9)*P7a) + ((2/9)*P7b) + ((1/9)*P8a) + ((1/9)*P8b);
asyvarc = inv(x'*x)*omega*inv(x'*x);
se_newey = diag(asyvarc).^(1/2);
asyvar = inv(x'*x)*P0*inv(x'*x);
se_white = diag(asyvar).^(1/2);
se_ols = (diag(sum(e'*e)/(n-kv)*inv(x'*x))).^(1/2);
[beta'; se_ols'; se_white'; se_newey']
plot(y1,x(:,1),'x')

out(17,:) = [beta' 0 0 rsq];
out(18,:) = [se_newey' 0 0 0];




out_row2 = ['$Y_t = \Delta GDP(E)_t$, revision'  anp bf num2str(out(3,1),'%3.2f') anp anp anp bf num2str(out(3,2),'%3.2f') anp num2str(out(3,6),'%3.2f') dslash ' latest - initial (3rd)' anp leftp num2str(out(4,1),'%3.2f') rightp anp anp anp leftp num2str(out(4,2),'%3.2f') rightp anp dslash]
out_row3 = [anp anp bf num2str(out(5,1),'%3.2f') anp bf num2str(out(5,2),'%3.2f') anp bf num2str(out(5,3),'%3.2f') anp num2str(out(5,6),'%3.2f') dslash anp anp leftp num2str(out(6,1),'%3.2f') rightp anp leftp num2str(out(6,2),'%3.2f') rightp anp leftp num2str(out(6,3),'%3.2f') rightp anp dslash]
out_row5 = ['$Y_t = \Delta GDP(E)_t$, revision'  anp bf num2str(out(9,1),'%3.2f') anp anp anp bf num2str(out(9,2),'%3.2f') anp num2str(out(9,6),'%3.2f') dslash ' latest - 1st annual revision' anp leftp num2str(out(10,1),'%3.2f') rightp anp anp anp leftp num2str(out(10,2),'%3.2f') rightp anp dslash]
out_row6 = [anp anp bf num2str(out(11,1),'%3.2f') anp bf num2str(out(11,2),'%3.2f') anp bf num2str(out(11,3),'%3.2f') anp num2str(out(11,6),'%3.2f') dslash anp anp leftp num2str(out(12,1),'%3.2f') rightp anp leftp num2str(out(12,2),'%3.2f') rightp anp leftp num2str(out(12,3),'%3.2f') rightp anp dslash]
out_row8 = ['$Y_t = \Delta GDP(E)_t$, revision'  anp bf num2str(out(15,1),'%3.2f') anp anp anp bf num2str(out(15,2),'%3.2f') anp num2str(out(15,6),'%3.2f') dslash ' latest - initial (2nd)' anp leftp num2str(out(16,1),'%3.2f') rightp anp anp anp leftp num2str(out(16,2),'%3.2f') rightp anp dslash]
out_row9 = [anp anp bf num2str(out(17,1),'%3.2f') anp bf num2str(out(17,2),'%3.2f') anp bf num2str(out(17,3),'%3.2f') anp num2str(out(17,6),'%3.2f') dslash anp anp leftp num2str(out(18,1),'%3.2f') rightp anp leftp num2str(out(18,2),'%3.2f') rightp anp leftp num2str(out(18,3),'%3.2f') rightp anp dslash]
out_row11 = ['$Y_t = \Delta GDP(E)_t$, revision'  anp bf num2str(out(21,1),'%3.2f') anp anp anp bf num2str(out(21,2),'%3.2f') anp num2str(out(21,6),'%3.2f') dslash ' latest - initial (advance)' anp leftp num2str(out(22,1),'%3.2f') rightp anp anp anp leftp num2str(out(22,2),'%3.2f') rightp anp dslash]
out_row12 = [anp anp bf num2str(out(23,1),'%3.2f') anp bf num2str(out(23,2),'%3.2f') anp bf num2str(out(23,3),'%3.2f') anp num2str(out(23,6),'%3.2f') dslash anp anp leftp num2str(out(24,1),'%3.2f') rightp anp leftp num2str(out(24,2),'%3.2f') rightp anp leftp num2str(out(24,3),'%3.2f') rightp anp dslash]
out_table = [out_row11 out_row12 hline out_row8 out_row9 hline out_row2 out_row3 hline out_row5 out_row6 hline]
dlmwrite('table_GDI_revisions_3.txt',out_table,'');


