global x e iper amat bmat abcdi ar idsh nrffshinput rffss;

rffss=-10.;  % istar

nsimobs=50000;
nt=nsimobs+100;
rffaddfac=0;
dropsh=0;

xxxx=1;
iperhold=2;

fid=fopen('C:\programdirectory\frbus04_zerosim_istar100_tay_early.dat','a');

clear options;

options(1)  = 0;          % Printout level.
options(2)  = .001;       % Accuracy required of parameter vector.
options(3)  = .0001  ;      % Accuracy required of function value.
options(14) = 1000;       % Maximum number of iterations

 
% 	FMINS('F',X0,OPTIONS) uses a vector of control parameters.
% 	If OPTIONS(1) is nonzero, intermediate steps in the solution are
% 	displayed; the default is OPTIONS(1) = 0.  OPTIONS(2) is the termination
% 	tolerance for x; the default is 1.e-4.  OPTIONS(3) is the termination
% 	tolerance for F(x); the default is 1.e-4.  OPTIONS(14) is the maximum
% 	number of steps; the default is OPTIONS(14) = 500.  The other components
% 	of OPTIONS are not used as input control parameters by FMIN.  For more
% 	information, see FOPTIONS.
 

if xxxx==1;
testacc=0.01;

xq0=cputime;

% rff is variable 3
idrff=4;

% rff_ is shock 3:nrffsh+2
idsh =60;

% nrffsh1: max # of constrained 1-qtr ma funds rates 
% nrffsh4: max # of constrained 4-qtr ma funds rates 
% nrffsh8: max # of constrained 8-qtr ma funds rates 
% nrffsh1: total maximum number of constraints  

nrffsh1=16;
nrffsh4=1;
nrffsh8=1;
nrffsh=nrffsh1+nrffsh4+nrffsh8;

neq=size(cofb,1);
nbeq=neq-nsh;
nlags=1;

% Compute VAR reduced form of solution
%      
amat=sparse(cofb(1:nbeq,1:nbeq));
bmat=inv(scof(1:neq,nlags*neq+1:(nlags+1)*neq));
bmat=bmat(1:nbeq,nbeq+1:neq);

nvars=size(amat,1);

iamat=eye(nvars);
amatto4=amat^4;
amat4=amat*(iamat+amat*(iamat+amat*(iamat+amat)));
amat8=amatto4*(iamat+amatto4);

% setup "K" matrix that gives delta(rfff)/del(rsh_)

kk=zeros(nrffsh,nrffsh);
abmat=bmat;
kk(1,:)=abmat(idrff,idsh:idsh+nrffsh-1);

for ij=2:nrffsh1,
   abmat=amat*abmat;   
   kk(ij,:)=abmat(idrff,idsh:idsh+nrffsh-1);
end

for ij=nrffsh1+1:nrffsh1+nrffsh4,
    abmat=amat4*abmat;
    kk(ij,:)=0.25*abmat(idrff,idsh:idsh+nrffsh-1);
end

for ij=nrffsh1+nrffsh4+1:nrffsh1+nrffsh4+nrffsh8,
    abmat=amat8*abmat;
    kk(ij,:)=0.125*abmat(idrff,idsh:idsh+nrffsh-1);
end

% create first-difference transformation matrix

abcd=eye(nrffsh);
for ijk=1:nrffsh-1,
  abcd(ijk,ijk+1)=-1;
end
abcdi=inv(abcd);

kk=kk*abcd;

% setup "AR" matrix that gives rffe(t+1, ... , xt+nrffsh-1)

ar=zeros(nrffsh,nvars);
ar(1,idrff)=1;
aamat=eye(nvars,nvars);
for ij=2:nrffsh1,
   aamat=amat*aamat;   
   ar(ij,:)=aamat(idrff,:);
end

for ij=nrffsh1+1:nrffsh1+nrffsh4,
   aamat=amat4*aamat;   
   ar(ij,:)=0.25*aamat(idrff,:);
end

for ij=nrffsh1+nrffsh4+1:nrffsh1+nrffsh4+nrffsh8,
   aamat=amat8*aamat;   
   ar(ij,:)=0.125*aamat(idrff,:);
end

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for isim=1:2,

    if isim==1,
        randn('seed',12345678); % used for 12000 period sims, ver 1
    elseif isim==2,
        randn('seed',22345678); % used for 12000 period sims, ver 2
    end


x=zeros(nt,nvars);

%if iperhold>2,
%   x(iperhold-1,:)=xsave;
%end

e=zeros(nt,nsh);

% stochastic simulation
e(2:nsimobs+1,1:nsh-maxrffsh-dropsh)=randn(nsimobs,nsh-dropsh-maxrffsh)*vcf;

meane=mean(e(2:nsimobs+1,1:nsh-maxrffsh-dropsh));

for izxc=2:nsimobs+1,
 e(izxc,1:nsh-maxrffsh-dropsh)= e(izxc,1:nsh-maxrffsh-dropsh)-meane;
end

e(2:nsimobs+1,nsh)=-rffaddfac*ones(nsimobs,1);


xq0=cputime;

nbinding=0;

for iper = iperhold:nsimobs+1,

   if rem(10*iper,nsimobs) ==0,
     disp(['Solving for period  ',num2str(iper)])      
   end

% reset rffsh states 
   x(iper-1,466:650)=zeros(1,185);
% simulate current period

   x1=x(iper-1,:)';
   ee=e(iper,:)';
   xc=amat*x1+bmat*ee;
   x(iper,:)=xc';

% compute leads (rtest = rff(t+ijk))

    rtest=ar*xc;

%   [iper,min(rtest),rffss]

   if min(rtest) > rffss - testacc,
%     disp(['No binding constraint for period  ',num2str(iper)])
   else,

      nbinding=nbinding+1;

% compute how much to shock the rffsh terms using "K"
% and zero-out all elements where rff is positive 
 
      rshvec=zeros(nrffsh,1);
      rshvecmax=0;
      for ijk=1:nrffsh,
         if rtest(ijk) < rffss - testacc,
            rshvec(ijk)=rtest(ijk)-rffss;
            rshvecmax=ijk;
         end
      end 

      kktemp=kk;
      uvectemp=ones(nrffsh,1);
      for ijk=1:nrffsh,
         if rshvec(ijk)==0,
             kktemp(:,ijk)=zeros(nrffsh,1);
             uvectemp(ijk)=0;
         end
      end
%      uvec=nnls(kktemp,-rshvec,0.001);
      uvec=lsqnonneg(kktemp,-rshvec);
      uvec=uvectemp.*uvec;
      uvec=abcd*uvec;

      nrffshmax=min(rshvecmax+2,nrffsh);
%      disp(['First try: number of solved leads = ',num2str(nrffshmax)])

% use nonlinear solver for nrffshmax terms

      uvec0=uvec(1:nrffshmax);
      nrffshinput=nrffshmax;
      uvec=lsqnonlin('frbuseqs1',uvec0);
      e(iper,idsh:idsh+nrffshmax-1)=uvec';

% resimulate current period

      x1=x(iper-1,:)';
      ee=e(iper,:)';
      xc=amat*x1+bmat*ee;
      x(iper,:)=xc';

% compute leads (rtest = rff(t+ijk))
 
      rtest=ar*xc;

      if nrffshmax < nrffsh,
         if min(rtest(1:nrffsh)) < rffss - testacc,

% use nonlinear solver for nrffshmax terms (second try)

            nrffshmax1=nrffshmax;
            nrffshmax=min(rshvecmax+4,nrffsh);
%            disp(['Second try: number of solved leads = ',num2str(nrffshmax)])
            uvec0=zeros(nrffshmax,1);
            uvec0(1:nrffshmax1)=uvec;
            nrffshinput=nrffshmax;
            uvec=lsqnonlin('frbuseqs1',uvec0);
            e(iper,idsh:idsh+nrffshmax-1)=uvec';
 
% resimulate current period

            x1=x(iper-1,:)';
            ee=e(iper,:)';
            xc=amat*x1+bmat*ee;
            x(iper,:)=xc';

% compute leads (rtest = rff(t+ijk))
 
            rtest=ar*xc;

            if nrffshmax<nrffsh,
               if min(rtest(1:nrffsh)) < rffss - testacc,
  
                 disp(['Need full solution for period ',num2str(iper)])

% use nonlinear solver for nrffsh terms if needed

                 uvec0=zeros(nrffsh,1);
                 uvec0(1:nrffshmax)=uvec;
                 nrffshinput=nrffsh;
                 uvec=lsqnonlin('frbuseqs1',uvec0);
                 e(iper,idsh:idsh+nrffsh-1)=uvec';

% resimulate current period

                 x1=x(iper-1,:)';
                 ee=e(iper,:)';
                 xc=amat*x1+bmat*ee;
                 x(iper,:)=xc';
              end
            end
         end
      end
      disp(['Binding constraint for period  ',num2str(iper)])
   end

% initialize and compute matrix of results
% output is in the following order:
% 1 output gap
% 2 inflation rate (annualized quarterly rate)
% 3 fed funds rate
% 4 unemployment rate
% 5 core inflation rate
% 6 mismeasured output gap (used in policy rule)
% 7-> policy add factors for ZLB   


   xkeep=zeros(1,6+nrffsh);
   xkeep(1,1:2)=x(iper,1:2);
   xkeep(1,3:6)=x(iper,4:7);
   xkeep(1,7:nrffsh+6)=e(iper,idsh:idsh+nrffsh-1);


   if nrffsh==1,
     fprintf(fid,'%16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f\n',xkeep');
   else,
     fprintf(fid,'%16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f %16.12f\n',xkeep');
   end 


if x(iper,1)<-30,
  x(iper,1:nvars)=zeros(1,nvars);
end

%  iper
%  [rtest-rffss]
end


disp(['Elapsed time to compute simulation    = ',num2str(cputime-xq0)])

nbindnow=0;
for ijk=2:nsimobs+1,
   bindtest=sum(e(ijk,idsh:idsh+nrffsh-1)');
   if bindtest > testacc,
     nbindnow=nbindnow+1;
   end
end

%disp(['Percent of time non-negativity constraint binds in expectation = ',num2str(nbinding/nsimobs)])
disp(['Percent of time non-negativity constraint binds in fact        = ',num2str(nbindnow/nsimobs)])


%sum(xkeep(:,1:5))/nsimobs
%stdxkeep=std(xkeep(:,1:5));
%stdxkeep
%(mean(xkeep(:,1:5).^3))./(stdxkeep(1:5).^3)
%(mean(xkeep(:,1:5).^4))./(stdxkeep(1:5).^4)

end
fclose(fid);