function discs=VMACCFWModel(x)
global sigma psi chi alpha beta delta omega yBar T gs kappa IfSave w k1

nCore=6;
discs=zeros(nCore*(T-1)-2,1);
yLoc=1;
hLoc=yLoc+T-1;
rLoc=hLoc+T-1;
qLoc=rLoc+T-1;
cLoc=qLoc+T-1;
kLoc=cLoc+T-1;
ys=[0;x(yLoc:yLoc+T-2)];
hs=[0;x(hLoc:hLoc+T-2)];
rs=[0;0;x(rLoc:rLoc+T-3)]; %  rs(2) is undefined
qs=[0;x(qLoc:qLoc+T-2)];
cs=[0;x(cLoc:cLoc+T-2)];
ks=[k1;x(kLoc:kLoc+T-3);k1]; % k is k* in periods 1 and T

%  Calculate discounter

ms=zeros(T,1);
for t=2:T-1;
    mucN=cs(t)^(-1/sigma)*(1-chi*(1-1/sigma)*hs(t)^(1+1/psi));
    mucF=cs(t+1)^(-1/sigma)*(1-chi*(1-1/sigma)*hs(t+1)^(1+1/psi));
    ms(t,1)=beta*mucF/mucN;
end

%  Markup ratio

mus=zeros(T,1);
for t=2:T
    mus(t)=(ys(t)/yBar)^(-omega);
end

%  Discrepancies except Euler equation and capital demand

iDisc=1;

for t=2:T
    % Production
    discs(iDisc)=ys(t)-hs(t)^alpha*ks(t-1)^(1-alpha);
    iDisc=iDisc+1;
    % Labor demand
    discs(iDisc)=hs(t)-alpha*ys(t)/(mus(t)*w);
    iDisc=iDisc+1;
    %  Tobin's q
    discs(iDisc)=kappa*(ks(t)-ks(t-1))/ks(t-1) -(qs(t)-1);
    iDisc=iDisc+1;
    % Law of motion of capital
    discs(iDisc)=ks(t)+kappa*(ks(t)-ks(t-1))^2/(2*ks(t-1))-(1-delta)*ks(t-1)-ys(t)+cs(t)+gs(t);
    iDisc=iDisc+1;
end

% Capital demand

for t=3:T
    bs(t,1)=qs(t-1)*(rs(t)+delta)-(qs(t)-qs(t-1));
    discs(iDisc)=ks(t-1)-(1-alpha)*ys(t)/(mus(t)*bs(t));
    iDisc=iDisc+1;
end

%  Euler 

for t=2:T-1
    discs(iDisc)=(1+rs(t+1))*ms(t)-1;
    iDisc=iDisc+1;
end

if IfSave==0
    return
end
ws(1:T,1)=w;
AllVars=[ys,hs,rs,ws,qs,cs,ks,ms,bs,mus,gs];
save VMACCFWModel AllVars
