clc 
clear all

global sigma psi chi alpha gamma omega g

MaxFunEvals=5000;
MaxIter=5;
options=optimset('Display','iter','MaxFunEvals',MaxFunEvals,'MaxIter',MaxIter,'Algorithm','levenberg-marquardt','TolFun',.00000000001,'TolX',.000000001);
%  Row of params = [sigma, psi, chi, omega]
params=[0.5,0.5,0,0;
        0.5,0.5,0,0.5;
        0.5,1.9,0,0.5;
        0.4,1.54,0.334,0.5];
sz=size(params);
Ncase=sz(1);
Nparams=sz(2);
NVars=11;
Vars=[];
Stats=[];
alpha=0.7;
g=0.2;
Results=[];

for icase=1:Ncase
    sigma=params(icase,1);
    psi=params(icase,2);
    chi=params(icase,3);
    omega=params(icase,4);
    
    %  Find gamma with g=.2
    
    x=1;
    res=StaticModel1(x);
    MaxFunEvals=50000;
    MaxIter=500;
    options=optimset('Display','iter','MaxFunEvals',MaxFunEvals,'MaxIter',MaxIter,'Algorithm','levenberg-marquardt','TolFun',.00000000001,'TolX',.000000001);
    gamma=fsolve(@StaticModel1,x,options);
    
    %  Perturb g
    
    x(1)=1-g;  %  c
    x(2)=1;    %  h
    g=g+0.01;
    res=StaticModel(x);
    xN=fsolve(@StaticModel,x,options)
    my=100*(xN(2)^alpha-x(2)^alpha);
    mc=my-1;
    Results=[Results;sigma,psi,chi,omega,my,mc];
end
xlswrite('Static.xlsx',Results,'From Matlab');
 

