dm 'clear log';
dm 'clear output';

libname scf 'C:\Documents and Settings\g1jxb01\My Documents\Fed SCF';

*Single age stats;
*The outer macro repeats the code for the given years;

%macro  year(year);

data work.temp;
	*Creates 3 age groups that include only people of those exact ages;
	length agegroup $7;
	set scf.scfp&year;
	if age = 25 then agegroup = "25";
	if age = 50 then agegroup = "50";
	if age = 70 then agegroup = "70";
	if missing(agegroup) ~= 1;
	HEQLOAN = X1005;
run;

proc sort data=work.temp;
	by agegroup;
run;

%macro stats3(variable);
%macro dem(demvar);
proc univariate data=work.temp vardef=WGT;
	var &demvar;
	where &variable>0; *nonzero values;
	weight WGT;
	by agegroup;
	output out=work.&demvar._&variable. MEAN=Mean MEDIAN=Median N=FREQ STD=STD MAX=MAX MIN=MIN
										P1=P1 P5=P5 P10=P10 Q1=Q1 Q3=Q3 P90=P90 P95=P95 P99=P99
										pctlpts=40 60 pctlpre=pct;	*creates several datasets that contain mean, median, frequency and standard deviation conditional on nonzero values;
run;

proc univariate data=work.temp vardef=WGT;
	var &demvar;
	weight WGT; 
	by agegroup;
	output out=work.&demvar._&variable._all MEAN=Mean_all MEDIAN=Median_all N=FREQ_all STD=STD_all 
							MAX=MAX_all MIN=MIN_all P1=P1_all P5=P5_all P10=P10_all Q1=Q1_all 
							Q3=Q3_all P90=P90_all P95=P95_all P99=P99_all
							pctlpts=40 60 pctlpre=pctall;
	*creates several datasets that contain the mean, median, frequency, and standard deviation for all values;
run;

%mend dem;

%dem(age)
%dem(educ)
%dem(income)
%dem(networth)

data work.&variable.;
	set work.age_&variable.(IN=age) work.educ_&variable.(IN=educ) work.income_&variable.(IN=income)
	work.networth_&variable.(IN=networth); *reads in these 4 files;
	if networth then demographic = 'Net worth';	*if networth contributed to the file, name demographic 'networth';
	if age then demographic = 'Age';
	if educ then demographic = 'Education';
	if income then demographic = 'Income';
run;

data work.&variable._all;
	set work.age_&variable._all(IN=age) work.educ_&variable._all(IN=educ) work.income_&variable._all(IN=income)
	work.networth_&variable._all(IN=networth);
	if networth then demographic = 'Net worth';
	if age then demographic = 'Age';
	if educ then demographic = 'Education';
	if income then demographic = 'Income';
run;

%mend stats3;

%stats3(NH_MORT)
%stats3(OTHLOC)
%stats3(RESDBT)
%stats3(CCBAL)
%stats3(VEH_INST)
%stats3(EDN_INST)
%stats3(OTH_INST)
%stats3(ODEBT)
%stats3(HEQLOAN)
%stats3(HELOC)


data work.stats3;
	length variable $35;
	retain variable demographic agegroup FREQ Mean Median STD;
	set work.NH_MORT(IN=InNH_MORT) work.OTHLOC(In=InOTHLOC) work.RESDBT(In=InRESDBT) work.CCBAL(In=InCCBAL) 
	work.VEH_INST(In=InVEH_INST) work.EDN_INST(In=InEDN_INST) work.OTH_INST(In=InOTH_INST) 
	work.ODEBT(In=InODEBT) work.HEQLOAN(In=InHEQLOAN) work.HELOC(In=InHELOC);
	if InNH_MORT then variable = 'Housing debt';
	if InRESDBT then variable = 'Debt for other residential property';
	if InOTHLOC then variable = 'Other lines of credit';
	if InCCBAL then variable = 'Credit card balance';
	if InVEH_INST then variable = 'Vehicle loans';
	if InEDN_INST then variable = 'Education loans';
	if InOTH_INST then variable = 'Other installment loans';
	if InODEBT then variable = 'Other debt';
	if InHEQLOAN then variable = 'Home Equity Loan';
	if InHELOC then variable = 'Home Equity Line of Credit';
run;

data work.stats3_all;
	length variable $35;
	retain variable demographic agegroup FREQ Mean Median STD;
	set work.NH_MORT_all(IN=InNH_MORT) work.OTHLOC_all(In=InOTHLOC) work.RESDBT_all(In=InRESDBT) 
	work.CCBAL_all(In=InCCBAL) work.VEH_INST_all(In=InVEH_INST) work.EDN_INST_all(In=InEDN_INST) 
	work.OTH_INST_all(In=InOTH_INST) work.ODEBT_all(In=InODEBT) work.HEQLOAN_all(In=InHEQLOAN)
	work.HELOC_all(In=InHELOC);
	if InNH_MORT then variable = 'Housing debt';
	if InRESDBT then variable = 'Debt for other residential property';
	if InOTHLOC then variable = 'Other lines of credit';
	if InCCBAL then variable = 'Credit card balance';
	if InVEH_INST then variable = 'Vehicle loans';
	if InEDN_INST then variable = 'Education loans';
	if InOTH_INST then variable = 'Other installment loans';
	if InODEBT then variable = 'Other debt';
	if InHEQLOAN then variable = 'Home Equity Loan';
	if InHELOC then variable = 'Home Equity Line of Credit';
run;

proc sort data=work.stats3;
	by variable demographic agegroup;
run;

proc sort data=work.stats3_all;
	by variable demographic agegroup;
run;

data work.medratio;
	merge work.stats3 work.stats3_all;
	by variable demographic agegroup;
	medratio = Median/Median_all;
run;

proc print data=work.medratio;
run;

proc export data=work.medratio
			outfile = "C:\Documents and Settings\G1jxb01\My Documents\Fed SCF\medratios_outliers_&year..xls"
			dbms=excel replace;
			sheet = "medratio_&year._1";
run;

*Age range stats;

data work.temp;
	length agegroup $7;
	set scf.scfp&year;
	if age ge 25 and age le 35 then agegroup = "[25,35]";
	if age ge 45 and age le 55 then agegroup = "[45,55]";
	if age ge 65 and age le 75 then agegroup = "[65,75]";
	if missing(agegroup) ~= 1;
	HEQLOAN = X1005;
run;

proc sort data=work.temp;
	by agegroup;
run;

%macro stats3(variable);
%macro dem(demvar);
proc univariate data=work.temp vardef=WGT;
	var &demvar;
	where &variable>0;
	weight WGT; 
	by agegroup;
	output out=work.&demvar._&variable. MEAN=Mean MEDIAN=Median N=FREQ STD=STD MAX=MAX MIN=MIN
										P1=P1 P5=P5 P10=P10 Q1=Q1 Q3=Q3 P90=P90 P95=P95 P99=P99
										pctlpts=40 60 pctlpre=pct;
run;

proc univariate data=work.temp vardef=WGT;
	var &demvar;
	weight WGT; 
	by agegroup;
	output out=work.&demvar._&variable._all MEAN=Mean_all MEDIAN=Median_all N=FREQ_all STD=STD_all
							MAX=MAX_all MIN=MIN_all P1=P1_all P5=P5_all P10=P10_all Q1=Q1_all 
							Q3=Q3_all P90=P90_all P95=P95_all P99=P99_all
							pctlpts=40 60 pctlpre=pctall;
run;

%mend dem;

%dem(age)
%dem(educ)
%dem(income)
%dem(networth)

data work.&variable.;
	set work.age_&variable.(IN=age) work.educ_&variable.(IN=educ)work.income_&variable.(IN=income)
	work.networth_&variable.(IN=networth);
	if networth then demographic = 'Net worth';
	if age then demographic = 'Age';
	if educ then demographic = 'Education';
	if income then demographic = 'Income';
run;

data work.&variable._all;
	set work.age_&variable._all(IN=age) work.educ_&variable._all(IN=educ) work.income_&variable._all(IN=income)
	work.networth_&variable._all(IN=networth);
	if networth then demographic = 'Net worth';
	if age then demographic = 'Age';
	if educ then demographic = 'Education';
	if income then demographic = 'Income';
run;

%mend stats3;

%stats3(NH_MORT)
%stats3(OTHLOC)
%stats3(RESDBT)
%stats3(CCBAL)
%stats3(VEH_INST)
%stats3(EDN_INST)
%stats3(OTH_INST)
%stats3(ODEBT)
%stats3(HEQLOAN)
%stats3(HELOC)


data work.stats3;
	length variable $35;
	retain variable demographic agegroup FREQ Mean Median STD;
	set work.NH_MORT(IN=InNH_MORT) work.OTHLOC(In=InOTHLOC) work.RESDBT(In=InRESDBT) work.CCBAL(In=InCCBAL) 
	work.VEH_INST(In=InVEH_INST) work.EDN_INST(In=InEDN_INST) work.OTH_INST(In=InOTH_INST) 
	work.ODEBT(In=InODEBT) work.HEQLOAN(In=InHEQLOAN) work.HELOC(In=InHELOC);
	if InNH_MORT then variable = 'Housing debt';
	if InRESDBT then variable = 'Debt for other residential property';
	if InOTHLOC then variable = 'Other lines of credit';
	if InCCBAL then variable = 'Credit card balance';
	if InVEH_INST then variable = 'Vehicle loans';
	if InEDN_INST then variable = 'Education loans';
	if InOTH_INST then variable = 'Other installment loans';
	if InODEBT then variable = 'Other debt';
	if InHEQLOAN then variable = 'Home Equity Loan';
	if InHELOC then variable = 'Home Equity Line of Credit';
run;

data work.stats3_all;
	length variable $35;
	retain variable demographic agegroup FREQ Mean Median STD;
	set work.NH_MORT_all(IN=InNH_MORT) work.OTHLOC_all(In=InOTHLOC) work.RESDBT_all(In=InRESDBT) 
	work.CCBAL_all(In=InCCBAL) work.VEH_INST_all(In=InVEH_INST) work.EDN_INST_all(In=InEDN_INST) 
	work.OTH_INST_all(In=InOTH_INST) work.ODEBT_all(In=InODEBT) work.HEQLOAN_all(In=InHEQLOAN)
	work.HELOC_all(In=InHELOC);
	if InNH_MORT then variable = 'Housing debt';
	if InRESDBT then variable = 'Debt for other residential property';
	if InOTHLOC then variable = 'Other lines of credit';
	if InCCBAL then variable = 'Credit card balance';
	if InVEH_INST then variable = 'Vehicle loans';
	if InEDN_INST then variable = 'Education loans';
	if InOTH_INST then variable = 'Other installment loans';
	if InODEBT then variable = 'Other debt';
	if InHEQLOAN then variable = 'Home Equity Loan';
	if InHELOC then variable = 'Home Equity Line of Credit';
run;

proc sort data=work.stats3;
	by variable demographic agegroup;
run;

proc sort data=work.stats3_all;
	by variable demographic agegroup;
run;

data work.medratio;
	merge work.stats3 work.stats3_all;
	by variable demographic agegroup;
	medratio = Median/Median_all;
run;

proc print data=work.medratio;
run;

proc export data=work.medratio
			outfile = "C:\Documents and Settings\G1jxb01\My Documents\Fed SCF\medratios_outliers_&year..xls"
			dbms=excel replace;
			sheet = "medratio_&year._2";
run;

%mend year;

%year(1989)	
%year(1998)	
%year(2001)	
%year(2004)	
