
*****************************************************************************************************************************************
*                                                         Table 1                                                                       *
*****************************************************************************************************************************************

*********
*Panel A*
*********

use "D:\Brookings_Table1_PanelA.dta", clear

collapse (mean) ChiefExec GovLargest GovMeanThree corru l1corru logypp gdp_cpc_p, by(ccode year)

gen lowincome=0
gen middleincome=0
gen highincome=0

replace lowincome=1    if gdp_cpc_p<2215 
replace middleincome=1 if gdp_cpc_p>2215 & gdp_cpc_p<5726 
replace highincome=1   if gdp_cpc_p>5726 & gdp_cpc_p<.

gen     incomecat=1 if lowincome==1
replace incomecat=2 if middleincome==1
replace incomecat=3 if highincome==1

tab GovLargest if year==1992 & lowincome==1 
tab GovLargest if year==1992 & middleincome==1 
tab GovLargest if year==1992 & highincome==1 



*********
*Panel B*
*********

use "D:\Brookings_Table1_PanelB.dta", clear

summ statelow       if ny_gdp_pcap_kd<801.20 & ny_gdp_pcap_kd<.
summ statemiddle    if ny_gdp_pcap_kd<801.20 & ny_gdp_pcap_kd<.
summ statehigh      if ny_gdp_pcap_kd<801.20 & ny_gdp_pcap_kd<.

summ statelow       if ny_gdp_pcap_kd>801.20 & ny_gdp_pcap_kd<4038.97
summ statemiddle    if ny_gdp_pcap_kd>801.20 & ny_gdp_pcap_kd<4038.97
summ statehigh      if ny_gdp_pcap_kd>801.20 & ny_gdp_pcap_kd<4038.97

summ statelow       if ny_gdp_pcap_kd>4038.97 & ny_gdp_pcap_kd<.
summ statemiddle    if ny_gdp_pcap_kd>4038.97 & ny_gdp_pcap_kd<.
summ statehigh      if ny_gdp_pcap_kd>4038.97 & ny_gdp_pcap_kd<.



*********
*Panel C*
*********

use "D:\Brookings_Table1_PanelC.dta", clear

summ procedures if gdppc99<1200 & gdppc99<.
summ procedures if gdppc99>1200 & gdppc99<5060
summ procedures if gdppc99>5060 & gdppc99<.



*****************************************************************************************************************************************
*                                                         Table 2                                                                       *
*****************************************************************************************************************************************

use "D:\Brookings_Table2_Revision.dta", clear

xtset numccode Election

**********
*Column 1*
**********

xtabond GovLargestSeats  l.corru  l.gdp_cpc_p if corru<.  & gdp_cpc_p<., twostep lags(1) r

estat abond


**********
*Column 2*
**********

xtabond corru  l.corru  l.GovLargestSeats l.gdp_cpc_p if corru<.  & gdp_cpc_p<. & GovLargestSeats<., twostep lags(1) r

estat abond

*****************************************************************************************************************************************
*                                                         Table 3                                                                       *                                                
*****************************************************************************************************************************************

use "D:\Brookings_Table3.dta", clear

**********
*Column 1*
**********

dprobit right most_corr all_corr mid_income high_income d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65 d66 d67 d68 d69 d70 d71 d72 d73 d74 d75 d76 d77 d78 d79 d80 d81 d82 d83, r

**********
*Column 2*
**********

dprobit private_own most_corr all_corr mid_income high_income d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65 d66 d67 d68 d69 d70 d71 d72 d73 d74 d75 d76 d77 d78 d79 d80 d81 d82 d83, r

***************
*Column 3 - US*
***************

dprobit right       most_corr all_corr mid_income high_income if s003==840, r

***************
*Column 4 - US*
***************

dprobit private_own most_corr all_corr mid_income high_income if s003==840, r







*****************************************************************************************************************************************
*                                                         Table 4                                                                       *                                                
*****************************************************************************************************************************************

use "D:\Brookings_Table3.dta", clear

** Low Regulation Countries**

dprobit right most_corr all_corr mid_income high_income d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65 d66 d67 d68 d69 d70 d71 d72 d73 d74 d75 d76 d77 d78 d79 d80 d81 d82 d83 if procedures<9, r

** High Regulation Countries**

dprobit right most_corr all_corr mid_income high_income d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65 d66 d67 d68 d69 d70 d71 d72 d73 d74 d75 d76 d77 d78 d79 d80 d81 d82 d83 if procedures>12, r




*****************************************************************************************************************************************
*                                                         Table 5                                                                       *
*****************************************************************************************************************************************

** Note: D:\Brookings_Gallup.dta is a sample name for the data from Gallup and is not provided.**
** To get this data, you need to apply to Gallup directly.**
use "D:\Brookings_Gallup.dta", clear

sort country

save, replace

use "D:\Shleifer_Entry", clear

merge country using "D:\Brookings_Gallup.dta"


**********************
*Generating Variables*
**********************

replace procedures=procedures/10
replace time_99=time_99/100

gen anger=0
replace anger=1 if wp74==1
replace anger=. if wp74>2

gen     BusCorr=1 if wp145==1
replace BusCorr=0 if wp145==2
gen     GovCorr=1 if wp146==1
replace GovCorr=0 if wp146==2

replace Pro_BusCorr=procedure*BusCorr
replace Pro_GovCorr=procedure*GovCorr

gen time_BusCorr=time_99*BusCorr
gen time_GovCorr=time_99*GovCorr

***************

**********
*Column 1*
**********

xi: dprobit anger GovCorr BusCorr procedures  Pro_GovCorr  Pro_BusCorr  income i.wp5, cluster(wp5)

**********
*Column 2*
**********

xi: dprobit anger GovCorr BusCorr time_99    time_GovCorr time_BusCorr income i.wp5, cluster(wp5)


*****************************************************************************************************************************************
*                                                              END                                                                      *
*****************************************************************************************************************************************

