%This plot produces the appendix Figure A2

addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\apr_09');
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds');
%Load the output from nominal_returns_US
load inflation_bonds\apr_09\returnsUS10Y.mat
Y=3652;
%Do not need to care about dates for other series at this point
dates=dates_yields;
issue=issue_intended;
[splice, days, bond, yieldsY, bound]=splice_maturity(dates,yields, issue, mat,Y);
y=10;
   a=or((splice<0.01), splice>y);
    a=(a==0); %Vector of nonoutlier dates
splicenew=splice(a,:);
yieldsnew=yieldsY(a,:);
datesnew=days(a,:);
bondnew=bond(a);

plot(datesnew, splicenew,'Color','k');
Nbonds=size(yieldsnew, 2);%Number of bonds

plotdates=zeros(Nbonds,1);
plotdates_first=plotdates;
for k=1:Nbonds
    %If bond occurs in splice
    if sum(bondnew==k)>0
    d=find(bondnew==k);
    first=min(d);
    d=max(d);
        
    splice_d=zeros(size(datesnew,1),1);
    for t=1:size(datesnew,1)
        if t <=d
        splice_d(t)=1;
        end
    end
    %plot old bond for 120 days after splice jumps to new bond
    plotdates(k)=datesnew(min(max(find(splice_d==1))+360, size(datesnew,1)));
    plotdates_first(k)=datesnew(first);
    end
end

hold on;
%plot bond k in relevant range
matrix_plot=[];

for k=1:Nbonds
    daysk=0;
    yieldsk=0;
    if sum(bondnew==k)>0
    %remove outtlier dates
    daysk=datesnew;
    yieldsk=yieldsnew(:,k);
    restrict=and(and(daysk>=plotdates_first(k),daysk<=plotdates(k)), yieldsk~=0);
 yieldsk=yieldsk(restrict);
 daysk=daysk(restrict);
  plot(daysk, yieldsk, 'Color', 'r');
    end
    if daysk~=0
    tk=max(size(daysk));
    daysE=vertcat(daysk, ones(max(size(yields))-max(size(daysk)),1)*daysk(tk));
    yieldsE=vertcat(yieldsk, ones(max(size(yields))-max(size(daysk)),1)*yieldsk(tk));
    matrix_plot=[matrix_plot m2xdate(daysE) yieldsE];
    end
end

plot(datesnew, splicenew,'Color','k');
axis tight;
    hold off;
    matrix_splice=[m2xdate(datesnew) splicenew];
    matrix_vert=max(m2xdate(plotdates_first),0);
for k=1:Nbonds
if sum(bondnew==k)>0
line([plotdates_first(k) plotdates_first(k)], [0 max(splice)],'color','b', 'Linestyle','--');
end
end
datetick('x', 11);

title('US-10 Year Splice');

xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',matrix_vert, 5,'A2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',matrix_vert, 5,'B2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',matrix_splice, 5,'C2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',matrix_plot, 5,'E2');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Same for UK
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Load the output from nominal_returns_UK
load inflation_bonds\apr_09\returnsUK10Y.mat
Y=3652;
%Do not need to care about dates for other series at this point
dates=dates_yields;
[splice, days, bond, yieldsY, bound]=splice_maturity(dates,yields, issue, mat,Y);
y=10;
   a=or((splice<0.01), splice>y);
    a=(a==0); %Vector of nonoutlier dates
splicenew=splice(a,:);
yieldsnew=yieldsY(a,:);
datesnew=days(a,:);
bondnew=bond(a);

plot(datesnew, splicenew,'Color','k');
Nbonds=size(yieldsnew, 2);%Number of bonds

plotdates=zeros(Nbonds,1);
plotdates_first=plotdates;
for k=1:Nbonds
    %If bond occurs in splice
    if sum(bondnew==k)>0
    d=find(bondnew==k);
    first=min(d);
    d=max(d);
        
    splice_d=zeros(size(datesnew,1),1);
    for t=1:size(datesnew,1)
        if t <=d
        splice_d(t)=1;
        end
    end
    %plot old bond for 120 days after splice jumps to new bond
    plotdates(k)=datesnew(min(max(find(splice_d==1))+360, size(datesnew,1)));
    plotdates_first(k)=datesnew(first);
    end
end

hold on;
%plot bond k in relevant range
matrix_plot=[];

for k=1:Nbonds
    daysk=0;
    yieldsk=0;
    if sum(bondnew==k)>0
    %remove outtlier dates
    daysk=datesnew;
    yieldsk=yieldsnew(:,k);
    restrict=and(and(daysk>=plotdates_first(k),daysk<=plotdates(k)), yieldsk~=0);
 yieldsk=yieldsk(restrict);
 daysk=daysk(restrict);
  plot(daysk, yieldsk, 'Color', 'r');
    end
    if daysk~=0
    tk=max(size(daysk));
    daysE=vertcat(daysk, ones(max(size(yields))-max(size(daysk)),1)*daysk(tk));
    yieldsE=vertcat(yieldsk, ones(max(size(yields))-max(size(daysk)),1)*yieldsk(tk));
    matrix_plot=[matrix_plot m2xdate(daysE) yieldsE];
    end
end

plot(datesnew, splicenew,'Color','k');
axis tight;
    hold off;
    matrix_splice=[m2xdate(datesnew) splicenew];
    matrix_vert=max(m2xdate(plotdates_first),0);
for k=1:Nbonds
if sum(bondnew==k)>0
line([plotdates_first(k) plotdates_first(k)], [0 max(splice)],'color','b', 'Linestyle','--');
end
end
datetick('x', 11);

title('UK-10 Year Splice');

xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',matrix_vert, 6,'A2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',matrix_vert, 6,'B2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',matrix_splice, 6,'C2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',matrix_plot, 6,'E2');