%This plot produces the appendix Figure A2
%11/6/2009 cpflueger@hbs.edu
%Download issue date and maturity date from Excel file, yields_data, make
%sure to convert dates into number format
%issue=data(1,:);
%mat=data(2,:);
%maturity=mat-issue;

%Set variables to country variables
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\apr_09');
load inflation_bonds\apr_09\returnsUS10Y.mat
issue=issue_intended;
maturity=(mat-issue)/365.2;

K=max(size(issue));
a=(mat-365.2*10).*(maturity>=9.5);
mat_diag=horzcat(m2xdate(issue), m2xdate(mat), maturity,zeros(K,1));
mat_horz=horzcat(m2xdate(a), m2xdate(a), zeros(K,1), (max(maturity)+10)*ones(K,1)+(1:1:K)');

xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',mat_diag, 3,'A2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',mat_horz, 3,'E2');
%%%%Same for UK
load inflation_bonds\apr_09\returnsUK10Y.mat
maturity=(mat-issue)/365.2;

K=max(size(issue));
a=(mat-365.2*10).*(maturity>=10);
mat_diag_UK=horzcat(m2xdate(issue), m2xdate(mat), maturity,zeros(K,1));
mat_horz_UK=horzcat(m2xdate(a), m2xdate(a), zeros(K,1), (max(maturity)+10)*ones(K,1)+(1:1:K)');

xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',mat_diag_UK, 4,'A2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_Appendix_may3.xls',mat_horz_UK, 4,'E2');
%%%%