function [V] = HACnw(x,u,m);

% Newey-West HAC covariance matrix as in West and Newey, NBER TWP#144, p.4.
%
% x is the (Txk) matrix of observations and u are ols residuals.
% m is the window width.

k = cols(x);
T = rows(x);
u = u * ones(1,k);
z = x.*u;							% z is a (T-by-k) matrix, where                             
										% each column of z is z(t)=x(t)*u(t), where z(t) is (k*1)
                                
% -- Calculate the Covariances -- %
S=z'*z;   							% generating omega_0.
for j=1:m
	zz= z(j+1:T,:)'*z(1:T-j,:);  			
   S=S+(1-(j/(m+1)))*(zz+zz');
end;
S = S/T;
Q = (x'*x/T);
invQ = inv(Q);
V = invQ*S*invQ/T;