clear;
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\distrib')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\regress')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\util')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation')

hor=[1 2 5 10 20];    % bond maturities (in years) %
%Choose dates to estimate VAR over subsample
startyear=1973;  %Year when data starts to estimate VAR
endyear=2008;
% ====================================================================
%                         Load data
%  ==================================================================== %
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation')
inflation_data=xlsread('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\cpi_wrds.xls');
cpi=inflation_data(:,2);
%Need to convert CRSP dates into Matlab dates
cpi_dates=inflation_data(:,1);
year_m=floor(cpi_dates/10000);
cpi_dates=cpi_dates-10000*year_m;
month_m=floor(cpi_dates/100);
cpi_dates=cpi_dates-100*month_m;
day_m=cpi_dates;
cpi_dates=[year_m month_m day_m];
cpi_dates=datenum(cpi_dates);
%Get riskfree rate from CRSP starting in 19800130 until December 2007- need to truncate
%inflation series appropriately
riskfree=xlsread('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\riskfree_rate_US_mar_09.xls');
rfr=riskfree;

%Crop at end date of analysis
a=(rfr(:,1)<=(endyear+1)*10000);
rfr=rfr(a,:);
%Choose start date of analysis
startrow=min(find(rfr(:,1)>=startyear*10000));

% ====================================================================
%                          Variables
%   ==================================================================== %

dt_m=rfr(startrow:max(size(rfr)),1);
dt_CRSP=dt_m;
%Convert dates from CRSP into MATLAB format
%Convert CRSP dates into MATLAB format
year_m=floor(dt_m/10000);
dt_m=dt_m-10000*year_m;
month_m=floor(dt_m/100);
dt_m=dt_m-100*month_m;
day_m=dt_m;

dt_m=[year_m month_m day_m];
dt_m=datenum(dt_m);

% Nominal 3-month log tb-rate: 1997.12 - 2007.12 %

% Select average yield of monthly riskfree 90-day T-bill %

        % Note: yields in the file are continuously compounded 365 day rates
%in percentage points. We translate them into quarterly log-yields at monthly
%frequency by dividing them by 400 %
ntb_m=rfr(startrow-1:max(size(rfr)),8)/400;


%Truncate CPI data in December 2008 to match the riskfree rate data
a=(cpi_dates<=datenum([endyear+1 1 1]));
cpi=cpi(a);
cpi_dates=cpi_dates(a);
start_cpi=min(find(cpi_dates>=datenum([startyear 01 01])));

% Annual log inflation rate: 1980.01 - 2007.12 %
infl_y=log(cpi(start_cpi:size(cpi,1))) - log(cpi(start_cpi-12:size(cpi,1)-12));

% Quarterly log inflation rate at monthly frequency: 1980.01 - 2007.12 %
infl_q=log(cpi(start_cpi:size(cpi,1))) - log(cpi(start_cpi-3:size(cpi,1)-3));

% Construct quarterly data series by selecting beginning and end of quarter
%observations for nominal yields and end of quarter obs. for inflation rates %
%End of quarter
indx=(3:3:size(ntb_m,1)); % 1980.03 - 2007.12 %
dt=dt_m(indx);
inflq=infl_q(indx);
infl=infl_y(indx);
%ntb_m is shifted by one month relative to dt, i.e. ntb_m(1) corresponds to
%dt_m(1) - one month -> need to unshift this
indx_ntb=indx+ones(rows(indx),1);
ntb=ntb_m(indx_ntb);
%Beginning of quarter
indx=indx-ones(rows(indx),1)*2; % 1997.12 - 2007.09 %
ntb1=ntb_m(indx);


% Real 3-month log tb-rate: 1980.Q1 - 2007.Q4 , where real t-b rate in 1980.Q1 is
%begining-of-quarter nominal rate minus end-of-quarter inflation rate %
rtb=ntb1 - inflq;

%information set at time t is nominal T-bill rate at time t, yearly
%inflation until end of month t, realised quarterly real T-bill rate for
%quarter ending in quarter t

%==========================================================================
%Read in TIPS data
%==========================================================================


% ====================================================================
%                            PANEL A: 1987-2007
%   ==================================================================== %

% ====================================================================
%                 Basic var especification, var order 1
%   ==================================================================== %

% =======================================
%        VAR estimation
%   =======================================  %
nlag=1;  % var order %
[Table3, bondy, frtb, rety, mu, A, V, V_std, beta, tstat, beta_std,R2]=forecasts_feb_2(nlag, rtb, ntb, infl, hor);
       
 %Compute hypothetical and observed quarterly returns   
rety10=rety(:,4);
dtr=dt(2:rows(dt));

save inflation_bonds\quart_returns_US_mar18_7390.mat dtr rety10
