% Use this program to:
% 1) Compute GMV portfolio at all horizons
% 2) Compute tangency portfolio when menu of assets has only stocks and bonds
% and there is a risk-free asset whose mean return is equal to unconditional mean
% real return on t-bills.



% Mr selects moments of real returns and Mx selects moments of excess
% returns
Mr= [1, 0, 0, 0, 0, 0;1,1,0,0,0,0;1, 0, 1, 0, 0, 0];
Mx= [0,1,0,0,0,0;0, 0, 1, 0, 0, 0];
SysId = 3;

addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\risk_return')
load MATLAB\risk_return\dataOUT;
load MATLAB\risk_return\date;

z=dataOUT;
%z_old=dataOUT;
%date_old=date;
%z=z_old(2:rows(z_old),:);
%date=date_old(2:rows(date_old),:);
% Compute tangency portfolio when menu of assets has only stocks and bonds
% and there is a risk-free asset whose mean return is equal to unconditional mean
% real return on t-bills.

max=400;

m=6;	% m denotes the number of variables in the state vector

NumState=m;
%Compute VAR coefficients, sort subsample into one of 3 VAR buckets
if sub_sample<=endsection1
    section=1;
else if sub_sample<=endsection2
        section=2;
    else
        section=3;
    end
end
sec=sectionmat(:,section);
sec=(sec>0);
z_section=z(sec,:);

SM=mean(z);
[PHI0,PHI1,tPHI0,tPHI1,SIGMAv_test,Rsqmat,CorrResid_test,e]=GetParmsNumState_sub(z_section,1,0,1,NumState,SM);

%Now compute covariance matrix for subsample
a=sub_sample_mat(:,sub_sample);
sub=a(sec);
sub=sub(2:size(sub,1));
e_sub=e(sub,:);
SIGMAv=e_sub'*e_sub/rows(e_sub);
CorrResid=corrcoef(e_sub);

%First and last year of 5 year window
first_year=floor(min(date(a))/10000);
last_year=floor(-min(-date(a))/10000);
%Prepare data for output in Table 2
Table2=CorrResid;
Table2=Table2-eye(size(Table2,1));
Table2=Table2+diag(diag(sqrt(SIGMAv)));



G_r=[1 zeros(1,m-1); 0 1 zeros(1,m-2); 0 0 1 zeros(1,m-3)];


% M1 selects real returns for bills, bonds and stocks 
% Msb selects real returns for bonds and stocks 
M1=[1, 0, 0, ;1,1,0;1, 0, 1];
Msb=[0,1,0;0,0,1];


for k=1:max
    %Carolin: These are moments from Table 1 - mean 90 day bill rate, mean
    %excess return on bonds, mean excess return on Treas. bonds, can leave
    %this constant for subsamples, at least at the moment, because we are
    %considering VAR parameters from the entire period
	mu_un(:,:,k)=[1.517718016; 6.311360595; 1.370920888];
    mu_un(:,:,k)=mu_un(:,:,k)/400;
    mu_real_un_kk(:,:,k)=M1*mu_un(:,:,k);
    mu_real_un(:,:,k)=Msb*mu_real_un_kk(:,:,k);
end;

A = PHI1;
Omega = SIGMAv;

max_mat = 400;
IA_factor = zeros(rows(A),cols(A),max_mat);
IA_factor(:,:,1) = eye(rows(A));
for i = 2:max_mat
   IA_factor(:,:,i) = IA_factor(:,:,i-1) + A^(i-1);
end


Sigma_H(:,:,1)  = IA_factor(:,:,1)*Omega*IA_factor(:,:,1);


for i = 2:max_mat
   Sigma_H(:,:,i)  = Sigma_H(:,:,i-1)  + IA_factor(:,:,i)*Omega*IA_factor(:,:,i)';
   
end

for k=1:max_mat

sigma_xx(:,:,k)=Mx*Sigma_H(:,:,k)*Mx';    
sigma_0x(:,:,k)=Sigma_H(2:3,1,k);    
sigma_kk(:,:,k)=Mr*Sigma_H(:,:,k)*Mr';
sigma_rr(:,:,k)=Msb*sigma_kk(:,:,k)*Msb';
sigma_square(:,:,k)= diag(sigma_rr(:,:,k));
%rf(k)=mu_real_un_kk(1,1,k)+0.5*sigma_kk(1,1,1);
rf(k)=mu_real_un_kk(1,1,k);
end

e=ones(rows(sigma_rr(:,:,k)),1);

for k=1:max_mat
   Mu_un_excess(:,:,k)=  k*(mu_real_un(:,:,k)-rf(k)*e);
    A(:,:,k)= (Mu_un_excess(:,:,k))' * inv(sigma_rr(:,:,k)) * (Mu_un_excess(:,:,k))/k;
    sr(:,:,k)=sqrt(A(:,:,k));
    tangency(:,:,k)= (1/((Mu_un_excess(:,:,k))'*inv(sigma_rr(:,:,k))*e))* inv(sigma_rr(:,:,k))*(Mu_un_excess(:,:,k));
    logportf(:,:,k)= inv(sigma_rr(:,:,k))*(Mu_un_excess(:,:,k));
    gmv_kk(:,:,k)= -inv(sigma_xx(:,:,k))*sigma_0x(:,:,k);
    gmv(:,:,k)=[1-gmv_kk(1,:,k)-gmv_kk(2,:,k);gmv_kk(:,:,k)];
    sdgmv(:,:,k)=200*sqrt(((gmv(:,:,k)'*sigma_kk(:,:,k)*gmv(:,:,k))/k));
    sdrtbr(:,:,k)=200*sqrt(sigma_kk(1,1,k)/k);
    outputmatrix(k,:)=[sdrtbr(:,:,k),sdgmv(:,:,k),gmv(1,:,k),gmv(2,:,k),gmv(3,:,k)];
    outputmatrix1(k,:)=[tangency(1,:,k),tangency(2,:,k),sr(1,1,k)];
end 

horizon=(1:1:400);

%Create plot3
if indicate_plot==3
horizon=(1:1:max_mat);
horizon=horizon/4;
plot(horizon, outputmatrix(:,1));
hold on
plot(horizon, outputmatrix(:,2),'g');
hold off
axis([0 50 0 5.5]);
legend('T-bills', 'GMV', 'Location', 'SouthEast')
title(['Figure 3: Risk of T-bills and the Global Minimum Variance Portfolio ',num2str(first_year),' to ', num2str(last_year)])
xlabel('Horizon (Years)')
ylabel('Annualized Standard Deviation (%)')
%saveas(gcf,'risk_return\plots_Figure3\Figure3_fullsample.pdf')
%pause()
end

Figure3=[horizon', outputmatrix(:,1), horizon',outputmatrix(:,2)];
% create spreadsheet with sd of T-till rate, sd of GMV and composition of
% GMV (T-bills, stocks, and bonds) at different horizons, in quarters
%xlswrite('risk_return\gmv.xls_28_08', outputmatrix);

% create spreadsheet with composition of tangency portfolio (stocks and bonds) 
% and Sharpe ratio at different horizons, in quarters
%xlswrite('risk_return\tangency_28_08.xls', outputmatrix1);

%Only keep quarters for plot
outputmatrix_quarter=vertcat(outputmatrix(4,:), outputmatrix(5*4,:), outputmatrix(10*4,:), outputmatrix(25*4,:), outputmatrix(50*4,:), outputmatrix(100*4,:));
%xlswrite('risk_return\gmv_output.xls',outputmatrix_quarter);

outputmatrix1_quarter=vertcat(outputmatrix1(4,:), outputmatrix1(4*10,:), outputmatrix1(25*4,:), outputmatrix1(100*4,:));
outputmatrix1_quarter=outputmatrix1_quarter(:,1:3);
%xlswrite('risk_return\tangency_output.xls',outputmatrix1_quarter);

outputmatrix1_quarter=vertcat(outputmatrix1(4,:), outputmatrix1(4*10,:), outputmatrix1(25*4,:), outputmatrix1(100*4,:));
outputmatrix1_quarter=outputmatrix1_quarter(:,1:3);
%xlswrite('risk_return\tangency_output.xls',outputmatrix1_quarter);


%Create plot4
if indicate_plot==4
bar(outputmatrix_quarter(:,3:5))
axis([0 7 -0.6 1.7])
title(['Figure 4: Composition of Global Minimum Variance Portfolio ',num2str(first_year),' to ', num2str(last_year)])
legend('T-bills', 'Stocks', '5-year bonds')
ylabel('Portfolio Weight')
xlabel('Horizon = 1 Quarter, 5 Years, 10 Years, 25 Years, 50 Years, 100 Years')
%pause()
end
