%This file creates Figures 11 and 12
clear;
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\risk_return')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\risk_return\plots_Figure3')
load MATLAB\risk_return\dataOUT;
load MATLAB\risk_return\date;
z=dataOUT;

%Split data into 5-year intervals
a18=(date>20050000);
a17=and(date>20020000, date<=20050000);
a16=and(date>19990000,date<=20020000);
a15=and(date>19960000, date<=19990000);
a14=and(date>19930000, date<=19960000);
a13=and(date>19900000, date<=19930000);
a12=and(date>19870000, date<=19900000);
a11=and(date>19840000, date<=19870000);
a10=and(date>19810000, date<=19840000);
a9=and(date>19780000, date<=19810000);
a8=and(date>19750000, date<=19780000);
a7=and(date>19720000, date<=19750000);
a6=and(date>19690000, date<=19720000);
a5=and(date>19660000, date<=19690000);
a4=and(date>19630000, date<=19660000);
a3=and(date>19600000, date<=19630000);
a2=and(date>19570000, date<=19600000);
a1=and(date>=19530000, date<=19570000);

sub_sample_mat=[a1 a2 a3 a4 a5 a6 a7 a8 a9 a10 a11 a12 a13 a14 a15 a16 a17 a18];
dates_years=zeros(10,1);

%Split data into thirds for running separate VARs
section1=a1+a2+a3+a4+a5+a6;
section2=a7+a8+a9+a10+a11+a12;
section3=a13+a14+a15+a16+a17+a18;
sectionfull=section2+section3;
endsection1=6;
endsection2=12;

sectionmat=[section1 sectionfull sectionfull];

%Now run tangency3 for all subsamples
%Correlation of excess returns over 25 year horizon
xs_corr_25Y=zeros(10,1);
indicate_plot=3;
for sub_sample=1:18
    run risk_return\tangency5.m
    xs_corr_25Y(sub_sample)=sigma_xx(1,2,100)/sqrt(sigma_xx(1,1,100)*sigma_xx(2,2,100));
    SD_Table2(:,:,sub_sample)=vertcat([first_year last_year zeros(1,cols(Table2)-2)],Table2);
    tangency_Table3(:,:,sub_sample)=vertcat([first_year last_year zeros(1,cols(outputmatrix1_quarter)-2)],outputmatrix1_quarter);
    SaveSTDGMV(:,:,sub_sample)=vertcat(Figure3(1,4),Figure3(20,4), Figure3(40,4), Figure3(80,4));
    SaveSTDriskfree(:,:,sub_sample)=vertcat(Figure3(1,2),Figure3(20,2), Figure3(40,2), Figure3(80,2));
    Risk_Figure3(:,:,sub_sample)=Figure3;
    gmv_Figure4(:,:,sub_sample)=vertcat([first_year last_year zeros(1,cols(outputmatrix_quarter)-2)],outputmatrix_quarter);
    plot_gmv_time(:,sub_sample)=outputmatrix_quarter(3,3:5);
%dates_years(sub_sample)=(first_year+last_year)/2;
dates_years(sub_sample)=last_year;
stdgmvplot(sub_sample,:)=vertcat(dates_years(sub_sample), Figure3(1,4),Figure3(20,4), Figure3(40,4), Figure3(80,4));
stdrfrplot(sub_sample,:)=vertcat(dates_years(sub_sample), Figure3(1,2),Figure3(20,2), Figure3(40,2), Figure3(80,2));
%xlswrite('risk_return\tangency_subsamples.xls',tangency_Table3(:,:,sub_sample),sub_sample);
%xlswrite('risk_return\Table2_subsamples.xls',SD_Table2(:,:,sub_sample), sub_sample);
%xlswrite('risk_return\GMV_risk.xls',SaveSTDGMV(:,:,sub_sample), sub_sample);
  
end

%Make plots
%load TIPS data
clear max;
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds');
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\jan_09');
load MATLAB\inflation_bonds\jan_09\correlation_plots_UK.mat
dates_std10UK=dates_std10;
std_splice10UK=std_splice10;
load MATLAB\inflation_bonds\jan_09\correlation_plots_US.mat
%Convert MATLAB dates into CRSP dates
dates_US=datevec(dates_std10);
dates_US=10000*dates_US(:,1)+100*dates_US(:,2)+dates_US(:,3);
dates_US=dates_US/10000;
dates_UK=datevec(dates_std10UK);
dates_UK=10000*dates_UK(:,1)+100*dates_UK(:,2)+dates_UK(:,3);
dates_UK=dates_UK/10000;

plot(stdgmvplot(:,1), stdgmvplot(:,2),'--b',stdgmvplot(:,1), stdgmvplot(:,4),'-b','LineWidth',2)
hold on
plot(stdrfrplot(:,1), stdrfrplot(:,4),'-.r','LineWidth',2)
hold off
title('Std of Global Mean Variance Portfolio in 5-year periods')
legend('GMV 1qtr horizon', 'GMV 10yr horizon', 'T-bills 10yr horizon')
ylabel('Annualized Std (%)')
%saveas(gcf,'risk_return\std_gmv_3yw.pdf')
%saveas(gcf,'risk_return\std_gmv_3yw.eps')
pause();

datesgmv=datenum([floor(stdgmvplot(:,1)) ones(size(stdgmvplot,1),1)+10*(stdgmvplot(:,1)-floor(stdgmvplot(:,1))) ones(size(stdgmvplot,1),1)]);
plot(dates_std10,100*std_splice10,'k',dates_std10UK, 100*std_splice10UK,'--b','LineWidth',2);
legend('1 YR Ann Std of 10 YR TIPS','1 YR Ann Std of 10 YR UK real bonds','Location','NorthWest')
axis([min(datesgmv) max(dates_std10) 0 18])
set(gca,'xtick',[])
ylabel('Annualized Std (%)')
ax1=gca;
ax2 = axes('Position',get(ax1,'Position'),'YAxisLocation','right','Color','none','XColor','k','YColor','k');
hl3 = line(datesgmv, stdgmvplot(:,4),'Color','r','LineStyle','--','LineWidth',2,'Parent',ax2);
legend('3 YR Ann Std of 10 Year GMV portfolio (right axis)','Location','SouthEast')
axis(ax2,[min(datesgmv) max(dates_std10) 0 6])
datetick(ax2,'x',11,'keepticks')
axis(ax2,[min(datesgmv) max(dates_std10) 0 6])
xlabel('Year')
ylabel('Annualized Std (%)')
title('Std GMV portfolio and daily returns of 10 YR TIPS')
saveas(gcf,'risk_return\std_gmv_TIPS_3yw_2var.pdf')
saveas(gcf,'risk_return\std_gmv_TIPS_3yw_2var.eps')
pause();

%load MATLAB\risk_return\portfolio_gmv_mar17.mat
%Make plot with hypothetical return std
%Need to run the VAR analysis with the sample split in 1973
%Load results from VAR on older part of sample
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds')
load MATLAB\inflation_bonds\quart_returns_US_mar18_53.mat dtr rety10 
dtr53=dtr;
rety_53=rety10;
%Load results fom VAR on data after 1973
load MATLAB\inflation_bonds\quart_returns_US_mar18_7390.mat dtr rety10
dtr73=dtr;
rety_73=rety10;


dtr=[dtr53; dtr73];
rety10=[rety_53; rety_73];

%Split data into 5-year intervals
b18=(dtr>datenum([2005 01 01]));
b17=and(dtr>datenum([2002 01 01]), dtr<=datenum([2005 01 01]));
b16=and(dtr>datenum([1999 01 01]),dtr<=datenum([2002 01 01]));
b15=and(dtr>datenum([1996 01 01]), dtr<=datenum([1999 01 01]));
b14=and(dtr>datenum([1993 01 01]), dtr<=datenum([1996 01 01]));
b13=and(dtr>datenum([1990 01 01]), dtr<=datenum([1993 01 01]));
b12=and(dtr>datenum([1987 01 01]), dtr<=datenum([1990 01 01]));
b11=and(dtr>datenum([1984 01 01]), dtr<=datenum([1987 01 01]));
b10=and(dtr>datenum([1981 01 01]), dtr<=datenum([1984 01 01]));
b9=and(dtr>datenum([1978 01 01]), dtr<=datenum([1981 01 01]));
b8=and(dtr>datenum([1975 01 01]), dtr<=datenum([1978 01 01]));
b7=and(dtr>datenum([1972 01 01]), dtr<=datenum([1975 01 01]));
b6=and(dtr>datenum([1969 01 01]), dtr<=datenum([1972 01 01]));
b5=and(dtr>datenum([1966 01 01]), dtr<=datenum([1969 01 01]));
b4=and(dtr>datenum([1963 01 01]), dtr<=datenum([1966 01 01]));
b3=and(dtr>datenum([1960 01 01]), dtr<=datenum([1963 01 01]));
b2=and(dtr>datenum([1957 01 01]), dtr<=datenum([1960 01 01]));
b1=and(dtr>=datenum([1953 01 01]), dtr<=datenum([1957 01 01]));

window_mat=[b1 b2 b3 b4 b5 b6 b7 b8 b9 b10 b11 b12 b13 b14 b15 b16 b17 b18];
for i=1:18
    b=window_mat(:,i);
    dtr_temp=dtr(b);
    rety_temp=rety10(b);
    dthyp(i)=max(dtr_temp)-365;
    std_hyp(i)=200*std(rety_temp);
end

figure
plot(dthyp, std_hyp,':k',datesgmv, stdgmvplot(:,4),'--r','LineWidth',2);
legend('3 YR Ann Std of hypothetical 10 YR TIPS','3 YR Ann Std of 10 YR GMV portfolio', 'Location', 'NorthWest')
title('Std of GMV portfolio and hypothetical TIPS')
axis([min(dthyp) max(dthyp) 0 9])
datetick('x',11)
ylabel('Annualized (%)')
saveas(gcf,'risk_return\hyp_gmv_3yw_2var2vargmv.pdf')
saveas(gcf,'risk_return\hyp_gmv_3yw_2var2vargmv.eps')

save risk_return\portfolio_gmv_mar18.mat

%Make test plots of GMV over time
plot(dates_years,plot_gmv_time(1,:), dates_years, plot_gmv_time(2,:), dates_years, plot_gmv_time(3,:),'LineWidth',2);
title('Composition of 10 YR Global Minimum Variance Portfolio over time 2VAR')
legend('T-bills', 'Stocks', '5-year bonds','Location','NorthWest')
axis([min(dates_years) max(dates_years), -1,2]);
saveas(gcf,'risk_return\gmv_time_2var.pdf')
saveas(gcf,'risk_return\gmv_time_2var.eps')