function [b0,b1,tb0,tb1,S,Rsqmat,C,e] = GetParmsNumState_sub(z,nlag,L,ind,NumState,RCBposition)
%function [b0,b1,S,C] = GetParmsNumState(z,nlag,L,ind,NumState,RCBposition,SM)

%function [b0,b1,tb0,tb1,S,Rsqmat,CorrResid] = GetParms(z,nlag,L,ind)
% Run VAR estimation to get the underlying parameters.
% It estimates coefficients, Newey-West t stats, and variance-covariance
% matrix of residuals of a VAR(p) for z(t), i.e.
%
%    		z(t) = b(0) + b(1)*z(t-1) + ... + b(p)*z(t-p) + eps(t)
%
% Syntaxis:
%
%				{b0,b1,tb0,tb1,S} = var(z,p,l,ind)
%
% where: z   = (T*k) matrix of obs., with series by columns.
%        nlag   = order of VAR.
%        L   = window width for NW standard errors (0 computes White errors)
%        ind = 0 if no constant included
%              1 if constant included.
%        b0  = intercept coefficients.
%			b1  = [b(1) b(2) ... b(p)] coefficients.
%        tb0 = t-stats of b0.
%			tb1 = t-stats of b1. 
%        S   = (k*k) covariance matrix of residuals
%			Rsqmat = k-by-1 vector of R^2's.
%			CorrResid = Correlation matrix of the residuals.
%       NumState = number of state variables, in FAJ paper consists
%       of cash, equities and nominal bonds, nominal bill rate,
%       dividend-price ratio on yield spread
%       RCBposition = position of real current bill? Needed when want to consider excess returns?   
%       sub=vector of indicator variables indicating the subvector from
%       which to calculate covariance matrix
%Get same results as in FAJ paper by choosing nlag=1, ind=1, L=1, NumState=6,
%z=dataOUT, RCBposition=0
k      = cols(z);
t      = rows(z);
bmat   = zeros(k,(nlag*k));
%tmat   = zeros(k,ind*1+(nlag*k));
e      = zeros(t-nlag,k);
%Rsqmat = zeros(k,1);

tmat   = zeros(k,ind*1+(nlag*k));
Rsqmat = zeros(k,1);


%JW: Save sample means and remove them from z:
	SampleMeans = mean(z)';
	SM_curr = mean(z(nlag+1:t,:))';
	SM_lag = mean(z(1:t-1,:))';

if NumState == 0
	z_old = z;
	z = z - ones(rows(z),1)*SampleMeans';
	b0 = SampleMeans;
	b1 = zeros(k,k);
	e = z - ones(t,1)*b0';
	S = e'*e/rows(e);
	C = corrcoef(e);
	tb0 = [(b0./sqrt(diag(hacnw(t,e,L))))']';
	tb1 = zeros(k);
else
	z_old = z;
	for i=1:k				% Looping over each state variable.
      		y = z(nlag+1:t,i) - ones(rows(z)-1,1)*SM_curr(i)';
      		if i == RCBposition
      			b = [mean(y);zeros(k,1)];
      			bmat(i,:) = b(2:max(size(b)))';
      			e(:,i) = y - mean(y);
			NumState
			size(tmat)
			size([(b(1,1)./sqrt(diag(hacnw(ones(rows(y),1),e(:,i),L))))', zeros(1,NumState) ])
      			tmat(i,1:NumState+1) = [(b(1,1)./sqrt(diag(hacnw(ones(rows(y),1),e(:,i),L))))', zeros(1,NumState) ];
            else
            %State  variables from one period ago
			x = z(nlag:t-1,1:NumState) - ones(rows(z)-1,1)*SM_lag(1:NumState)';
            %Regress on previous period
            b = inv(x'*x)*x'*y;
            %keep all terms, since did not include a constant in the first
            %place
			bmat(i,1:NumState) = b(1:max(size(b)))';	
			if ind == 1;
				x = [ones(t-nlag,1),x];
            b = inv(x'*x)*x'*y;
			bmat(i,1:NumState) = b(2:max(size(b)))';	%strip out constant -- we will fit
			end;
            
            %Residuals
			e(:,i) = (y-x*b);
        		Rsqmat(i) = 1 - var(e(:,i))/var(y);
      		end
      
	end;

	b1 = bmat;
	b0 = (eye(rows(b1)) - b1)*SampleMeans;
	bmat = [b0 b1];
	
	for i=1:k				% Looping over each variable.
		y = z(nlag+1:t,i);
		if i == RCBposition
	      		e(:,i) = y - mean(y);
		else			
			x = z(nlag:t-1,1:NumState);
          	if ind == 1;			% never use a constant for this part
            x = [ones(t-nlag,1),x]; 
			b = bmat(i,1:NumState+1)';
			end;
			e(:,i) = (y-x*b);
	   		Rsqmat(i) = 1 - var(e(:,i))/var(y);
			tmat(i,1:NumState+1) = (b./sqrt(diag(hacnw(x,e(:,i),L))))';
		end
	end;



	b0  = bmat(:,1);
	b1  = bmat(:,2:cols(bmat));
	S   = e'*e/(rows(e));				% ML estimatioin of the cov-var matrix %
    
	C   = corrcoef(e);
	tb0 = tmat(:,1);
	tb1 = tmat(:,2:cols(tmat));


end
