%Compute hypothetical real bond yields UK, Figure 8B
%10/6/2009 cpflueger@hbs.edu
clear;
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\distrib')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\regress')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\util')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds')

hor=[1 2 5 10 20];    % bond maturities (in years) %
startyear=1982;  %Year when data starts to estimate VAR
%End of dataseries
enddate=datenum([2009 4 1]);
% ====================================================================
%                         Load data
%  ==================================================================== %
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation')
[inflation_data,txt]=xlsread('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\daily_deflator_UK_apr_09.xls');
cpi=inflation_data(:,1);
cpi_dates=datenum(txt);
%Get riskfree rate from CRSP starting in 19800130 until December 2007- need to truncate
%inflation series appropriately
[riskfree,txt]=xlsread('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\riskfree_UK_apr09.xls');
rfr=riskfree;
rfr(:,1)=x2mdate(rfr(:,1));
startrow=min(find(rfr(:,1)>=datenum([startyear 01 01])));


% ====================================================================
%                          Variables
%   ==================================================================== %

dt_m=rfr(startrow:max(size(rfr)),1);
dt_CRSP=dt_m;
%No need to convert CRSP dates into MATLAB

% Nominal 3-month log tb-rate: 1997.12 - 2007.12 %

% Select average yield of monthly riskfree 90-day T-bill %

        % Note: yields in the file are continuously compounded 365 day rates
%in percentage points. We translate them into quarterly log-yields at monthly
%frequency by dividing them by 400 %

ntb_m=rfr(startrow-1:max(size(rfr)),2)/400;

%Truncate CPI data in March 2009 to match the riskfree rate data
a=(cpi_dates<=enddate);
cpi=cpi(a);
cpi_dates=cpi_dates(a);
start_cpi=min(find(cpi_dates>=datenum([startyear 01 01])));

% Annual log inflation rate: 1980.01 - 2007.12 %
infl_y=log(cpi(start_cpi:max(size(cpi)))) - log(cpi(start_cpi-12:max(size(cpi))-12));

% Quarterly log inflation rate at monthly frequency: 1980.01 - 2007.12 %
infl_q=log(cpi(start_cpi:max(size(cpi)))) - log(cpi(start_cpi-3:max(size(cpi))-3));

% Construct quarterly data series by selecting beginning and end of quarter
%observations for nominal yields and end of quarter obs. for inflation rates %
%End of quarter
indx=(3:3:size(ntb_m,1)-1); % 1980.03 - 2007.12 %
dt=dt_m(indx);
inflq=infl_q(indx);
infl=infl_y(indx);
%ntb_m is shifted by one month relative to dt, i.e. ntb_m(1) corresponds to
%dt_m(1) - one month -> need to unshift this
indx_ntb=indx+ones(rows(indx),1);
ntb=ntb_m(indx_ntb);
%Beginning of quarter
indx=indx-ones(rows(indx),1)*2; % 1997.12 - 2007.09 %
ntb1=ntb_m(indx);


% Real 3-month log tb-rate: 1980.Q1 - 2007.Q4 , where real t-b rate in 1980.Q1 is
%begining-of-quarter nominal rate minus end-of-quarter inflation rate %
rtb=ntb1 - inflq;

%information set at time t is nominal T-bill rate at time t, yearly
%inflation until end of month t, realised quarterly real T-bill rate for
%quarter ending in quarter t
%==========================================================================
%Read in TIPS data
%==========================================================================

%Get yield splices from TIPS data
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\apr_09')
load \MATLAB\inflation_bonds\apr_09\splice_UK10YR.mat
yield10=splice;
date10=days;
load \MATLAB\inflation_bonds\apr_09\splice_UK20YR.mat
yield20=splice;
date20=days;

%load MATLAB\inflation_bonds\quarterly_returns_US.mat

% ====================================================================
%                            PANEL A: 1987-2007
%   ==================================================================== %

% ====================================================================
%                 Basic var especification, var order 1
%   ==================================================================== %

% =======================================
%        VAR estimation
%   =======================================  %
nlag=1;  % var order %
[Table3, bondy, frtb, rety, mu, A, V, V_std, beta, tstat, beta_std, R2]=forecasts_feb_2(nlag, rtb, ntb, infl, hor);

%Get observed and hypothetical real yields into same format, hypothetical
%data is not affected, because all quarterly dates are also in date10
[dt2,  yield10hyp, yield10q]=format_dates(dt, date10, 400*bondy(:,4), yield10);
[dt3,  frtbhyp, yield10q]=format_dates(dt, date10, frtb, yield10);
corr10=corr(yield10hyp, yield10q);
plot(dt2, yield10q,'LineWidth',2)
hold on;
plot(dt2, yield10hyp ,'--','LineWidth',2)
plot(dt2, frtbhyp*400 ,':','LineWidth',2)
hold off;
%Plot annualized yield in percent
legend('Observed real bonds', 'hypothetical', 'Fitted real T-bill','Location','SouthWest')
title(['Hypothetical and observed UK real 10 year yields, start of VAR=', num2str(startyear),', corr=',num2str(round(100*corr10)/100)])
xlabel('Date')
ylabel('10 year yield')
datetick('x',11)
saveas(gcf,'C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\data_apr\UK_10hypothetical.eps')
plot_matrix1=horzcat(m2xdate(dt2), yield10q,yield10hyp,frtbhyp*400);
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\VAR_plots.xls',plot_matrix1,3,'A2')

Coef10=regression_results(yield10q,yield10hyp);
moments10=[mean(yield10q) mean(yield10hyp)
            std(yield10q) std(yield10hyp)
            corr10 0];


xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\data_apr\compareTIPS.xls',mu, 'C12:C14')
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\data_apr\compareTIPS.xls',A, 'D12:F14')
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\data_apr\compareTIPS.xls',startyear,1,'A4')
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\data_apr\compareTIPS.xls',V_std,1,'C18:C20')
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\data_apr\compareTIPS.xls',V,1,'E18:G20')
        
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\VAR-estimation\data_apr\compareTIPS.xls',moments10, 'C25:D27')

