%This function computes hypothetical real bonds yields from T-bills and
%inflation data 
%10/6/2009 cpflueger@hbs.edu
function [Table3, bondy, frtb, rety, mu, A, V, V_std, beta, tstat, beta_std,R2]=forecasts_feb_2(nlag, rtb, ntb, infl, hor)

t=size(rtb,1);
results = varegress([rtb ntb infl],nlag);

% =======================================
%              Forecasts
%   =======================================  %

k=4*max(hor)+1; % forecast horizon %
T=size(rtb,1);

% Compute E[r(tm+i) | tm] for i=0...k-1 and tm=nlag ... T %
%Matrix of forecasts of rtb, ntb and infl
%Warning: This code might not work for nlag~=1!!!
fcst=zeros(t-nlag+1,3*nlag,k);

%Initiate value for forecasted value of variables and lags thereof
y=[rtb mlag(rtb, nlag-1) ntb mlag(ntb, nlag-1) infl mlag(infl, nlag-1)];
fcst(:,:,1)=y(nlag:rows(y),:);
beta=[results(1).beta results(2).beta results(3).beta];
tstat=[results(1).tstat results(2).tstat results(3).tstat];
R2=[results(1).rsqr results(2).rsqr results(3).rsqr];
beta_std=beta./tstat;
A=beta(1:3,:)';
mu=beta(4,:)';

for i=2:k
%E(rtb(tm+i)|tm))- fitted i-period values from regression - iterate regression on fitted
%i-1-period values from regression
f=squeeze(fcst(:,:,i-1));
if i==2
    xlag=[f ones(t-nlag+1,1)];
else
xlag=[f(:,1) xlag(:,1:nlag-1) f(:,nlag+1) xlag(:,nlag+1:2*nlag-1) f(:,2*nlag+1) xlag(:,2*nlag+1:3*nlag-1) ones(t-nlag+1,1)];
end
fcst(:,:,i)=[xlag*beta fcst(:,1:3*(nlag-1),i-1)];
end

%Only keep forecasts for real T-bill rate
fcst_all=fcst;
fcst=squeeze(fcst_all(:,1,:));
%I need to set this to zero in order to get the numbers in the paper, but
%why does this make sense???
fcst(:,1)=zeros(t-nlag+1,1);
frtb=fcst(:,2);

% Compute yk and rk for all k considered in first line of the program %
bondy=zeros(size(frtb,1),max(size(hor))); % We need this for plots %
rety=zeros(size(frtb,1)-1,max(size(hor)));

%Now compute covariance matrix of innovations
y1=y(nlag+1:T,:);
fitted=fcst_all(nlag:size(frtb,1)-1,:,2);
innov=y1-fitted;
V=corr(innov);
V_std=sqrt(diag(cov(innov)));

Table3=[];
h=1; 
while h<=max(size(hor))

%Have quarterly data!
k=round(4*hor(h));

% Yield on k-period index bond and (k-1)-period bond %
%Use this code to get numbers in paper, take an average of 0 and the
%predicted k-1 quarterly real rates => get
%yk=(r_{t+1}+r_{t+2}+...+r_{t+k-1})/k, where r_t is the quartery real
%T-bill rate starting at time t. Why do we need this? If we set k=1 this
%gives us 0 rather than the forecasted quarterly real yield.
%Leave out r_t because we want to condition on information available at
%time t
%But why do we also do this for the bond with maturity k-1? We will later 
%shift the index by one and use yk_1(t+1) to compute quarterly returns. But
%we do not condition on r_{t+1}
%yk=mean(fcst(:,1:k)');
%yk_1=mean(fcst(:,1:k-1)');

yk=mean(fcst(:,2:k+1)');
yk_1=mean(fcst(:,2:k)');

% One-period return on index bond: notice we lose first obs.,so rk goes from nlag+1 to T %
rk=k*yk(1:max(size(yk))-1)-(k-1)*yk_1(2:max(size(yk)));
%Are yk(t) and yk_1(t+1) conditional on the same information set? It seems 
%yk is conditional on information available at time t and yk_1 is
%conditional on information at time t+1. Why can we leave out the r_{t+1}
%term in yk_1(t+1) when we are taking std conditional on information
%available at time t?
rk=rk';

bondy(:,h)=yk;
rety(:,h)=rk;

%We need to shift rtb by one quarter to get the realised real T-bill rate
%for the beginning of the quarter
rtb1=rtb(nlag+1:T);
frtb1=frtb(nlag:size(frtb,1)-1); % [nlag:T-1] %

%standard deviation of expected real T-bill rate
s2=std(400*frtb1);
%standard deviation of unexpected part of T-bill rate
s3=std(400*(rtb1-frtb1));
%standard deviation of excess return in percent
%what exactly is the timing structure?
%frtb(t) is the forecasted real 3-month T-bill rate for quarter ending in
%t+1 conditional on information available at time t
%rtb(t) is the realised real 3-month T-bill rate for quarter ending in t+1
%rk is the quarterly real return on k-period real bond for quarter ending
%in t+1
s5=std(400*(rk-frtb1));

%This gives NaNs for long horizons => the reason is that the data series is
%not long enough to compute the return of rolling over 90 day T-bill rates
%over 10 years
tmp=zeros(max(size(rtb1))-k+1,1);    % [nlag+k:T]     %
ftmp=zeros(max(size(frtb1))-k+1,1);  % [nlag+k-1:T-1] %
i=1; 
while i<= size(frtb1,1)-k+1
tmp(i)=mean(rtb1(i:i+k-1));
ftmp(i)=mean(frtb1(i:i+k-1));
i=i+1;
end;
yk1=yk(1:max(size(yk))-k);        % [nlag:T-k] %

%s6=std(400*yk1);
%s7=std(400*(tmp-yk1'));
%s8=std(400*(ftmp-yk1'));

%Compare to observed real yields
s6=mean(yk);
s7=std(yk);

Table3=[Table3
    s2 s3 s5 s6 s7];
h=h+1;
end;



