% This function computes annualised mean and standard deviation of daily
% holding returns, dates are centered at the window
%10/6/2009 cpflueger@hbs.edu

function [std_splice, mean_splice, dates_std, bond_std]=std_return_window_ann(splice, bond, window,dates) %window=90 gives stds over 3 month windows

%Compute average of bid-ask spread for each bond over a window of Y days
Y=window;
T=size(dates,1);
std_splice=zeros(T,1);
mean_splice=zeros(T,1);

for t=floor(Y/4):floor(T-Y/4) %Exclude first few and last few days from calculations
    %for every day take average of bid-ask spread over Y/2 days before and
    %Y/2 days after
    a=and(dates<=dates(t)+Y/2,dates>=dates(t)-Y/2);
    splicet=splice(a);
    %Eclude zeros
    a=(splicet~=0);
    splicet=splicet(a);
      
    if sum(a)>0
    std_splice(t)=std(splicet);
    mean_splice(t)=mean(splicet);
    else
        std_splice(t)=0;
        mean_splice(t)=0;
    end
end

a=and(std_splice~=0,mean_splice~=0);
std_splice=std_splice(a);
mean_splice=mean_splice(a);
dates_std=dates(a);
bond_std=bond(a);

%Annualize mean returns
mean_splice=252*mean_splice;
%Annualize standard deviations
std_splice=sqrt(252)*std_splice;


 
 %Plot for bond k
 %k=15;
 %First remove zeros
 %a=(spread_px(:,k)==0);
 %a=(a==0);
 %daysplot=days(a);
 %meanplot=spread_px(a,k);
 %Remove outliers and zeros,
 %outup=quantile(meanplot, 0.99);
 %outdown=quantile(meanplot, 0.01);
 

 %a=and(meanplot<=outup, meanplot>outdown);
 %daysplot=daysplot(a);
 %meanplot=meanplot(a);
 %plot(daysplot, meanplot,'-k');
 %datetick('x', 11);
%title('US, average bid-ask spread of one bond over time');
%axis([min(daysplot) max(daysplot) -0.05 0.2])


