%This function makes splices by always jumping to the bond whose remaining
%time to maturity is just Y days. This can be used for splicing either
%yields or returns
%10/6/2009 cpflueger@hbs.edu

function [splice, days, bond, yieldsY, bound]=splice_maturity(dates,yields, issue, mat,Y) %Y=3652 corresponds to 10 years
T=size(dates,1);
splice=zeros(T,1);
bond=zeros(T,1);
maturity=mat-issue;

%Eliminate bonds with maturity smaller than Y
keep=(maturity>=Y);
yieldsY=yields(:,keep);
matY=mat(keep);
issueY=issue(keep);
maturityY=maturity(keep);

%Start of spliced series
t=(matY-Y).*(maturityY>=Y);
%Find date closest to min(t)

a=(dates-min(t))+70000*(dates<min(t));
start=find(a==min(a));

for t=start:T
    bond(t)=mostrecent_xY(dates(t), issueY, matY, Y);
    splice(t)=yieldsY(t,bond(t));
end

%Only keep dates with data
a=and(bond>0, splice~=0);
days=dates(a);
splice=splice(a);
bond=bond(a);
yieldsY=yieldsY(a,:);
    
   bound=quantile(splice, 0.995);
    %[days, splice, bond]=removeout(dates, splice, bond, bound);
  
    
    
    
    
    
    