%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This code computes nominal quantities for US TIPS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
%load price data
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\apr_09');
load MATLAB\inflation_bonds\apr_09\px_US.mat
%Remove some extreme outliers
a=and(px<10,px>0);
a=sum(a,2);
a=(a==0);
px=px(a,:);
days=days(a);
%Convert dates into Matlab format
datepx=x2mdate(days); %Convert dates 
%Delete weird rows
a=(datepx>720000);
datepx=datepx(a);
px=px(a,:);

load MATLAB\inflation_bonds\apr_09\deflator_US.mat
%Datevector for daily CPI - double-checked this with data on Treasury
%website
dates_index=days';

%Get issue, maturity and coupon dates
load MATLAB\inflation_bonds\apr_09\yieldsdata_US.mat

%Settlement date is one business date after trade date
dates=busdate(datepx);

%Dates gives settlement date corresponding to trade date
%datepx

T=size(dates,1);
N=size(px,2); %N is number of bonds
inflation_factor=zeros(T,N); %matrix of individual inflation factors for every bond at every date

%Find base CPI, with intended issue, double-checked this with treasury

N=size(px,2); %Number of bonds
for n=1:N
%Find CPI at intended issue
    a=(dates_index==issue_intended(n)); %dates_index contains all dates so should never get empty set here
    if sum(a)==1
        CPI_issue=inflation_index(a);
    end
    for t=1:T
    a=(dates_index==dates(t));
    if sum(a)==1
    inflation_factor(t,n)=inflation_index(a)/CPI_issue;
    end
    end
end

inflation_factor=round(inflation_factor*100000)/100000;

N=size(px,2); %Number of bonds
T=size(dates,1);
interest=zeros(T,N); %real interest payments
AccInt=zeros(T,N);
Redemption_payment=zeros(T,N); %redemption payment at maturity, need to multiply with max(index_ratio,1) to get nominal quantity

for n=1:N
    a=(issue_intended(n)<=dates);
    b=(mat(n)>=dates);
    c=and(a==1,b==1);
    T_issuenext=sum(1-a)+1;
    T_matnext=sum(b);
    
    %Compute accrued interest and interest cash flows
    %Use this to compute vector of actual coupn dates; for US TIPS do not need to take into account
    %weekends and holidays
    [CFlowAmounts, CFlowDates, TFactors, CFlowFlags]=cfamounts(coupon(n), issue_intended(n), mat(n), period(n), 0,0, issue_intended(n),first_coupon(n));
    
    coupon_dates=CFlowDates';
    a=(coupon_dates>issue(n));
    coupon_dates=coupon_dates(a);    
 
    %Now for every date compute next coupon date and previous coupon date
    previouscpn=dates;
    nextcpn=dates;

    for t=T_issuenext:T_matnext
        previous=dates(t)-coupon_dates+(coupon_dates>dates(t))*70000;
        next=coupon_dates-dates(t)+(dates(t)>=coupon_dates)*70000;
        a=(previous==min(previous));
        b=(next==min(next));
        previouscpn(t)=coupon_dates(a);
        nextcpn(t)=coupon_dates(b);
    end
    
    lengthcpn=(nextcpn-previouscpn).*c;
    %On maturity date the length of the coupon period is 0
    a_redempt=(dates==mat(n));
    lengthcpn(a_redempt)=0;
    
    fromlastcpn=dates-previouscpn; %No of days from previous coupon date to date
    fraction=fromlastcpn./lengthcpn; %Fraction of coupon period 
    accrued_temp=fraction.*coupon(n)/period(n);
    accrued_temp(a_redempt)=0; %Remove NaN's
    accrued_temp=accrued_temp.*c*100;
    
    AccInt(:,n)=-accrued_temp;
    
   N_coupons=size(coupon_dates,1);
    for m=1:N_coupons
        x=(dates==coupon_dates(m));
        if(sum(x)==1)
            interest(:,n)=interest(:,n)+x*coupon(n)/period(n);
        end
    end
    
    y=(dates==mat(n));
    Redemption_payment(:,n)=Redemption_payment(:,n)+y*100; %On face value of 100

end
interest=interest*100; %Expressed in percent

save inflation_bonds\apr_09\real_returns.mat

%Now multiply all variables with inflation ratio to get nominal values
px_nom=px.*inflation_factor;
interest_nom=interest.*inflation_factor;
AccInt_nom=AccInt.*inflation_factor;
%In France have a deflation-floor
Redemption_payment_nom=Redemption_payment.*max(inflation_factor,1);

%add coupon payments and redemption payment
interest_nom=interest_nom+Redemption_payment_nom;

%Now add on accrued interest to get 'full price', AccInt_nom is saved as
%negative
px_full=px_nom-AccInt_nom;

%Now compute nominal daily returns for bond n
N=size(px,2); %Number of bonds
ret_nom=px_nom; %Daily holding return from yesterday to today

%Define px_full_minus,datepx_minus as the full price on the previous date
px_full_minus=px_full;
datepx_minus=datepx;
Tpx=size(datepx,1);

for t=2:Tpx
    px_full_minus(t,:)=px_full(t-1,:);
    datepx_minus(t)=datepx(t-1);
end
datepx_minus(1)=0;
px_full_minus(1,:)=zeros(1,N);

for n=1:N
    %If price data is available for day and previous business day compute nominal
    %daily return, otherwise set return to NaN
    a=and(datepx==busdate(datepx_minus),px_full(:,n)>5).*(px_full_minus(:,n)>5); %check whether >5 because if price is 0 and accrued interest>0 can have 
    %very small price which is wrong
    a=(a>0);
    ret_nom(:,n)=(px_full(:,n)-px_full_minus(:,n)+interest_nom(:,n))./px_full_minus(:,n);
    ret_nom(:,n)=ret_nom(:,n).*a;
end

for n=1:N
    for t=1:Tpx
        if isnan(ret_nom(t,n))
            ret_nom(t,n)=0;
        end
    end
end        

%Compute quarterly real returns until end 2007
%Load quarterly dates
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds')
load MATLAB\inflation_bonds\dt.mat
retq=zeros(size(dt,1)-1,N);
for n=1:size(dt,1)-1
    a=and(datepx>dt(n), datepx<=dt(n+1));
    div=sum(interest_nom(a,:));
    z=min(find(datepx>dt(n)));
    pxq=px_full(z,:);
    z=min(find(datepx>dt(n+1)));
    pxqplus=px_full(z,:);
    a=and(pxq>5,pxqplus>5);
    retq(n,:)=(pxqplus-pxq+div)./pxq;
    %replace NaNs by 0
    retq(n,:)=max(retq(n,:),-10000*a);
end
%use this date to make splices
dtq_splice=dt(1:size(dt,1)-1);
%use this date to make plots
dtq=dt(2:size(dt,1));

save inflation_bonds\apr_09\nominal_returns_US.mat

%Now need to splice nominal returns together 
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds')
Y=3652; %10 year splice
[splice_ret, dates_ret, bond, retY, bound]=splice_maturity(datepx,ret_nom, issue, mat,Y);
window=365;
[std_splice10, mean_splice10, dates_std10, bond_std]=std_return_window_ann(splice_ret, bond, window,dates_ret);

%Now make 20 year splices
Y=2*3652-20; %20 year splice
[splice_ret, dates_ret, bond, retY, bound]=splice_maturity(datepx,ret_nom, issue, mat,Y);
window=365;
[std_splice20, mean_splice20, dates_std20, bond_std]=std_return_window_ann(splice_ret, bond, window,dates_ret);

%splice quarterly returns
Y=3652; %10 year splice
[retq10, dateq10, bondq, retYq, boundq]=splice_returns(dtq_splice,retq, issue, mat,Y);

Y=2*3652-20; %20 year splice
[retq20, dateq20, bondq, retYq, boundq]=splice_maturity(dtq_splice,retq, issue, mat,Y);

hold off;
plot(dates_std10,std_splice10);
hl2=line(dates_std20,std_splice20, 'Color','k');
datetick('x',11)
legend('std 10Y', 'std 20Y','Location','NorthWest');
ax1 = gca;
ax2 = axes('Position',get(ax1,'Position'),'YAxisLocation','right','Color','none','XColor','k','YColor','k');
hl3 = line(dates_std10,mean_splice10,'Color','g','Parent',ax2);
hl4=line(dates_std20,mean_splice20, 'Color','m', 'Parent',ax2);
datetick('x',11)
title('US - std and mean of annualized daily returns, computed over 1 year window');
legend('mean 10Y', 'mean 20Y','Location','NorthEast');
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\apr_09')
saveas(gcf,'inflation_bonds\apr_09\USstd_mean_returns.pdf')
pause();

%Have to keep this name because it gets used by other m-files
save inflation_bonds\apr_09\returnsUS10Y.mat