%Computes normal, long and short dividend payments in real terms for bonds
%with 3 month indexation lag
%10/6/2009 cpflueger@hbs.edu
function [interest, next_interest]=compute_dividend_UK(period_type, coupon_n, issue_n, first_coupon_n, period_n, nextqcpn, previousqcpn, T_issuenext, coupon_dates)

%Real interest
interest=(period_type==1).*(coupon_n/period_n); %normal coupon periods
d=nextqcpn(T_issuenext)-previousqcpn(T_issuenext); %length of first quasi coupon period
interest=interest+(coupon_n/period_n)*(period_type==2).*(first_coupon_n-issue_n)'/d;
interest=interest+(period_type==3)*((nextqcpn(T_issuenext)-issue_n)/d+1)*(coupon_n/period_n);
next_interest=interest;
T=size(interest,1);
for t=2:T
    interest(t)=next_interest(t-1);
end
interest=interest.*coupon_dates;
%Nothing is being paid on issue date
interest(T_issuenext)=0;




