%This computes real accrued interest for 8 month lagged UK inflation linked gilts before 1998; 
%uses actual/365 daycount convention as dexcibed in DMO mimeo
%10/6/2009 cpflueger@hbs.edu
function AccInt=compute_accrued_interest_UK_before98(previouscpn, nextcpn, exdiv, next_interest, dates)


%Indicator that day after ex dividend date
after_exdiv=dates'-exdiv;
after_exdiv=(after_exdiv>0);

%Real Accrued Interest for normal dividend periods
%Number of days from the previous dividend date (or issue date in the case of a first dividend) 
%to the settlement date
t1=dates'-previouscpn;
t2=nextcpn-dates'; %Number of days till next coupon payment

AccInt=(t1/182.5).*next_interest.*(1-after_exdiv)-(t2/182.5).*next_interest.*after_exdiv;

