%This computes real accrued interest for UK inflation linked gilts for 3 month lagged gilts, follow
%terminology in Deacon, Derry and Mirfendereski
%10/6/2009 cpflueger@hbs.edu
function AccInt=compute_accrued_interest_UK(previouscpn, nextqcpn, previousqcpn, period_type, exdiv, issue_n, coupon_n, period_n, next_interest, dates, T_issuenext, first_coupon_n)


%Indicator that day after ex dividend date
after_exdiv=dates'-exdiv;
after_exdiv=(after_exdiv>0);

%length of quasi coupon-period
d=nextqcpn-previousqcpn;
d=max(d,0.01); %Avoid dividing by 0
%Real Accrued Interest for normal dividend periods
%Number of days from the previous dividend date to the settlement date
t=dates'-previouscpn;

AccInt_normal=((t./d)-after_exdiv).*next_interest;
%get rid off NaN's
AccInt_normal=max(AccInt_normal,-100);
AccInt_normal=AccInt_normal.*(period_type==1);

%Real Accrued Interest for short dividend periods
t_star=dates'-issue_n;
AccInt_short=t_star./d*coupon_n/period_n-(after_exdiv*(nextqcpn(T_issuenext)-issue_n))./d*coupon_n/period_n;
AccInt_short=max(AccInt_short,-100);
AccInt_short=AccInt_short.*(period_type==2);

%Real accrued interest for long dividend periods
first_qcpn=(dates<=nextqcpn(T_issuenext))'; %Indicator whether date in first quasi-coupon period after issue
t=dates'-issue_n;
d1=nextqcpn(T_issuenext)-previousqcpn(T_issuenext);
d2=first_coupon_n-nextqcpn(T_issuenext); %Length of second quasi-coupon period
f1=nextqcpn(T_issuenext)-issue_n;
f2=dates'-nextqcpn(T_issuenext);
AccInt_long=first_qcpn.*t./d*coupon_n/period_n+((1-first_qcpn).*(1-after_exdiv).*f2)*(coupon_n/(period_n*d2))+(1-first_qcpn).*(1-after_exdiv).*(f1/d1)*coupon_n/period_n+(1-first_qcpn).*after_exdiv.*(f2./d2-1)*coupon_n./period_n;
AccInt_long=max(AccInt_long,-100);
AccInt_long=AccInt_long.*(period_type==3);
AccInt=AccInt_normal+AccInt_short+AccInt_long;


