%Computes cashflows at next quasi coupon date and quasi coupon date for
%yield/price conversion
%10/6/2009 cpflueger@hbs.edu
function [d1,d2]=compute_Div_UK(dates,exdiv, nextqcpn, issue, mat, coupon, period, first_coupon,T_issuenext, T_matnext,n)
dates2=(min(dates):min((max(dates)+365),mat(n)));
[interest_temp2, next_interest_temp2, nextqcpn2]=compute_next_interest(dates2, issue, mat, coupon, first_coupon, period,n);
a=(dates2==mat(n));
nextqcpn2=nextqcpn2.*(1-a')+mat(n)*a';
nextqcpn=min(nextqcpn,mat(n));

T=size(dates,2);
d1=zeros(T,1);
d2=zeros(T,1);
for t=T_issuenext:T_matnext
    a=(nextqcpn(t)==dates2);
    d1(t)=interest_temp2(a);
    nextnextqcpn=nextqcpn2(a);
    b=(nextnextqcpn==dates2);
    if sum(b)==1
    d2(t)=interest_temp2(b);
    end
end
after_exdiv=(dates'>exdiv);
d1=d1.*(1-after_exdiv);