%Computes annualized means standard deviations, correlations and betas over a time
%window of 'window' dates, get a moving average
%Dates are centered
%10/6/2009 cpflueger@hbs.edu
function [mean1, mean2, std1, std2, returns_corr, returns_beta, dates_corr]=beta_return_window(return1,return2,dates, window)

%Compute average of bid-ask spread for each bond over a window of Y days
Y=window;
T=size(dates,1);
std1=zeros(T,1);
mean1=zeros(T,1);
std2=zeros(T,1);
mean2=zeros(T,1);
returns_corr=zeros(T,1);
returns_beta=zeros(T,1);

for t=floor(Y/4):floor(T-Y/4) %Exclude first few and last few days from calculations
    %for every day take average of bid-ask spread over Y/2 days before and
    %Y/2 days after
    a=and(dates<=dates(t)+Y/2,dates>=dates(t)-Y/2);
    return1t=return1(a);
    return2t=return2(a);
    %Exclude zeros
    a=and(return1t~=0, return2t~=0);
    return1t=return1t(a);
    return2t=return2t(a);
      
    if sum(a)>0
    std1(t)=std(return1t);
    mean1(t)=mean(return1t);
    std2(t)=std(return2t);
    mean2(t)=mean(return2t);
    returns_corr(t)=corr(return1t,return2t);
    returns_beta(t)=std1(t)*returns_corr(t)/std2(t);
    else
        std1(t)=0;
        mean1(t)=0;
        std2(t)=0;
        mean2(t)=0;
        returns_corr(t)=0;
        returns_beta(t)=0;
    end
end

a=(std1~=0).*(mean1~=0).*(std2~=0).*(mean2~=0).*(returns_corr~=0).*(returns_beta~=0);
a=(a>0);
std1=std1(a);
mean1=mean1(a);
std2=std2(a);
mean2=mean2(a);
returns_corr=returns_corr(a);
returns_beta=returns_beta(a);
dates_corr=dates(a);

%Annualize mean returns
mean1=252*mean1;
mean2=252*mean2;
%Annualize standard deviations
std1=sqrt(252)*std1;
std2=sqrt(252)*std2;


