% -- Procedure that computes the -log-likelihood function track values of variables -- 
function [yfts, alphats,xret] = track_likelihood_fixparams(prm,y)


% /* This procedure computes log-likelihood function of Campbell, Sunderam, and Viceira's term-structure model.
%    The proc. uses the unscented KF of Julier and Uhlmann, that allows for nonlinear state transitions and observation equations.
% 
%    The first argument is a vector with values for the model parameters.
%    The second argument is a matrix with observations. The first column
%    must be data on log real yields; the second is the realized variance 
%    of the return on 10 yr nominal bonds; the third is the realized covariance between the 
%    return on 10 yr nominal bonds and returns on equity; the fourth is the dividend yield;
%    the fifth is the return on equities; the sixth is the inflation rate;  and the rest of 
%    are log nominal yields in natural units and sorted from lowest maturity to largest maturity.
% 
%    NOTE: you must define inside the procedure a vector of maturities for nominal yields n,
%    the maturity of real yields tips_n, the maturity used to calculate the
%    covariance w/ equities cov_n, and the maturity used to calculate the
%    volatility var_n.
% */

% -- Define here the vector of MATURITIES, use 2 year maturity as shortest
% maturity in order to avoid discrepancies between Fed data and 3 month
% T-bill rate
%Only try to match 10 year yield
n=4*10;
%compute variances and covariances for 10 year maturity
cov_n = 40;
var_n = 40;

% -- Rescale parameter vector and recover orignal parameters
scl=1;
prm=prm./scl;

% order of parameters is: 
% mu_x|mu_z|mu_v|phi_x|phi_z|phi_v
% sigma_m|sigma_x|sigma_x'|sigma_z|sigma_v
% sigma_mx|sigma_mx'|sigma_mz|sigma_mv
% sigma_xx'|sigma_xz|sigma_xv|sigma_x'z|sigma_x'v
% sigma_zx
% sy(1:4)|seq|scov|svol|bex|bem
mu_x = prm(1);
mu_v = prm(2);

phi_x = exp(prm(3))/(1+exp(prm(3)));
phi_v = exp(prm(4))/(1+exp(prm(4)));

sigma_x=1;
sigma_mx=prm(5);
sigma_xi=prm(6);
sigma_v=prm(7);

sigma_mxi=0;
sigma_mv=0;
sigma_xxi=0;
sigma_xv=0;
sigma_xiv=0;

sy=prm(8);
%svol=prm(11);
scov=prm(9);
bex=0;
premium=prm(10);


%Set sigma_m equal to equity premium
sigma_m=0.23;
%Se bem accordingly
%bem=sigma_e/sigma_m;
bem=0.411015532121398;
%sigma_mx=3.411873661562056e-004;

%/* Measurement equation: Calculate the loadings of yields on state
%variables
%*/

%Covariance matrix of errors
% order is m,x,xi,z,v

%Number of maturities
n_max = n(length(n));
%coefficients for real yields
Bx = -(1-(phi_x.^[1:n_max]))./(1-phi_x);
Bx = Bx';
Bv=zeros(n_max,1);
A = zeros(n_max,1);
Cv = zeros(n_max,1);

%recursion for coefficients
for i=2:n_max
   k = Bv(i-1)+2*Cv(i-1)*mu_v*(1-phi_v);
  
   %Make use of the fact that many covariances=0
   g = inv(sigma_v^(-2)-2*Cv(i-1));

   A(i) = A(i-1)+Bx(i-1)*mu_x*(1-phi_x)+Bv(i-1)*mu_v*(1-phi_v);
   A(i) = A(i)+Cv(i-1)*mu_v^2*(1-phi_v)^2;
   A(i) = A(i)-.5*log(sigma_v^2)+.5*log(g);
   A(i)=A(i)+.5*Bx(i-1)^2*sigma_xi^2+.5*g*k^2;
  
   Bv(i) = k*phi_v-Bx(i-1)*sigma_mx;
   Bv(i)=Bv(i)+2*g*k*Cv(i-1)*phi_v;

   Cv(i) = Cv(i-1)*phi_v^2+.5*Bx(i-1)^2*sigma_x^2+... 
             2*g*Cv(i-1)^2*phi_v^2;

end

% observation equation loadings on the state variables 
% a = cov(equities, bond returns), v=bond volatility, e = equity returns
vv= -2*sigma_mx*Bx(var_n-1)+4*sigma_v^2*Cv(var_n-1)*phi_v*k;
vv2 = Bx(var_n-1)^2*sigma_x^2+4*Cv(var_n-1)^2*sigma_v^2*phi_v^2;
av = (bex*sigma_x^2+bem*sigma_mx)*Bx(cov_n-1);
%ez = bex*sigma_mx+bem*sigma_m^2;

% Set up a matrix Z and vector d such that the observation equations and given by
% Z*[vector of state variables]+d
% when observation depends on lagged state variable (e.g. z_{t-1}), we
% "fold it back" using the relation z_{t-1} =(z_t-mu_z*(1-phi_z)-e_{z,t})/phi_z
% This is a bit of a mess, but works better than any alternatives - why can
% we do that? Do we need to include extra errors in observation equations?
%d1 = sigma_m^2+Bx(var_n-1)^2*sigma_xi^2+sigma_v^2*k^2+2*sigma_v^4*Cv(var_n-1)^2;
%d1=d1+vv2*mu_v^2*(1-phi_v)^2/phi_v^2-vv*mu_v*(1-phi_v)/phi_v;
d2 = 0;
%d2=d2-av*mu_v*(1-phi_v)/phi_v;
d = [(-A(n)./n);d2];

% Order of observation equations is real yields, vol, cov,eqr
% yields.
%d = [(-A(n)./n);d1;d2;d3];

%order augmented state is: x,v,v^2, e_m, e_x, e_xi, e_v, 
%measurement errors (e_y1, e_y2, e_y3, e_y4, e_vol, e_cov,

%real yields
Z0 = [-Bx(n)./n, -Bv(n)./n, -Cv(n)./n,...
        zeros(max(size(n)),4),diag(ones(max(size(n)),1)),zeros(max(size(n)),1)];
%vol
%Z1 = [0,vv/phi_v - 2*vv2*mu_v*(1-phi_v)/phi_v^2,vv2/phi_v^2,...
     %zeros(1,4),zeros(1,max(size(n))),1,zeros(1,1)];
Z2 = [0,av/phi_v,zeros(1,1),zeros(1,4),zeros(1,max(size(n))),1];
%Do not use equity premium for the moment
%Z3 = [1/phi_x, zeros(1,2),bem,bex,zeros(1,2),zeros(1,6),1];

Z = [Z0;Z2]; %7x18
    
% ---- Log Likelihood function ---- 
[y_m y_n]=size(y(:,1:6));

% -- Initial values -- 
%What is alpha?
%Q,S_eps,S_u and G are the blocks of the covariance matrix P0 in unscented
%Kalman filter
%Q=Prior for covariance matrix of non-squared state variables: multiply error cov by mean
%of respective state variable
%Set alpha(1)=observed short rate
alpha=[mu_x; mu_v];
q11 = mu_v^2*sigma_x^2+2*mu_v*sigma_xxi+sigma_xi^2;
q12 = mu_v*sigma_xv+sigma_xiv;
q22 = sigma_v^2;

Q = [q11,q12;
     q12,q22]; %3x3

%S_eps=Prior for covariance matrix of error terms; order is m,x,xi,z,v
S_eps = [sigma_m^2,sigma_mx,sigma_mxi,sigma_mv;
    sigma_mx,sigma_x^2,sigma_xxi,sigma_xv;
    sigma_mxi,sigma_xxi,sigma_xi^2,sigma_xiv;
    sigma_mv, sigma_xv, sigma_xiv, sigma_v^2]; %5x5

%S_u=Prior of covariance matrix of Order is yields, vol, cov, eq
S_u = diag([(10^3.*sy).^2;(10^3*scov)^2]); %7x7
S_u=S_u*10^-6;

G = zeros(size(Q,1),size(S_eps,2));

% Parameters and weights for the unscented Kalman filter
kappa = 1e-4;

P = [Q, G, zeros(size(Q,1),size(S_u,2));
        G',S_eps,zeros(size(S_eps,2),size(S_u,2));
        zeros(size(S_u,2),size(S_eps,2)+size(G,1)), S_u];%15x15, L=dim(P)
L=size(P,1);
%Define weights
gamma = sqrt(kappa^2*L);
weights_m = ones(2*L+1,1)/(2*kappa^2*L);
weights_m(1) = 1-1/kappa^2;
weights_c = ones(2*L+1,1)/(2*kappa^2*L);
weights_c(1) = 1-1/kappa^2+(3-kappa^2);

% -- Transition equation -- need this for updating in UKF
%Constant in transition equation
c = [(1-phi_x)*mu_x;(1-phi_v)*mu_v];%3x1
%Dynamic part of transition equation
T = diag([phi_x;phi_v]);

% leaves out v_t*eps_x - nonlinear in augmented state,
% from xi_{t+1} eq and lambda_{t+1} eq
% order of the epsilons is m,x,xi,z,v
T_eps = zeros(max(size(T)),max(size(S_eps)));
T_eps(1,3)=1;
T_eps(2,4)=1;
T = [T,T_eps,zeros(2,max(size(S_u)))]; %3x15

% The unscented KF algorithm starts here
l=zeros(y_m,1);
yfts=zeros(y_m,2);
alphats=zeros(y_m,3);
xret=zeros(y_m,1);
for i=1:y_m
    
   P = [Q, G, zeros(size(Q,1),size(S_u,2));
        G',S_eps,zeros(size(S_eps,2),size(S_u,2));
        zeros(size(S_u,2),size(S_eps,2)+size(G,1)), S_u];%14x14, L=dim(P)
   [cholP,psd] = chol(P);
   %Check that P is actually positive semi-definite
   if psd > 0
       adkjfldsajf=1;
       l = -1e20*ones(y_m,1);
       break;
   end
   a = [alpha;zeros(L-max(size(alpha)),1)]; % 15x1, vector of prior means
   
   %Calculate sigma-points, these are saved in chi
   % chi row order is x,z,,v, measurement errors
   chi = [a,kron(ones(1,L),a)+gamma*cholP,kron(ones(1,L),a)-gamma*cholP]; % 15x31
   %Compute expression (7.40) in Table 7.3.1 in Wan and van der Werwe
   alphaf_hat = T*chi+kron(ones(1,2*L+1),c);%3x31
   % add v_t*eps_{x,t+1} to x_{t+1}; 
   alphaf_hat(1,:) = alphaf_hat(1,:)+chi(2,:).*chi(4,:);
  
   alphaf = alphaf_hat*weights_m;%5x1
   
   %Compute expression (7.42)
   Qf = 0;
      % To prevent rounding errors from becoming too large, we scaled up by
   % (10^5)^2 and then scaled back down
   for j= 1:(2*L+1)
       Qf = Qf + weights_c(j)*(1e5*alphaf_hat(:,j)-1e5*alphaf)*(1e5*alphaf_hat(:,j)-1e5*alphaf)';
   end
   Qf = Qf/1e5^2;
   
   % compute (7.43) - for this need conditional expectations of a at time t
   
   %Set x_t equal to the observed short rate
   chi_hat = [alphaf_hat(1,:); alphaf_hat(2,:);
          alphaf_hat(2,:).^2;
          chi(3:size(chi,1),:)];%18x31
   yf_hat = Z*chi_hat+kron(ones(1,2*L+1),d); % 18x31
   %yf = yf_hat*weights_m; %10x1
   yf=Z(:,1:3)*[alpha; alpha(2)^2]; 
   
   y_i=[y(i,3) y(i,7)]';
   
   Pyy = 0;
   Pay = 0;
   for j=1:(2*L+1)
       Pyy = Pyy+weights_c(j)*(1e5*yf_hat(:,j)-1e5*yf)*(1e5*yf_hat(:,j)-1e5*yf)';%10x10
       Pay = Pay+weights_c(j)*(1*alphaf_hat(:,j)-1*alphaf)*(1*yf_hat(:,j)-1*yf)';%5x10
   end
 
   Pyy=Pyy/1e5^2;
   v_y = y_i-yf;
   yfts(i,:)=yf';
   K = Pay*inv(Pyy);%5x10
   alpha = alphaf+K*v_y;
   alpha(1)=y(i,1)+premium;
   alpha(2)=y(i,7)/(av/phi_v);
   Q = Qf-K*Pyy*K';
   if i==1
      l(i)=0;
   else
      l(i)= -.5*y_n*log(2*pi)-.5*log(det(Pyy))-.5*v_y'*inv(Pyy)*v_y;
   end
   alphats(i,:)=[alpha',alpha(2)^2];
   xret(i)=Bx(n-1)*sigma_mx*alpha(2);
   yfts(i,:)=Z(:,1:3)*alphats(i,:)';
end
   
Like = -sum(l);
% if Like < minLike
%     minLike = Like;
%     minPar = prm;
% end
if abs(imag(Like)) > .01
    Like = 1e30;
end
