% This performs estimation routine for the constant covariance model in
% Figure 9
%10/6/2009 cpflueger@hbs.edu
clear;
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation\newdata')

%Get data, this is formatted in prepare-datafeb22
load MATLAB\inflation_bonds\model-estimation\newdata\mydata.mat

% /* ___________________________________________________________________
% 
%    ________________________ ESTIMATION _______________________________
% 
%    ___________________________________________________________________
% */

% order of parameters is: 
% mu_x|mu_z|mu_v|phi_x|phi_z|phi_v
% sigma_m|sigma_x|sigma_x'|sigma_z|sigma_v
% sigma_mx|sigma_mx'|sigma_mz|sigma_mv
% sigma_xx'|sigma_xz|sigma_xv|sigma_x'z|sigma_x'v
% sigma_zx
% sy(1:4)|svol|scov|seq|bex|bem|dummy03
   
%Start at estimated parameter values for fixparam, choose large sy

init=[    
   0.010586611538989;
   2.636022375590813;
   0.004335533604988;
   0.000625164933862;
   0.000091677335115;
   0.015952320893370];

scl=1;
init=init.*scl;


% ---- Estimation routine ---- 
% minimize -likelihood and save output

%Define myfun as a function of param - this way keep mydata fixed and
%optimize over param

%Can define myfun as a function of param values and init values - this
%effectively fixes some param values at their initial values and they don't
%get estimated
myfun = @(param)ukf_likelihood_fixparams_nov(param,mydata);

%Only make small adjustments from parameter values with v
options = optimset(@fminsearch);
options = optimset(options,'MaxFunEvals',2500,'MaxIter',1000,'TolFun',1e-3,'TolX',1e-8);


%----- Evaluate likelihood at a number of random points to find an
%interesting starting point
N_rand=10000;
val=zeros(N_rand,1);
%Create random starting values
init_rand=mvnrnd(init, 6*diag(init.^2),N_rand);
for n=1:N_rand
    val(n)=ukf_likelihood_fixparams_nov(init_rand(n,:)',mydata);
end
[a,b]=sort(val);
init_new=init_rand(b,:)';
val_new=a;
  

N_fit=5;
estnew=zeros(max(size(init)),N_fit);
enew=zeros(N_fit,1);
valnew=zeros(N_fit,1);
for n=1:N_fit
[est_out,fval,e] = fminsearch(myfun, init_new(:,n), options);
est_out=est_out./scl;
estnew(:,n)=est_out;
enew(:,n)=e;
valnew(:,n)=fval;
end
[a,b]=sort(valnew);
estnew=estnew(:,b);
enew=enew(:,b);
valnew=a;

options = optimset(@fminsearch);
options = optimset(options,'MaxFunEvals',2500,'MaxIter',1000,'TolFun',1e-3,'TolX',1e-8);
[est_out,fval,e]=fminsearch(myfun, init, options);
est_old=est_out;
[est_out,fval,e]=fminsearch(myfun, est_out, options);
save inflation_bonds\model-estimation\estimated-parameters.mat est_out fval e init mydata
