%Plot Figure 9
%This procedure makes plots comparing the results obtained from the models
%with/wo v
%10/6/2009 cpflueger@hbs.edu

clear;
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation\newdata')

load MATLAB\inflation_bonds\model-estimation\estimated-parameters_fixparams_nov_4.mat

prm=est_out;
y=mydata;

[yfts_nov, alphats_nov,xret_nov] = track_likelihood_fixparams_nov(prm,y);

load MATLAB\inflation_bonds\model-estimation\estimated-parameters_fixparams_5.mat
prm=est_out;
y=mydata;

[yfts, alphats,xret]=track_likelihood_fixparams(prm, y);

load MATLAB\inflation_bonds\model-estimation\estimated-parameters_fixphi.mat
prm=est_out;
y=mydata;
[yfts_fixphi, alphats_fixphi,xret_fixphi]=track_likelihood_fixphi(prm, y);

%Make plots
load Matlab\inflation_bonds\model-estimation\newdata\date.mat
t=datequart;
tfts=t;

figure(1);
plot(t,y(:,3)*400,tfts, yfts_nov(:,1)*400,':',tfts,yfts(:,1)*400,'--',tfts,yfts_fixphi(:,1)*400,'-.','LineWidth',2);
xlabel('Year');
ylabel('Yield (Annualized %)');
legend('Actual','Const. Covariance','Predicted','v Persistent','Location','SouthWest');
title('Fitting 10 year real yields');
axis([min(t) max(t) -1 4.5])
datetick('x',11)
saveas(gcf,'inflation_bonds\model\compareplots_mar16.pdf')
saveas(gcf,'inflation_bonds\model\compareplots_mar16.eps')
plot_matrix1=horzcat(m2xdate(t), y(:,3)*400);
plot_matrix2=horzcat(m2xdate(tfts), yfts_nov(:,1)*400,m2xdate(tfts),yfts(:,1)*400,m2xdate(tfts),yfts_fixphi(:,1)*400);
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\compareplots.xls',plot_matrix1,1,'A2')
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\compareplots.xls',plot_matrix2,1,'C2')

