%This program performs preliminary data transformations for the data needed
%to estimate the model of changing risks on TIPS
%10/6/2009 cpflueger@hbs.edu
%Extract stock returns and real yields at a quarterly frequency
clear;
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation\newdata');
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation');
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds');

[cpi, txt]=xlsread('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation\newdata\daily_deflator_US.xls',1);
days_cpi=datenum(txt);
[stock, txt]=xlsread('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation\newdata\stock-index-08.xls',1);
date_stock=stock(:,1);
stock=stock(:,2);
dt_m=date_stock;
%Convert dates from CRSP into MATLAB format
%Convert CRSP dates into MATLAB format
year_m=floor(dt_m/10000);
dt_m=dt_m-10000*year_m;
month_m=floor(dt_m/100);
dt_m=dt_m-100*month_m;
day_m=dt_m;

dt_m=[year_m month_m day_m];
dt_m=datenum(dt_m);
date_stock=dt_m;

[stock_monthly, txt]=xlsread('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation\newdata\stock-index-monthly.xls',1);
date_stock_monthly=stock_monthly(:,1);
stock_monthly=stock_monthly(:,2);
dt_m=date_stock_monthly;
%Convert dates from CRSP into MATLAB format
%Convert CRSP dates into MATLAB format
year_m=floor(dt_m/10000);
dt_m=dt_m-10000*year_m;
month_m=floor(dt_m/100);
dt_m=dt_m-100*month_m;
day_m=dt_m;

dt_m=[year_m month_m day_m];
dt_m=datenum(dt_m);
date_stock_monthly=dt_m;

[yields, txt]=xlsread('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation\newdata\real-yields-08.xls',1);
T=max(size(txt));
txt=txt(2:T,1);
date_yields=datenum(txt);
%Sort with dates ascending
[a,b]=sort(date_yields,'ascend');
yieldsnew=yields(b,:);
yields=yieldsnew;
date_yields=a;
%Get quarterly anticipated real riskfree rate - from VAR estimation
load inflation_bonds\model-estimation\frtb.mat dt3 frtbhyp dt4 rtbquart dt5 ntbquart dt6 inflquart
rfr=frtbhyp;
date_rfr=dt3;
%frtbhyp gives the forecasted real rate over the coming quarter
%inflquart gives the realized inflation rate over the coming quarter
%ntbquart gives the nominal short rate over the coming quarter
%rtbquart gives the realized real rate over the coming quarter

%Deflate monthly stock returns by CPI-truncate data before 1983
%Compute inflation over previous 3 months
T=max(size(cpi));
cpi3=cpi;
for t=4:T
    cpi3(t)=cpi(t)/cpi(t-3);
end
a=(date_stock_monthly>=datenum([1983 01 01]));
date_stock_monthly=date_stock_monthly(a);
stock_monthly=stock_monthly(a);
b=(days_cpi>=datenum([1983 01 01]));
days_cpi=days_cpi(b);
cpi3=cpi3(b);


%Cumulate stock returns over quarters
T=max(size(stock_monthly));
t=T/3;
date_q=zeros(t,1);
stock_q=zeros(t,1);

for s=1:t
    date_q(s)=date_stock_monthly(3*s);
    stock_q(s)=(1+stock_monthly(3*s-2))*(1+stock_monthly(3*s-1))*(1+stock_monthly(3*s))/cpi3(s);
end
%Take log stock returns
stock_q=log(stock_q);

%Find TIPS with maturities 2,5,10,20
TIPS2=yields(:,1);
TIPS5=yields(:,4);
TIPS10=yields(:,9);
TIPS15=yields(:,14);
TIPS20=yields(:,19);
%log yields
yield2=1/4*log(1+TIPS2/100);
yield5=1/4*log(1+TIPS5/100);
yield15=1/4*log(1+TIPS15/100);
yield10=1/4*log(1+TIPS10/100);
yield20=1/4*log(1+TIPS20/100);
%Synchronize dates- this gives all quarters from 1999 to end 2008
%date_q is quarterly date, end of quarter
[datequart, stockquart, yield2quart]=format_dates(date_q, date_yields, stock_q, yield2);
[datequart, stockquart, yield5quart]=format_dates(date_q, date_yields, stock_q, yield5);
[datequart, stockquart, yield10quart]=format_dates(date_q, date_yields, stock_q, yield10);
[datequart, stockquart, yield15quart]=format_dates(date_q, date_yields, stock_q, yield15);
[datequart, stockquart, yield20quart]=format_dates(date_q, date_yields, stock_q, yield20);
[date1, yield5test, shortrate]=format_dates(datequart, date_rfr,yield5quart, rfr);
[date2, yield5test, rtb]=format_dates(datequart, dt4,yield5quart, rtbquart);

%Estimate quarterly holding period returns
ret1=rfr;
T=max(size(yield5quart));
ret2=zeros(T,1);
ret5=zeros(T,1);
ret10=zeros(T,1);
ret20=zeros(T,1);
%Estimate holding period return over first quarter by starting with yield
%on 4 Jan 1999
ret2(1)=-7*yield2quart(1)+8*yield2(1);
ret5(1)=-19*yield5quart(1)+20*yield5(1);
ret10(1)=-39*yield10quart(1)+40*yield10(1);
ret15(1)=-59*yield15quart(1)+60*yield15(1);
ret20(1)=-79*yield20quart(1)+80*yield20(1);
for t=2:T
ret2(t)=-7*yield2quart(t)+8*yield2quart(t-1);
ret5(t)=-19*yield5quart(t)+20*yield5quart(t-1);
ret10(t)=-39*yield10quart(t)+40*yield10quart(t-1);
ret10(t)=-59*yield15quart(t)+60*yield15quart(t-1);
ret20(t)=-79*yield20quart(t)+80*yield20quart(t-1);
end

ret10=log(1+ret10);
%Make a plot to get an indication of what covariances should look like
plot(datequart, stockquart, datequart, ret10)
datetick('x',11)
title('Quarterly real returns to Stock and 10 Year TIPS')
legend('stock', 'TIPS')
saveas(gcf,'inflation_bonds\model-estimation\newdata\qtr_stock_bond.pdf')
pause()
%Plot series to check
figure(1)
plot(datequart, 400*shortrate, datequart, 400*yield2quart, datequart, 400*yield5quart, datequart, 400*yield10quart, datequart, 400*yield15quart, datequart, 400*yield20quart)
title('Quarterly time series of real yields')
legend('Short rate', '2 Year TIPS','5 Year TIPS', '10 Year TIPS', '15 Year TIPS', '20 Year TIPS','Location','SouthWest')
ylabel('Annualized Yields in %')
datetick('x',11)
saveas(gcf,'inflation_bonds\model-estimation\newdata\yields.pdf')
pause()

%Compute quarterly volatility (annualized) from daily return data for 10 year TIPS over past
%quarter

%Need to generate daily returns
T1=max(size(yield10));
dailyret10=zeros(T,1);
for t=2:T1
    dailyret10(t)=-40*yield10(t)+40*yield10(t-1);
end
dailyret10=dailyret10(2:T1);
%Compute log returns
dailyret10=log(dailyret10+ones(max(size(dailyret10)),1));
dateret=date_yields(2:T1);

T=max(size(datequart));
varTIPS=zeros(T,1);
%Test is just to check whether routine is working
test=varTIPS;
%Compute varTIPS(1) as in Viceira (2007)
a=and(dateret<=datequart(1), dateret>datenum([1999 01 01]));
TIPStemp=dailyret10(a);
    %Do not divide by 22*3, because I want to fit the variance of quarterly
%returns, should I try and demean?
varTIPS(1)=sum(TIPStemp.^2);
test(1)=sum(TIPStemp);
for t=2:T
    a=and(dateret<=datequart(t), dateret>datequart(t-1));
    TIPStemp=dailyret10(a);
    varTIPS(t)=sum(TIPStemp.^2);
    test(t)=sum(TIPStemp);
end
figure(2)
plot(datequart, sqrt(varTIPS))
datetick('x',11)
title('Standard deviation of 10 year TIPS returns over previous quarter in 1/4 year units')
saveas(gcf,'inflation_bonds\model-estimation\newdata\TIPSvariances.pdf')

%Compute quarterly covariance between 10 year TIPS and stock returns

%Synchronize dates of stock returns and TIPS, this deletes about 10
%observations
[datecov, stockcov, TIPS10cov]=format_dates(date_stock, date_yields, stock, yield10);
%Compute daily returns for bonds
T1=max(size(TIPS10cov));
dailyret10=zeros(T,1);
for t=2:T1
    dailyret10(t)=-40*TIPS10cov(t)+40*TIPS10cov(t-1);
end
dailyret10=dailyret10(2:T1);
%Compute log returns
dailyret10=log(dailyret10+ones(max(size(dailyret10)),1));
datecov=datecov(2:T1);
stockcov=stockcov(2:T1);
stockcov=log(stockcov+ones(max(size(stockcov)),1));

T=max(size(datequart));
covTIPS=zeros(T,1);
test=covTIPS;
teststock=covTIPS;
%Compute varTIPS(1) as in Viceira (2007)
a=and(datecov<=datequart(1), datecov>datenum([1999 01 01]));
TIPStemp=dailyret10(a);
    %Do not divide by 22*3, because I want to fit the variance of quarterly
%returns, should I try and demean?
stocktemp=stockcov(a);
covTIPS(1)=sum(TIPStemp.*stocktemp);
test(1)=sum(TIPStemp);
teststock(1)=sum(stocktemp);
for t=2:T
    a=and(datecov<=datequart(t), datecov>datequart(t-1));
    TIPStemp=dailyret10(a);
    stocktemp=stockcov(a);
    covTIPS(t)=sum(TIPStemp.*stocktemp);
    teststock(t)=sum(stocktemp);
    test(t)=sum(TIPStemp);
end

figure(1)
plot(datequart, covTIPS)
datetick('x',11)
title('Cov. 10 year TIPS yields and stock returns in 1/4-year units')
line([min(datequart) max(datequart)], [0 0],'color','k', 'Linestyle','--');
saveas(gcf,'inflation_bonds\model-estimation\newdata\covariances.pdf')
pause();

figure(2)
plot(datequart, 100*stockquart)
datetick('x',11)
title('Quarterly stock returns in %')
saveas(gcf,'inflation_bonds\model-estimation\newdata\stock.pdf')
pause();


mydata=[shortrate, yield5quart, yield10quart, yield20quart, stockquart, varTIPS, covTIPS, datequart];
%Realized excess return
xret10=ret10(2:max(size(ret10)))-rtb;
datexret=date2;
%Exclude data before 2003
%a=(datequart>=datenum([2003 01 01]));
%datequart=datequart(a);
%mydata=mydata(a,:);
save inflation_bonds\model-estimation\newdata\mydata.mat mydata
save inflation_bonds\model-estimation\newdata\date.mat datequart
save inflation_bonds\model-estimation\newdata\xret.mat xret10 datexret