% This preforms estimation routine for the full model in Figure 9
%10/6/2009 cpflueger@hbs.edu
clear;
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\model-estimation\newdata')

%Get data, this is formatted in prepare-datafeb22
load MATLAB\inflation_bonds\model-estimation\newdata\mydata.mat

% /* ___________________________________________________________________
% 
%    ________________________ ESTIMATION _______________________________
% 
%    ___________________________________________________________________
% */
%Compute unconditional standard deviation of stock returns
sigma_e=std(mydata(:,5));
%Set sigma_m equal to equity premium
sigma_m=0.46;
%Se bem accrodingly
bem=sigma_e/sigma_m;
epsilon_m=mydata(:,5)/bem;
T=max(size(epsilon_m));
inn_x=zeros(T-1,1);
eps_m=zeros(T-1,1);
for t=2:T
    inn_x(t-1)=mydata(t,1)-mydata(t-1,1);
    eps_m(t-1)=epsilon_m(t);
end
sigma_mx=cov(inn_x,eps_m);
sigma_mx=sigma_mx(1,2);
% order of parameters is: 
% mu_x|mu_z|mu_v|phi_x|phi_z|phi_v
% sigma_m|sigma_x|sigma_x'|sigma_z|sigma_v
% sigma_mx|sigma_mx'|sigma_mz|sigma_mv
% sigma_xx'|sigma_xz|sigma_xv|sigma_x'z|sigma_x'v
% sigma_zx
% sy(1:4)|svol|scov|seq|bex|bem|dummy03
%Fix z const, eps_v uncorrelated
   
%Choose starting value near phi_v=1
%3.5 corresponds to phi_v=0.97
init=[
   0.01;
   0.001005687204755;
   2.842295327171723;
   3.5;
   0.229999990137498;
   0.003136833401729;
  -0.000433257996890;
  -0.000009140475021;
   0.000585647964589;
   0.005];

scl=1;
init=init.*scl;


% ---- Estimation routine ---- 
% minimize -likelihood and save output

%Define myfun as a function of param - this way keep mydata fixed and
%optimize over param

%Can define myfun as a function of param values and init values - this
%effectively fixes some param values at their initial values and they don't
%get estimated
myfun = @(param)ukf_likelihood_fixparams(param,mydata);

options = optimset(@fminsearch);
options = optimset(options,'MaxFunEvals',2500,'MaxIter',1000,'TolFun',1e-3,'TolX',1e-8);
[est_out,fval,e]=fminsearch(myfun, init, options);
[est_out,fval,e]=fminsearch(myfun, est_out, options);
options = optimset(@fminsearch);
options = optimset(options,'MaxFunEvals',5000,'MaxIter',2000,'TolFun',1e-3,'TolX',1e-8);
[est_out,fval,e]=fminsearch(myfun, est_out, options);

save inflation_bonds\model-estimation\estimated-parameters.mat est_out fval e init mydata 
