%This function computes the dirty real price given yield and other
%parameters computed in nominal_yields_UK, follow the formula in DMO
%example calculations
%10/6/2009 cpflueger@hbs.edu
function px_yields_dirty=yield_to_px_UK(yields_new, coupon,D1, D2, f, d, n_coupons)
%Compute price from yield; Formula from DMO 
w=(1+yields_new/200).^(-1);
Term1=w.^(f./d);
Term2=D1;
Term3=w.*D2;
Term4=Term1;

N=size(yields_new,2);
for n=1:N
    Term4(:,n)=coupon(n)*(w(:,n).^2).*(1-w(:,n).^(n_coupons(:,n)-1))./(2*(1-w(:,n)));
end
Term5=100*w.^n_coupons;
px_yields_dirty=Term1.*(Term2+Term3+Term4+Term5);

%Remove Inf
a=(px_yields_dirty<500);
px_yields_dirty=px_yields_dirty.*a;
%Remove NaNs
px_yields_dirty=max(px_yields_dirty,0);
